/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.web.service;

import com.fr.fs.cache.ModuleCacheImpl;
import com.fr.fs.web.service.ServiceUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.VT4FR;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSMainGetModuleItemAction
extends ActionNoSessionCMD {
    private static final String[] EXCLUDE_MODULE;

    public String getCMD() {
        return "getmoduleitems";
    }

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"id");
        Locale locale = WebUtils.getLocale((HttpServletRequest)httpServletRequest);
        JSONObject jSONObject = ModuleCacheImpl.getInstance().getNodeInfo(Long.valueOf(string), ServiceUtils.getCurrentUserID(httpServletRequest), locale);
        this.createI18NModuleName(jSONObject, WebUtils.getLocale((HttpServletRequest)httpServletRequest));
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private void createI18NModuleName(JSONObject jSONObject, Locale locale) throws JSONException {
        if (jSONObject == null) {
            return;
        }
        jSONObject.put("text", (Object)Inter.getLocText((String)jSONObject.optString("key"), (Locale)locale));
        JSONArray jSONArray = jSONObject.optJSONArray("ChildNodes");
        jSONObject.put("isModule", true);
        if (jSONArray != null) {
            jSONObject.put("hasChildren", true);
            this.removeExclude(jSONObject, jSONArray);
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                this.createI18NModuleName(jSONObject2, locale);
            }
        } else {
            jSONObject.put("hasChildren", false);
        }
    }

    private void removeExclude(JSONObject jSONObject, JSONArray jSONArray) throws JSONException {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
            if (!this.isExcludeModule(jSONObject, jSONObject2)) continue;
            jSONArray.remove(i);
            return;
        }
    }

    private boolean isExcludeModule(JSONObject jSONObject, JSONObject jSONObject2) {
        if (jSONObject2 != null && jSONObject2.has("key")) {
            String string = jSONObject.optString("key");
            if (StringUtils.isEmpty((String)string)) {
                return false;
            }
            for (String string2 : EXCLUDE_MODULE) {
                if (!ComparatorUtils.equals((String)string2, (String)string)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        boolean bl = VT4FR.isLicAvailable((byte[])StableUtils.getBytes()) && VT4FR.FS_BI.support();
        EXCLUDE_MODULE = new String[]{bl ? "" : "FS-Module-Report_Manager"};
    }
}

