/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.schedule.job;

import com.fr.base.BaseXMLUtils;
import com.fr.base.Formula;
import com.fr.base.Parameter;
import com.fr.data.TableDataSource;
import com.fr.fs.schedule.ScheduleContext;
import com.fr.fs.schedule.ViewScheduleSavedInfo;
import com.fr.fs.web.ShowType;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.report.core.namespace.SimpleCellValueNameSpace;
import com.fr.report.report.Report;
import com.fr.schedule.entry.EntryManager;
import com.fr.schedule.task.ScheduleTask;
import com.fr.schedule.util.ExecuteCondition;
import com.fr.schedule.util.ExecuteType;
import com.fr.schedule.util.ScheduleLogUtils;
import com.fr.script.Calculator;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLWriter;
import com.fr.third.org.quartz.Job;
import com.fr.third.org.quartz.JobDataMap;
import com.fr.third.org.quartz.JobExecutionContext;
import com.fr.third.org.quartz.JobExecutionException;
import com.fr.web.core.Reportlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ReportletJob
implements Job {
    protected static final int MINUTES = 60;
    protected static final int MILLISECOND = 1000;
    protected static Set fireTimeAndTaskID = new HashSet();
    protected static final String FORMULA_PARAMETER_NAME = "executeFormula";
    protected ScheduleTask scheduleTask;
    protected String reportPath;
    protected Date scheduledFireTime;
    protected JobDataMap jobDataMap;
    protected long taskID;
    protected Reportlet reportlet;
    protected List<Map> record_list;
    protected List<Parameter> arrayParaList;
    protected FRLogger log = FRLogger.getLogger();

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (!this.initData(jobExecutionContext)) {
            return;
        }
        if (!this.checkExecuteClass()) {
            return;
        }
        this.executeReport();
    }

    protected abstract void executeReport();

    private boolean initData(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            this.scheduledFireTime = jobExecutionContext.getScheduledFireTime();
            this.jobDataMap = jobExecutionContext.getMergedJobDataMap();
            this.taskID = this.jobDataMap.getLong("__task__");
            if (this.checkIsDuplicated()) {
                return false;
            }
            this.scheduleTask = this.jobDataMap.get((Object)"__restarttask__") != null ? (ScheduleTask)this.jobDataMap.get((Object)"__restarttask__") : (ScheduleTask)ScheduleContext.createDAOSession().load(ScheduleTask.class, this.taskID);
            if (this.scheduleTask == null || this.scheduleTask.getScheduledOutput() == null && this.scheduleTask.getShowType() != ShowType.WRITE) {
                return false;
            }
            this.reportPath = this.scheduleTask.getReportletPath();
            if (this.reportPath == null) {
                this.logReportPathError();
                return false;
            }
            this.logTipInfo();
            return true;
        }
        catch (RuntimeException runtimeException) {
            ScheduleLogUtils.error(runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            ScheduleLogUtils.error(exception);
            return false;
        }
    }

    private boolean checkIsDuplicated() {
        if (fireTimeAndTaskID.contains(this.scheduledFireTime.getTime() + "_" + this.taskID)) {
            return true;
        }
        fireTimeAndTaskID.add(this.scheduledFireTime.getTime() + "_" + this.taskID);
        return false;
    }

    protected Parameter[] getExecuteParameter() {
        Parameter[] parameterArray = this.scheduleTask.getParametersToArray();
        if (this.scheduleTask.getExecuteType() == ExecuteType.FORMULA) {
            Parameter parameter = new Parameter();
            parameter.setName(FORMULA_PARAMETER_NAME);
            FormulaProvider formulaProvider = (FormulaProvider)StableFactory.createXmlObject((String)"Formula");
            formulaProvider.setContent(this.scheduleTask.getExecuteFormula());
            parameter.setValue((Object)formulaProvider);
            int n = 0;
            if (parameterArray != null) {
                n = parameterArray.length;
            }
            Parameter[] parameterArray2 = new Parameter[n + 1];
            if (n > 0) {
                System.arraycopy(parameterArray, 0, parameterArray2, 0, parameterArray.length);
            }
            parameterArray2[n] = parameter;
            return parameterArray2;
        }
        return parameterArray;
    }

    private boolean checkExecuteClass() {
        if (this.scheduleTask.getExecuteType() != ExecuteType.EXECUTECLASS) {
            return true;
        }
        return this.executeClass();
    }

    private boolean executeClass() {
        try {
            ExecuteCondition executeCondition;
            boolean bl;
            String string = this.scheduleTask.getExecuteClass();
            String string2 = ".class";
            if (string.endsWith(string2)) {
                string = string.substring(0, string.length() - string2.length());
            }
            if (!(bl = (executeCondition = (ExecuteCondition)GeneralUtils.classForName((String)string).newInstance()).execute())) {
                this.log.scheduleInfo(this.scheduleTask.getName(), this.getExecuteFailLog(), Inter.getLocText((String)"FS-Schedule-Skip_Execute"));
                this.restartTask();
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.scheduleError(this.scheduleTask.getName(), this.getExecuteFailLog(), (Throwable)exception);
            this.restartTask();
            return false;
        }
    }

    protected boolean checkExecuteFormula(Map map, ResultWorkBook resultWorkBook) {
        if (this.scheduleTask.getExecuteType() != ExecuteType.FORMULA) {
            return true;
        }
        try {
            Formula formula = (Formula)map.get(FORMULA_PARAMETER_NAME);
            Boolean bl = this.evaluateFormula(formula, resultWorkBook);
            if (!bl.booleanValue()) {
                this.log.scheduleInfo(this.scheduleTask.getName(), this.getExecuteFailLog(), Inter.getLocText((String)"FS-Schedule-Skip_Execute"));
                this.restartTask();
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.scheduleError(this.scheduleTask.getName(), this.getExecuteFailLog(), (Throwable)exception);
            this.restartTask();
            return false;
        }
    }

    protected void dealWithException(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheduleTask.getShowType() == ShowType.VIEW || this.scheduleTask.getShowType() == ShowType.VIEW) {
            stringBuilder.append(Inter.getLocText((String)"FS-Schedule-CPR_FAILED"));
        } else {
            stringBuilder.append(ScheduleLogUtils.combineByColon("FS-Schedule-Reporting_Action", Inter.getLocText((String)"FS-Generic-Simple_Failed")));
        }
        if (this.scheduleTask.getCounts() > 0) {
            stringBuilder.append(ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts()));
        }
        this.log.scheduleError(this.scheduleTask.getName(), stringBuilder.toString(), (Throwable)exception);
        this.restartTask();
        ScheduleLogUtils.error(exception);
    }

    protected void logReportPathError() {
        this.log.error("[Schedule] ReportletJob : Report path is Null...");
    }

    protected String getExecuteFailLog() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheduleTask.getShowType() == ShowType.WRITE) {
            stringBuilder.append(ScheduleLogUtils.combineByColon("FS-Schedule-Reporting_Action", Inter.getLocText((String)"FS-Generic-Simple_Skip")));
        } else {
            stringBuilder.append(Inter.getLocText((String)"FS-Schedule-CPR_SKIP"));
        }
        if (this.scheduleTask.getCounts() > 0) {
            stringBuilder.append(ScheduleLogUtils.combineByBrackets("RESTART", this.scheduleTask.getCounts()));
        }
        return stringBuilder.toString();
    }

    protected void logTipInfo() {
        this.log.info("[Schedule] The Task '" + this.scheduleTask.getName() + "' of " + this.reportPath + " starts! ReportPath : " + this.reportPath);
    }

    protected void restartTask() {
        EntryManager.reStartTask(this.scheduleTask, Integer.parseInt(this.scheduleTask.getRepeatTime()) * 60 * 1000);
    }

    protected Boolean evaluateFormula(Formula formula, ResultWorkBook resultWorkBook) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.scheduledFireTime.getTime());
        Calculator calculator = Calculator.createCalculator();
        calculator.set("$date", (Object)calendar.getTime());
        calculator.setAttribute(Report.KEY, (Object)resultWorkBook.getReport(0));
        calculator.pushNameSpace((NameSpace)SimpleCellValueNameSpace.getInstance());
        calculator.setAttribute(TableDataSource.KEY, (Object)resultWorkBook);
        try {
            Object object = calculator.evalValue((FormulaProvider)formula);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return false;
        }
        catch (UtilEvalError utilEvalError) {
            return false;
        }
    }

    protected void exportViewScheduleSavedInfo(File file, ViewScheduleSavedInfo viewScheduleSavedInfo) throws IOException {
        Object[] objectArray = viewScheduleSavedInfo.getParameterValues("fr_username");
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            File file2 = new File(file, StableUtils.pathJoin((String[])new String[]{objectArray[i].toString(), "info.xml"}));
            StableUtils.makesureFileExist((File)file2);
            BaseXMLUtils.writeXMLFile((OutputStream)new FileOutputStream(file2), (XMLWriter)viewScheduleSavedInfo);
        }
    }
}

