/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.PostCache;
import com.fr.fs.cache.PostCacheProvider;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;
import java.util.List;

public class PostCacheImpl
implements PostCacheProvider {
    private static PostCacheProvider postCacheProvider;

    public static PostCacheProvider getInstance() {
        if (postCacheProvider == null) {
            PostCacheImpl.initCacheImpl();
        }
        return postCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                postCacheProvider = new PostCacheImpl();
                RPC.registerSkeleton((Object)postCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                postCacheProvider = (PostCacheProvider)RPC.getProxy(PostCacheImpl.class, (String)string);
                break;
            }
            default: {
                postCacheProvider = new PostCacheImpl();
            }
        }
    }

    public void initCacheTree() {
        PostCache.initCacheTree();
    }

    public void reInit() {
        PostCache.reInit();
    }

    public void clearCache() throws Exception {
        PostCache.clearCache();
    }

    public void cache(Post post) {
        PostCache.cache(post);
    }

    public void cacheNewName(long l, String string) {
        PostCache.cacheNewName(l, string);
    }

    public boolean removeCache(long l) throws Exception {
        return PostCache.removeCache(l);
    }

    public Post getPost(long l) {
        return PostCache.getPost(l);
    }

    public Post getPostByName(String string) {
        return PostCache.getPostByName(string);
    }

    public String getPostName(long l) {
        return PostCache.getPostName(l);
    }

    public List getAllPost() throws Exception {
        return PostCache.getAllPost();
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                PostCacheImpl.postCacheProvider = null;
            }
        });
    }
}

