/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.cache.CacheProcessor;
import com.fr.fs.cache.EntryComparator;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.IDComparator;
import com.fr.fs.control.UserControl;
import com.fr.fs.privilege.base.FSPrivilegeTools;
import com.fr.fs.schedule.entry.FolderEntry;
import com.fr.fs.web.platform.entry.BaseEntry;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.fs.web.platform.entry.FileEntry;
import com.fr.fs.web.platform.entry.MobileBaseEntry;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.bridge.StableFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EntryTreeFolderNode
implements Serializable {
    private FolderEntry entry;
    private Map folderMap = new TreeMap(IDComparator.getInstance());
    private Map nodeMap = new TreeMap(EntryComparator.getInstance());

    protected EntryTreeFolderNode(FolderEntry folderEntry) {
        this.entry = folderEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFolder(long l, EntryTreeFolderNode entryTreeFolderNode) {
        if (entryTreeFolderNode == null || l < 0L) {
            return;
        }
        Map map = this.folderMap;
        synchronized (map) {
            this.folderMap.put(new Long(l), entryTreeFolderNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(Entry entry) {
        if (entry == null || entry.getId() < 0L) {
            return;
        }
        Map map = this.nodeMap;
        synchronized (map) {
            if (this.nodeMap == null) {
                this.nodeMap = new Hashtable();
            }
            this.nodeMap.put(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(Entry entry) {
        if (entry == null || entry.getId() < 0L) {
            return;
        }
        Map map = this.nodeMap;
        synchronized (map) {
            this.nodeMap.remove(EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFolderNode(long l) {
        if (l < 0L) {
            return;
        }
        Map map = this.folderMap;
        synchronized (map) {
            this.folderMap.remove(new Long(l));
        }
    }

    protected List removeAll() {
        Entry[] entryArray;
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        EntryTreeFolderNode[] entryTreeFolderNodeArray = this.getFolderNodes();
        if (entryTreeFolderNodeArray != null) {
            for (int i = 0; i < entryTreeFolderNodeArray.length; ++i) {
                arrayList.add(entryTreeFolderNodeArray[i].getFolder());
                arrayList.addAll(entryTreeFolderNodeArray[i].removeAll());
            }
        }
        if ((entryArray = this.getNodes()) != null) {
            for (int i = 0; i < entryArray.length; ++i) {
                arrayList.add(entryArray[i]);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getNodes() {
        Map map = this.nodeMap;
        synchronized (map) {
            Set set = this.nodeMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList arrayList = new ArrayList(this.nodeMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                arrayList.add(entry.getValue());
            }
            Entry[] entryArray = arrayList.toArray(new Entry[arrayList.size()]);
            Arrays.sort(entryArray, SORTINFOComparatorForEntry.getInstance());
            return entryArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getNodes(int n) {
        Map map = this.nodeMap;
        synchronized (map) {
            Entry[] entryArray;
            Set set = this.nodeMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList<Entry[]> arrayList = new ArrayList<Entry[]>(this.nodeMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entryArray = (Entry[])entry.getValue();
                if (entryArray.getEntryType() != n) continue;
                arrayList.add(entryArray);
            }
            entryArray = arrayList.toArray(new Entry[arrayList.size()]);
            Arrays.sort(entryArray, SORTINFOComparatorForEntry.getInstance());
            return entryArray;
        }
    }

    public boolean hasEntry(int n, long l) {
        Entry[] entryArray = this.getNodes(n);
        Object[] objectArray = entryArray;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            Entry entry = objectArray[i];
            if (entry.getId() != l) continue;
            return true;
        }
        for (Object object : objectArray = this.getFolderNodes()) {
            if (!((EntryTreeFolderNode)object).hasEntry(n, l)) continue;
            return true;
        }
        return false;
    }

    public long getNodeEntryID() {
        return this.entry.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryTreeFolderNode[] getFolderNodes() {
        Map map = this.folderMap;
        synchronized (map) {
            Set set = this.folderMap.entrySet();
            Iterator iterator = set.iterator();
            ArrayList arrayList = new ArrayList(this.folderMap.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                arrayList.add(entry.getValue());
            }
            EntryTreeFolderNode[] entryTreeFolderNodeArray = arrayList.toArray(new EntryTreeFolderNode[arrayList.size()]);
            Arrays.sort(entryTreeFolderNodeArray, SORTINFOComparator.getInstance());
            return entryTreeFolderNodeArray;
        }
    }

    public FolderEntry getFolder() {
        return this.entry;
    }

    protected FolderEntry getLClonedFolderEntry() {
        try {
            return (FolderEntry)this.entry.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    protected long getFolderParentID() {
        return this.entry.getParentId();
    }

    protected void setFolder(FolderEntry folderEntry) {
        this.entry = folderEntry;
    }

    public JSONObject createManagerJSONConfig(long l) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        return this.createManagerJSONConfig(set, false);
    }

    private JSONObject createManagerJSONConfig(Set set, boolean bl) throws JSONException {
        JSONObject jSONObject;
        int n;
        FolderEntry folderEntry = this.entry;
        if (!FSConfig.getProviderInstance().getAuthorizeAttr().isEditReportAuthority()) {
            bl = true;
        } else if (set != null && this.hasEditPrivileges(set, EntryTypeAndID.getInstance(folderEntry.getEntryType(), folderEntry.getId(), 1L, 1L, 1L))) {
            bl = true;
        }
        Object[] objectArray = this.getFolderNodes();
        JSONArray jSONArray = null;
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            jSONArray = new JSONArray();
            for (n = 0; n < objectArray.length; ++n) {
                jSONObject = super.createManagerJSONConfig(set, bl);
                if (jSONObject == null) continue;
                jSONArray.put((Object)jSONObject);
            }
        }
        n = 1;
        if (FSConfig.getProviderInstance().getAuthorizeAttr().isEditReportAuthority()) {
            n = this.hasEditLeafPrivilege(set, EntryTypeAndID.getInstance(folderEntry.getEntryType(), folderEntry.getId())) ? 1 : 0;
        }
        if (!(bl || jSONArray != null && jSONArray.length() != 0 || n != 0)) {
            return null;
        }
        jSONObject = this.entry.createJSONConfig(false);
        if (bl) {
            jSONObject.put("permission", true);
        }
        if (jSONArray != null) {
            jSONObject.put("ChildNodes", (Object)jSONArray);
            jSONObject.put("hasChildren", true);
        } else {
            jSONObject.put("leaf", true);
            jSONObject.put("hasChildren", false);
        }
        return jSONObject;
    }

    public JSONArray createAllEntryJSONArrayNoCheck() throws JSONException {
        JSONArray jSONArray = this.createAllDeviceFSEntryJSONArray(null, null, true, false, 7L);
        if (jSONArray == null) {
            return new JSONArray();
        }
        return jSONArray;
    }

    public JSONArray createAuthorizedEntryJSONArray(long l) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
        for (EntryTypeAndID entryTypeAndID : set) {
            if (entryTypeAndID.getAuthorized() != 0L || !FSConfig.getProviderInstance().getAuthorizeAttr().isGradeAuthority()) continue;
            hashSet.add(entryTypeAndID);
        }
        set.removeAll(hashSet);
        return this.createDeviceEntryJSONArrayOfPrivilegeSet(set, l, false, 7L);
    }

    public JSONArray createAllEntryJSONArray(long l, boolean bl) throws Exception {
        return this.createAllDeviceEntryJSONArray(l, bl, 7L);
    }

    public JSONArray createAllDeviceEntryJSONArray(long l, boolean bl, long l2) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        return this.createDeviceEntryJSONArrayOfPrivilegeSet(set, l, bl, l2);
    }

    public FolderEntry[] getAllShowFolderNoPVCheck() {
        EntryTreeFolderNode[] entryTreeFolderNodeArray = this.getFolderNodes();
        ArrayList<FolderEntry> arrayList = new ArrayList<FolderEntry>();
        if (entryTreeFolderNodeArray != null) {
            for (int i = 0; i < entryTreeFolderNodeArray.length; ++i) {
                arrayList.add(entryTreeFolderNodeArray[i].getLClonedFolderEntry());
            }
            return arrayList.toArray(new FolderEntry[arrayList.size()]);
        }
        return null;
    }

    public FolderEntry[] getShowFolderEntrys(long l) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        boolean bl = false;
        if (set != null && set.contains(EntryTypeAndID.getInstance(0, -1L))) {
            bl = true;
        }
        EntryTreeFolderNode[] entryTreeFolderNodeArray = this.getFolderNodes();
        ArrayList<FolderEntry> arrayList = new ArrayList<FolderEntry>();
        if (entryTreeFolderNodeArray != null) {
            for (int i = 0; i < entryTreeFolderNodeArray.length; ++i) {
                if (!bl && !entryTreeFolderNodeArray[i].isVisible(set)) continue;
                arrayList.add(entryTreeFolderNodeArray[i].getLClonedFolderEntry());
            }
            return arrayList.toArray(new FolderEntry[arrayList.size()]);
        }
        return null;
    }

    private JSONArray createDeviceEntryJSONArrayOfPrivilegeSet(Set set, long l, boolean bl, long l2) throws Exception {
        List list;
        boolean bl2 = false;
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(0, -1L, 1L, 0L, 0L);
        if (set != null && set.contains(entryTypeAndID)) {
            bl2 = true;
        }
        HashMap<EntryTypeAndID, Long> hashMap = null;
        if (bl && (list = UserControl.getInstance().getFavoriteNodes(l)) != null) {
            hashMap = new HashMap<EntryTypeAndID, Long>();
            for (Object e : list) {
                FavoriteNode favoriteNode = (FavoriteNode)((Object)e);
                hashMap.put(EntryTypeAndID.getInstance(favoriteNode.getType(), favoriteNode.getEntryid()), new Long(favoriteNode.getId()));
            }
        }
        if ((list = this.createAllDeviceFSEntryJSONArray(set, hashMap, bl2, true, l2)) == null) {
            return new JSONArray();
        }
        return list;
    }

    private boolean isVisible(Set set) {
        EntryTreeFolderNode[] entryTreeFolderNodeArray;
        if (set == null) {
            return false;
        }
        FolderEntry folderEntry = this.getFolder();
        if (set.contains(EntryTypeAndID.getInstance(folderEntry.getEntryType(), folderEntry.getId()))) {
            return true;
        }
        Entry[] entryArray = this.getNodes();
        if (entryArray != null) {
            for (int i = 0; i < entryArray.length; ++i) {
                if (!set.contains(EntryTypeAndID.getInstance(entryArray[i].getEntryType(), entryArray[i].getId()))) continue;
                return true;
            }
        }
        if ((entryTreeFolderNodeArray = this.getFolderNodes()) != null) {
            for (int i = 0; i < entryTreeFolderNodeArray.length; ++i) {
                if (!entryTreeFolderNodeArray[i].isVisible(set)) continue;
                return true;
            }
        }
        return false;
    }

    private JSONObject createDeviceFSJSONConfig(Set set, Map map, boolean bl, long l) throws JSONException {
        JSONArray jSONArray = this.createAllDeviceFSEntryJSONArray(set, map, bl, true, l);
        if (!bl && jSONArray == null) {
            return null;
        }
        JSONObject jSONObject = this.entry.createJSONConfig(true);
        jSONObject.put("ChildNodes", (Object)jSONArray);
        jSONObject.put("view", 1);
        jSONObject.put("design", 1);
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(this.entry.getEntryType(), this.entry.getId());
        entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, entryTypeAndID);
        jSONObject.put("edit", entryTypeAndID.getEdit());
        if (entryTypeAndID.getEdit() != 1L && entryTypeAndID.getView() != 1L && entryTypeAndID.getAuthorized() != 1L) {
            jSONObject.put("isAllChildrenIn", false);
        }
        return jSONObject;
    }

    private JSONArray createAllDeviceFSEntryJSONArray(Set set, Map map, boolean bl, boolean bl2, long l) throws JSONException {
        EntryTypeAndID entryTypeAndID;
        EntryTreeFolderNode[] entryTreeFolderNodeArray;
        JSONArray jSONArray = new JSONArray();
        if (set != null) {
            entryTreeFolderNodeArray = this.entry;
            entryTypeAndID = EntryTypeAndID.getInstance(entryTreeFolderNodeArray.getEntryType(), entryTreeFolderNodeArray.getId());
            entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, entryTypeAndID);
            if (entryTypeAndID.getView() == 1L) {
                bl = true;
            }
        }
        if ((entryTreeFolderNodeArray = this.getFolderNodes()) != null) {
            for (EntryTreeFolderNode entryTreeFolderNode : entryTreeFolderNodeArray) {
                if ((entryTreeFolderNode.getFolder().getMobileDeviceConfig() & l) == 0L || (entryTypeAndID = entryTreeFolderNode.createDeviceFSJSONConfig(set, map, bl, l)) == null) continue;
                jSONArray.put((Object)entryTypeAndID);
            }
        }
        if (bl2) {
            this.addDeviceLeafEntryJSONArray(jSONArray, set, map, bl, true, l);
        }
        if (jSONArray.length() == 0) {
            return null;
        }
        return jSONArray;
    }

    private boolean hasEditPrivileges(Set set, EntryTypeAndID entryTypeAndID) {
        for (Object e : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e;
            if (!ComparatorUtils.equals((Object)entryTypeAndID2, (Object)entryTypeAndID) || entryTypeAndID2.getEdit() != 1L) continue;
            return true;
        }
        return false;
    }

    private boolean hasEditLeafPrivilege(Set set, EntryTypeAndID entryTypeAndID) {
        for (Object e : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e;
            if (!ComparatorUtils.equals((Object)entryTypeAndID2, (Object)entryTypeAndID) || entryTypeAndID2.getEdit() == 0L) continue;
            return true;
        }
        return false;
    }

    public JSONArray createLeafEntryJSONArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        this.addDeviceLeafEntryJSONArray(jSONArray, null, null, true, false, 7L);
        return jSONArray;
    }

    public JSONArray createLeafEntryJSONArray(long l) throws Exception {
        Set set = UserControl.getInstance().getAllEntryPrivileges(l);
        JSONArray jSONArray = new JSONArray();
        this.addEditableLeafEntryJSONArray(jSONArray, set);
        return jSONArray;
    }

    private void addEditableLeafEntryJSONArray(JSONArray jSONArray, Set set) throws Exception {
        Entry[] entryArray = this.getNodes();
        ArrayList arrayList = new ArrayList();
        if (entryArray != null) {
            for (int i = 0; i < entryArray.length; ++i) {
                EntryTypeAndID entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, EntryTypeAndID.getInstance(entryArray[i].getEntryType(), entryArray[i].getId()));
                if (FSConfig.getProviderInstance().getAuthorizeAttr().isEditReportAuthority() && entryTypeAndID.getEdit() != 1L) continue;
                if (entryArray[i] instanceof FileEntry) {
                    CacheProcessor cacheProcessor;
                    if (!((FileEntry)entryArray[i]).isCpr() || (cacheProcessor = (CacheProcessor)StableFactory.getMarkedInstanceObjectFromClass((String)"CacheProcessor", CacheProcessor.class)) == null) continue;
                    cacheProcessor.createScheduleFileEntryJSONObject(arrayList, jSONArray, false, null, entryArray[i], entryTypeAndID, this);
                    continue;
                }
                this.createEntryJSONConfig(jSONArray, false, null, entryArray[i], entryTypeAndID);
            }
        }
    }

    private void addDeviceLeafEntryJSONArray(JSONArray jSONArray, Set set, Map map, boolean bl, boolean bl2, long l) throws JSONException {
        Entry[] entryArray = this.getNodes();
        ArrayList arrayList = new ArrayList();
        if (entryArray != null) {
            for (Entry entry : entryArray) {
                EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId());
                entryTypeAndID = FSPrivilegeTools.getInstance().getEntryPrivilege(set, entryTypeAndID);
                if (!bl && entryTypeAndID.getView() != 1L) continue;
                this.createDeviceLeafEntryJSONConfig(jSONArray, arrayList, map, entry, entryTypeAndID, bl2, l);
            }
        }
    }

    private void createDeviceLeafEntryJSONConfig(JSONArray jSONArray, List list, Map map, Entry entry, EntryTypeAndID entryTypeAndID, boolean bl, long l) throws JSONException {
        if (this.shouldShow(entry, l)) {
            if (this.isCpr(entry)) {
                CacheProcessor cacheProcessor = (CacheProcessor)StableFactory.getMarkedInstanceObjectFromClass((String)"CacheProcessor", CacheProcessor.class);
                if (cacheProcessor != null) {
                    cacheProcessor.createScheduleFileEntryJSONObject(list, jSONArray, bl, map, entry, entryTypeAndID, this);
                }
            } else {
                this.createEntryJSONConfig(jSONArray, bl, map, entry, entryTypeAndID);
            }
        }
    }

    private boolean shouldShow(Entry entry, long l) {
        if (entry instanceof FileEntry && !((FileEntry)entry).isCpr()) {
            return false;
        }
        return !(entry instanceof MobileBaseEntry) || (((MobileBaseEntry)entry).getMobileDeviceConfig() & l) != 0L;
    }

    private boolean isCpr(Entry entry) {
        return entry instanceof FileEntry && ((FileEntry)entry).isCpr();
    }

    private void createScheduleFileEntryJSONObject(List list, JSONArray jSONArray, boolean bl, Map map, Entry entry, EntryTypeAndID entryTypeAndID, EntryTreeFolderNode entryTreeFolderNode) {
    }

    private void createEntryJSONConfig(JSONArray jSONArray, boolean bl, Map map, Entry entry, EntryTypeAndID entryTypeAndID) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject = bl ? entry.createShowJSONConfig() : entry.createJSONConfig();
        if (map != null) {
            Long l;
            if (entryTypeAndID == null) {
                entryTypeAndID = EntryTypeAndID.getInstance(entry.getEntryType(), entry.getId());
            }
            if ((l = (Long)map.get(entryTypeAndID)) != null) {
                jSONObject.put("favoriteid", l.longValue());
            }
        }
        jSONObject.put("showType", (Object)entry.getShowType());
        jSONObject.put("view", entryTypeAndID == null ? 0L : entryTypeAndID.getView());
        jSONObject.put("design", entryTypeAndID == null ? 0L : entryTypeAndID.getAuthorized());
        jSONObject.put("edit", entryTypeAndID == null ? 0L : entryTypeAndID.getEdit());
        jSONArray.put((Object)jSONObject);
    }

    private static class SORTINFOComparatorForEntry
    implements Comparator {
        private static SORTINFOComparatorForEntry SC = new SORTINFOComparatorForEntry();

        private SORTINFOComparatorForEntry() {
        }

        public static SORTINFOComparatorForEntry getInstance() {
            return SC;
        }

        public int compare(Object object, Object object2) {
            BaseEntry baseEntry = (BaseEntry)object;
            BaseEntry baseEntry2 = (BaseEntry)object2;
            if (ComparatorUtils.equals((String)baseEntry.getTypePrefix(), (String)baseEntry2.getTypePrefix())) {
                long l;
                long l2 = baseEntry.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry.getSortindex();
                long l3 = l2 - (l = baseEntry2.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry2.getSortindex());
                if (l3 > 0L) {
                    return 1;
                }
                if (l3 == 0L) {
                    long l4 = baseEntry.getId() - baseEntry2.getId();
                    if (l4 > 0L) {
                        return 1;
                    }
                    if (l4 == 0L) {
                        return 0;
                    }
                    return -1;
                }
                return -1;
            }
            return 0;
        }
    }

    private static class SORTINFOComparator
    implements Comparator {
        private static SORTINFOComparator SC = new SORTINFOComparator();

        private SORTINFOComparator() {
        }

        public static SORTINFOComparator getInstance() {
            return SC;
        }

        public int compare(Object object, Object object2) {
            long l;
            if (object instanceof EntryTreeFolderNode) {
                object = ((EntryTreeFolderNode)object).getFolder();
                object2 = ((EntryTreeFolderNode)object2).getFolder();
            }
            if (!(object instanceof BaseEntry) || !(object2 instanceof BaseEntry)) {
                return 0;
            }
            BaseEntry baseEntry = (BaseEntry)object;
            BaseEntry baseEntry2 = (BaseEntry)object2;
            long l2 = baseEntry.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry.getSortindex();
            long l3 = l2 - (l = baseEntry2.getSortindex() == 0L ? Integer.MAX_VALUE : baseEntry2.getSortindex());
            if (l3 > 0L) {
                return 1;
            }
            if (l3 == 0L) {
                long l4 = baseEntry.getId() - baseEntry2.getId();
                if (l4 > 0L) {
                    return 1;
                }
                if (l4 == 0L) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    }
}

