/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.auth;

import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.fs.auth.DefaultAuthenticateObjectType;
import com.fr.fs.auth.HttpAuthenticateObjectType;
import com.fr.fs.auth.LdapAuthenticateObjectType;
import com.fr.general.FRLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticateObjectTypeBuilder {
    private static Map<String, Class<? extends AuthenticateObjectType>> map = new ConcurrentHashMap<String, Class<? extends AuthenticateObjectType>>();

    public static void register(String string, Class<? extends AuthenticateObjectType> clazz) {
        if (map.containsKey(string)) {
            throw new RuntimeException("Duplicate key!");
        }
        map.put(string, clazz);
    }

    public static AuthenticateObjectType build(String string) {
        Class<? extends AuthenticateObjectType> clazz = map.get(string);
        if (clazz == null) {
            clazz = DefaultAuthenticateObjectType.class;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            FRLogger.getLogger().error(instantiationException.getMessage(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRLogger.getLogger().error(illegalAccessException.getMessage(), (Throwable)illegalAccessException);
        }
        return new DefaultAuthenticateObjectType();
    }

    static {
        map.put("default", DefaultAuthenticateObjectType.class);
        map.put("http", HttpAuthenticateObjectType.class);
        map.put("ldap", LdapAuthenticateObjectType.class);
    }
}

