/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jshx.smgp.message;

import cn.com.jshx.smgp.bean.Submit;
import cn.com.jshx.smgp.message.Message;
import cn.com.jshx.smgp.protocol.RequestId;
import cn.com.jshx.smgp.protocol.Tlv;
import cn.com.jshx.smgp.protocol.TlvId;
import cn.com.jshx.smgp.protocol.TlvUtil;
import cn.com.jshx.util.TypeConvert;

public class SubmitMessage
extends Message {
    private Submit submit;

    public SubmitMessage(byte[] buffer) {
        this.sequence_Id = TypeConvert.byte2int(buffer, 4);
        this.submit = new Submit();
        this.submit.setMsgType(buffer[8]);
        this.submit.setNeedReport(buffer[9]);
        this.submit.setPriority(buffer[10]);
        this.submit.setServiceID(TypeConvert.getString(buffer, 11, 0, 10));
        this.submit.setFeetype(TypeConvert.getString(buffer, 21, 0, 2));
        this.submit.setFeeCode(TypeConvert.getString(buffer, 23, 0, 6));
        this.submit.setFixedFee(TypeConvert.getString(buffer, 29, 0, 6));
        this.submit.setMsgFormat(buffer[35]);
        this.submit.setValidTime(TypeConvert.getString(buffer, 36, 0, 17));
        this.submit.setAtTime(TypeConvert.getString(buffer, 53, 0, 17));
        this.submit.setSrcTermid(TypeConvert.getString(buffer, 70, 0, 21));
        this.submit.setChargeTermid(TypeConvert.getString(buffer, 91, 0, 21));
        this.submit.setDestTermIDCountOnly4Server(buffer[112]);
        int cur = 113;
        if (this.submit.getDestTermIDCount() == 1) {
            this.submit.setDestTermid(TypeConvert.getString(buffer, cur, 0, 21));
            cur += 21;
        } else {
            String[] destTermidArray = new String[this.submit.getDestTermIDCount()];
            int i = 0;
            while (i < this.submit.getDestTermIDCount()) {
                destTermidArray[i] = TypeConvert.getString(buffer, cur, 0, 21);
                cur += 21;
                ++i;
            }
            this.submit.setDestTermIDArrayOnly4Server(destTermidArray);
        }
        this.submit.setMsgLength(buffer[cur] & 0xFF);
        byte[] message = new byte[this.submit.getMsgLength()];
        System.arraycopy(buffer, ++cur, message, 0, message.length);
        this.submit.setMsgContent(message);
        byte[] reserv = new byte[8];
        System.arraycopy(buffer, cur += message.length, reserv, 0, reserv.length);
        if ((cur += 8) < buffer.length) {
            byte[] tlv = new byte[buffer.length - cur];
            System.arraycopy(buffer, cur, tlv, 0, tlv.length);
            Tlv[] otherTlv = TlvUtil.TlvAnalysis(tlv);
            this.submit.setOtherTlvArray(otherTlv);
            int i = 0;
            while (i < otherTlv.length) {
                if (otherTlv[i].Tag == TlvId.LinkID) {
                    this.submit.setLinkID(otherTlv[i].Value);
                } else if (otherTlv[i].Tag == TlvId.Mserviceid) {
                    this.submit.setProductID(otherTlv[i].Value);
                } else if (otherTlv[i].Tag == TlvId.TP_udhi) {
                    this.submit.setTP_udhi(Integer.parseInt(otherTlv[i].Value));
                }
                ++i;
            }
        }
    }

    public SubmitMessage(int msgtype, int needreport, int priority, String serviceid, String feetype, String feecode, String fixedfee, int msgformat, String validtime, String attime, String srctermid, String chargetermid, String[] desttermid, int msglength, byte[] msgcontent, byte[] reserve, Tlv[] tlvarray, int SequenceId) {
        this.sequence_Id = SequenceId;
        int tlvlength = 0;
        int i = 0;
        while (i < tlvarray.length) {
            tlvlength += tlvarray[i].TlvBuf.length;
            ++i;
        }
        int len = 126 + 21 * desttermid.length + msgcontent.length + tlvlength;
        this.buf = new byte[len];
        TypeConvert.int2byte(len, this.buf, 0);
        TypeConvert.int2byte(RequestId.Submit, this.buf, 4);
        TypeConvert.int2byte(this.sequence_Id, this.buf, 8);
        this.buf[12] = (byte)msgtype;
        this.buf[13] = (byte)needreport;
        this.buf[14] = (byte)priority;
        System.arraycopy(serviceid.getBytes(), 0, this.buf, 15, serviceid.length());
        System.arraycopy(feetype.getBytes(), 0, this.buf, 25, feetype.length());
        System.arraycopy(feecode.getBytes(), 0, this.buf, 27, feecode.length());
        System.arraycopy(fixedfee.getBytes(), 0, this.buf, 33, fixedfee.length());
        this.buf[39] = (byte)msgformat;
        if (validtime != null && validtime.length() > 0) {
            System.arraycopy(validtime.getBytes(), 0, this.buf, 40, 16);
        }
        if (attime != null && attime.length() > 0) {
            System.arraycopy(attime.getBytes(), 0, this.buf, 57, 16);
        }
        System.arraycopy(srctermid.getBytes(), 0, this.buf, 74, srctermid.length());
        System.arraycopy(chargetermid.getBytes(), 0, this.buf, 95, chargetermid.length());
        this.buf[116] = (byte)desttermid.length;
        int i2 = 0;
        i2 = 0;
        while (i2 < desttermid.length) {
            System.arraycopy(desttermid[i2].getBytes(), 0, this.buf, 117 + i2 * 21, desttermid[i2].length());
            ++i2;
        }
        int loc = 117 + i2 * 21;
        this.buf[loc] = (byte)msgcontent.length;
        System.arraycopy(msgcontent, 0, this.buf, loc + 1, msgcontent.length);
        loc = loc + msgcontent.length + 1;
        if (reserve != null) {
            System.arraycopy(reserve, 0, this.buf, loc, reserve.length);
        }
        loc += 8;
        i2 = 0;
        while (i2 < tlvarray.length) {
            System.arraycopy(tlvarray[i2].TlvBuf, 0, this.buf, loc, tlvarray[i2].TlvBuf.length);
            loc += tlvarray[i2].TlvBuf.length;
            ++i2;
        }
    }

    public Submit getSubmit() {
        return this.submit;
    }
}

