/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.gauge.glyph;

import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.FRFont;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.plugin.chart.base.AttrLabel;
import com.fr.plugin.chart.base.AttrLabelDetail;
import com.fr.plugin.chart.gauge.GaugeDetailStyle;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyph;
import com.fr.plugin.chart.gauge.glyph.GaugeGlyphHelper;
import com.fr.plugin.chart.glyph.axis.VanChartGaugeAxisGlyph;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class SlotGaugeGlyph
extends GaugeGlyph {
    private static final long serialVersionUID = -306297840432154041L;
    private static final double SLOT = 0.08;
    private static final double NEEDLE = 0.048;
    private static final int START_ANGLE = 225;
    private static final int EXTENT = -270;
    private static final int END_ANGLE = -45;
    private Color valueColor = Color.black;
    private double percentLabelCenterY;
    private double valueLabelCenterY;

    public SlotGaugeGlyph(Rectangle2D rectangle2D, AttrLabel attrLabel, GaugeDetailStyle gaugeDetailStyle, VanChartGaugeAxisGlyph vanChartGaugeAxisGlyph) {
        super(rectangle2D, attrLabel, gaugeDetailStyle, vanChartGaugeAxisGlyph);
    }

    @Override
    protected void initStartAngleAndExtent() {
        this.startAngle = 225;
        this.extent = -270;
    }

    @Override
    public void doLayout(double d, int n) {
        super.doLayout(d, n);
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            boolean bl = this.attrLabel.getAttrLabelDetail().getContent().hasLabelContent();
            boolean bl2 = this.attrLabel.getGaugeValueLabelDetail().getContent().hasLabelContent();
            double d2 = GaugeGlyphHelper.calculateTextDimension(this.valueLabelString, this.attrLabel.getGaugeValueLabelDetail().getTextAttr().getFRFont(), n).getHeight();
            if (bl && bl2) {
                double d3 = d + d / 2.0 + d2;
                this.percentLabelCenterY = this.centerPoint.getY() - d3 / 2.0 + d / 2.0;
                this.valueLabelCenterY = this.percentLabelCenterY + d + d2 / 2.0;
            } else {
                this.percentLabelCenterY = this.centerPoint.getY();
                this.valueLabelCenterY = this.centerPoint.getY();
            }
        }
    }

    @Override
    protected void drawInfo(Graphics2D graphics2D, int n) {
        double d = this.radius - this.radius * 0.08;
        double d2 = this.centerPoint.getX() + d * Math.cos(3.9269908169872414);
        double d3 = this.centerPoint.getY() - d * Math.sin(3.9269908169872414);
        double d4 = this.centerPoint.getX() + d * Math.cos(-0.7853981633974483);
        double d5 = this.centerPoint.getY() - d * Math.sin(-0.7853981633974483);
        Point2D.Double double_ = new Point2D.Double(d2, d3);
        Point2D.Double double_2 = new Point2D.Double(d4, d5);
        if (this.valueList.isEmpty()) {
            return;
        }
        double d6 = ((Number)this.valueList.get(0)).doubleValue();
        double d7 = this.gaugeAxisGlyph.getMinValue();
        double d8 = this.gaugeAxisGlyph.getMaxValue();
        double d9 = Math.max((double)this.extent, (double)this.extent / (d8 - d7) * (d6 - d7));
        d9 = Math.min(d9, 0.0);
        double d10 = (double)this.startAngle + d9;
        double d11 = this.centerPoint.getX() + d * Math.cos(Math.PI * (d10 / 180.0));
        double d12 = this.centerPoint.getY() - d * Math.sin(Math.PI * (d10 / 180.0));
        Point2D.Double double_3 = new Point2D.Double(d11, d12);
        this.valueColor = this.getValueColor(d6, d7, d8);
        this.drawSlot(graphics2D, double_, double_2);
        this.drawValueArc(graphics2D, double_, double_3, d9);
        this.drawNeedle(graphics2D, double_3);
        this.drawCateOrPercentageLabel(graphics2D, n);
        this.drawValueLabel(graphics2D, n);
    }

    private void drawSlot(Graphics2D graphics2D, Point2D point2D, Point2D point2D2) {
        Color color = GaugeGlyphHelper.getColor(this.gaugeDetailStyle.getSlotBackgroundColor());
        double d = this.radius * 0.08;
        GaugeGlyphHelper.drawArcStroke(graphics2D, this.centerPoint, this.radius - d * 2.0, this.radius, 225.0, -270.0, color);
        GaugeGlyphHelper.drawCircle(graphics2D, point2D, d, color);
        GaugeGlyphHelper.drawCircle(graphics2D, point2D2, d, color);
    }

    private void drawValueArc(Graphics2D graphics2D, Point2D point2D, Point2D point2D2, double d) {
        double d2 = this.radius * 0.08;
        GaugeGlyphHelper.drawArcStroke(graphics2D, this.centerPoint, this.radius - d2 * 2.0, this.radius, 225.0, d, this.valueColor);
        GaugeGlyphHelper.drawCircle(graphics2D, point2D, d2, this.valueColor);
        GaugeGlyphHelper.drawCircle(graphics2D, point2D2, d2, this.valueColor);
    }

    private void drawNeedle(Graphics2D graphics2D, Point2D point2D) {
        GaugeGlyphHelper.drawCircle(graphics2D, point2D, this.radius * 0.048, this.gaugeDetailStyle.getNeedleColor());
    }

    @Override
    protected void setCateOrPercentLabelAutoFont(TextAttr textAttr) {
        textAttr.setFRFont(FRFont.getInstance((String)"verdana", (int)1, (float)27.0f, (Color)this.valueColor));
    }

    @Override
    protected Rectangle2D getCateOrPercentLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        return new Rectangle2D.Double(d, this.percentLabelCenterY - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected void drawValueLabel(Graphics2D graphics2D, int n) {
        if (this.attrLabel != null && this.attrLabel.isEnable()) {
            AttrLabelDetail attrLabelDetail = this.attrLabel.getGaugeValueLabelDetail();
            TextAttr textAttr = attrLabelDetail.getTextAttr();
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation((String)this.valueLabelString, (TextAttr)textAttr, (int)n);
            Rectangle2D rectangle2D = this.getValueLabelBounds(attrLabelDetail.getPosition(), dimension2D);
            TextGlyph textGlyph = new TextGlyph(this.valueLabelString, textAttr);
            textGlyph.setBounds((RectangularShape)rectangle2D);
            textGlyph.draw((Graphics)graphics2D, n);
        }
    }

    @Override
    protected Rectangle2D getValueLabelBounds(int n, Dimension2D dimension2D) {
        double d = this.centerPoint.getX() - dimension2D.getWidth() / 2.0;
        return new Rectangle2D.Double(d, this.valueLabelCenterY - dimension2D.getHeight() / 2.0, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    public String getValueLabelWithDataPoint(DataPoint dataPoint) {
        return VanChartAttrHelper.getSlotCateAndValue(this.attrLabel.getGaugeValueLabelDetail().getContent(), dataPoint);
    }
}

