/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.other;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.web.ChartHyperPoplink;
import com.fr.chart.web.ChartHyperRelateCellLink;
import com.fr.chart.web.ChartHyperRelateFloatLink;
import com.fr.design.beans.BasicBeanPane;
import com.fr.design.chart.javascript.ChartEmailPane;
import com.fr.design.dialog.BasicScrollPane;
import com.fr.design.formula.TinyFormulaPane;
import com.fr.design.gui.frpane.UICorrelationComboBoxPane;
import com.fr.design.gui.ibutton.UIButtonGroup;
import com.fr.design.gui.ibutton.UIToggleButton;
import com.fr.design.gui.icheckbox.UICheckBox;
import com.fr.design.gui.ilable.UILabel;
import com.fr.design.gui.imenutable.UIMenuNameableCreator;
import com.fr.design.gui.ispinner.UISpinner;
import com.fr.design.layout.TableLayoutHelper;
import com.fr.design.utils.gui.GUICoreUtils;
import com.fr.general.Inter;
import com.fr.js.EmailJavaScript;
import com.fr.js.FormHyperlinkProvider;
import com.fr.js.JavaScript;
import com.fr.js.JavaScriptImpl;
import com.fr.js.NameJavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.js.ParameterJavaScript;
import com.fr.js.ReportletHyperlink;
import com.fr.js.WebHyperlink;
import com.fr.plugin.chart.attr.VanChartTools;
import com.fr.plugin.chart.attr.VanChartZoom;
import com.fr.plugin.chart.attr.plot.VanChartPlot;
import com.fr.plugin.chart.designer.TableLayout4VanChartHelper;
import com.fr.plugin.chart.designer.other.HyperlinkMapFactory;
import com.fr.plugin.chart.vanchart.VanChart;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class VanChartInteractivePane
extends BasicScrollPane<Chart> {
    private static final long serialVersionUID = 8135452818502145597L;
    protected UICheckBox isSort;
    protected UICheckBox exportImages;
    protected UICheckBox fullScreenDisplay;
    protected UIToggleButton collapse;
    protected UIToggleButton isChartAnimation;
    protected UISpinner autoRefreshTime;
    private UIButtonGroup zoomWidget;
    private UIButtonGroup zoomResize;
    private TinyFormulaPane from;
    private TinyFormulaPane to;
    private UIButtonGroup<String> zoomType;
    protected UICorrelationComboBoxPane superLink;
    protected Chart chart;
    protected JPanel interactivePane;

    public String title4PopupWindow() {
        return Inter.getLocText((String)"Chart-Interactive_Tab");
    }

    protected JPanel createContentPane() {
        if (this.chart == null) {
            return new JPanel();
        }
        this.interactivePane = this.getInteractivePane();
        return this.interactivePane;
    }

    protected JPanel getInteractivePane() {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createToolBarPane(dArray2, dArray), null}, {new JSeparator(), null}, {this.createAnimationPane(), null}, {new JSeparator(), null}, {this.createAutoRefreshPane(null), null}, {new JSeparator(), null}, {this.createHyperlinkPane(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private void reLayoutContentPane(VanChartPlot vanChartPlot) {
        this.interactivePane.removeAll();
        this.interactivePane = this.getInteractivePaneWithZoomPane(vanChartPlot);
        this.reloaPane(this.interactivePane);
    }

    private JPanel getInteractivePaneWithZoomPane(VanChartPlot vanChartPlot) {
        double d = -2.0;
        double d2 = -1.0;
        double[] dArray = new double[]{d, d2};
        double[] dArray2 = new double[]{d, d, d, d, d, d, d, d, d};
        Component[][] componentArray = new Component[][]{{this.createToolBarPane(new double[]{d, d, d, d, d}, dArray), null}, {new JSeparator(), null}, {this.createAnimationPane(), null}, {new JSeparator(), null}, {this.createZoomPane(new double[]{d, d, d}, dArray, vanChartPlot), null}, {new JSeparator(), null}, {this.createAutoRefreshPane(vanChartPlot), null}, {new JSeparator(), null}, {this.createHyperlinkPane(), null}};
        return TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray2, (double[])dArray);
    }

    private JPanel createZoomPane(double[] dArray, double[] dArray2, VanChartPlot vanChartPlot) {
        this.zoomWidget = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Open"), Inter.getLocText((String)"Plugin-ChartF_Close")});
        this.zoomResize = new UIButtonGroup(new String[]{Inter.getLocText((String)"Plugin-ChartF_Open"), Inter.getLocText((String)"Plugin-ChartF_Close")});
        this.from = new TinyFormulaPane();
        this.to = new TinyFormulaPane();
        this.zoomType = new UIButtonGroup(this.getNameArray(), (Object[])this.getValueArray());
        JPanel jPanel = TableLayout4VanChartHelper.createTableLayoutPaneWithSmallTitle(Inter.getLocText((String)"Plugin-ChartF_ZoomWidget"), (Component)this.zoomWidget);
        Component[][] componentArray = new Component[][]{{new UILabel(Inter.getLocText((String)"Plugin-ChartF_Change")), this.zoomResize}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_From")), this.from}, {new UILabel(Inter.getLocText((String)"Plugin-ChartF_To")), this.to}};
        JPanel jPanel2 = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        JPanel jPanel3 = TableLayout4VanChartHelper.createTableLayoutPaneWithSmallTitle(Inter.getLocText((String)"Plugin-ChartF_WidgetBoundary"), jPanel2);
        JPanel jPanel4 = TableLayout4VanChartHelper.createTableLayoutPaneWithSmallTitle(Inter.getLocText((String)"Plugin-ChartF_ZoomType"), this.zoomType);
        JPanel jPanel5 = new JPanel(new BorderLayout(0, 4));
        if (vanChartPlot.isSupportZoomCategoryAxis()) {
            jPanel5.add((Component)jPanel, "North");
            jPanel5.add((Component)jPanel3, "Center");
        }
        jPanel5.add((Component)jPanel4, "South");
        this.zoomWidget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VanChartInteractivePane.this.checkZoomPane();
            }
        });
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Chart-Use_Zoom"), jPanel5);
    }

    protected String[] getNameArray() {
        return new String[]{Inter.getLocText((String)"ChartF-X_Axis"), Inter.getLocText((String)"ChartF-Y_Axis"), Inter.getLocText((String)"Plugin-ChartF_XYAxis"), Inter.getLocText((String)"Chart-Use_None")};
    }

    protected String[] getValueArray() {
        return new String[]{"x", "y", "xy", "none"};
    }

    protected JPanel createToolBarPane(double[] dArray, double[] dArray2) {
        this.isSort = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_Sort"));
        this.exportImages = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_ExportImage"));
        this.fullScreenDisplay = new UICheckBox(Inter.getLocText((String)"Plugin-ChartF_FullScreenDisplay"));
        this.collapse = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_Collapse"));
        Component[][] componentArray = this.createToolBarComponents();
        JPanel jPanel = TableLayoutHelper.createTableLayoutPane((Component[][])componentArray, (double[])dArray, (double[])dArray2);
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_ToolBar"), jPanel);
    }

    protected Component[][] createToolBarComponents() {
        Component[][] componentArray = new Component[][]{{this.isSort, null}, {this.exportImages, null}, {this.fullScreenDisplay, null}, {this.collapse, null}};
        return componentArray;
    }

    protected JPanel createAnimationPane() {
        this.isChartAnimation = new UIToggleButton(Inter.getLocText((String)"Plugin-ChartF_OpenAnimation"));
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"Plugin-ChartF_Animation"), (Component)this.isChartAnimation);
    }

    protected JPanel createAutoRefreshPane(VanChartPlot vanChartPlot) {
        this.autoRefreshTime = new UISpinner(0.0, 2.147483647E9, 1.0, 0.0);
        JPanel jPanel = GUICoreUtils.createFlowPane((Component[])new Component[]{new UILabel(Inter.getLocText((String)"Chart-Time_Interval")), this.autoRefreshTime, new UILabel(Inter.getLocText((String)"Chart-Time_Seconds"))}, (int)0);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 4));
        jPanel2.add((Component)jPanel, "Center");
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String[])new String[]{"Chart-Use_Auto", "Chart-Use_Refresh"}), jPanel2);
    }

    protected JPanel createHyperlinkPane() {
        this.superLink = new UICorrelationComboBoxPane();
        return TableLayout4VanChartHelper.createTableLayoutPaneWithTitle(Inter.getLocText((String)"M_Insert-Hyperlink"), (Component)this.superLink);
    }

    private void checkZoomPane() {
        boolean bl = this.zoomWidget.getSelectedIndex() == 0;
        this.zoomResize.setEnabled(bl);
        GUICoreUtils.setEnabled((JComponent)this.from, (boolean)bl);
        GUICoreUtils.setEnabled((JComponent)this.to, (boolean)bl);
        this.zoomType.setEnabled(!bl);
    }

    public void populateBean(Chart chart) {
        VanChartPlot vanChartPlot;
        if (chart == null || chart.getPlot() == null) {
            return;
        }
        this.chart = chart;
        if (this.interactivePane == null) {
            this.remove(this.leftcontentPane);
            this.layoutContentPane();
        }
        if ((vanChartPlot = (VanChartPlot)chart.getPlot()).isSupportZoomDirection()) {
            this.reLayoutContentPane(vanChartPlot);
            this.populateChartZoom((VanChart)chart);
            this.checkZoomPane();
        }
        this.populateChartTools((VanChart)chart);
        this.populateChartAnimate(chart, vanChartPlot);
        this.populateAutoRefresh(chart);
        this.populateHyperlink(vanChartPlot);
    }

    private void populateChartTools(VanChart vanChart) {
        VanChartTools vanChartTools = vanChart.getVanChartTools();
        this.isSort.setSelected(vanChartTools.isSort());
        this.exportImages.setSelected(vanChartTools.isExport());
        this.fullScreenDisplay.setSelected(vanChartTools.isFullScreen());
        this.collapse.setSelected(vanChartTools.isHidden());
    }

    private void populateChartZoom(VanChart vanChart) {
        VanChartZoom vanChartZoom = vanChart.getVanChartZoom();
        if (vanChartZoom == null) {
            vanChartZoom = new VanChartZoom();
        }
        this.zoomWidget.setSelectedIndex(vanChartZoom.isZoomVisible() ? 0 : 1);
        this.zoomResize.setSelectedIndex(vanChartZoom.isZoomResize() ? 0 : 1);
        if (vanChartZoom.getFrom() instanceof Formula) {
            this.from.populateBean(((Formula)vanChartZoom.getFrom()).getContent());
        } else {
            this.from.populateBean(Utils.objectToString((Object)vanChartZoom.getFrom()));
        }
        if (vanChartZoom.getTo() instanceof Formula) {
            this.to.populateBean(((Formula)vanChartZoom.getTo()).getContent());
        } else {
            this.to.populateBean(Utils.objectToString((Object)vanChartZoom.getTo()));
        }
        this.zoomType.setSelectedItem((Object)vanChartZoom.getZoomType());
    }

    private void populateChartAnimate(Chart chart, Plot plot) {
        if (plot.isSupportAnimate()) {
            this.isChartAnimation.setSelected(chart.isJSDraw());
        }
    }

    protected void populateAutoRefresh(Chart chart) {
        VanChartPlot vanChartPlot = (VanChartPlot)chart.getPlot();
        if (vanChartPlot.isSupportAutoRefresh()) {
            this.autoRefreshTime.setValue((double)vanChartPlot.getAutoRefreshPerSecond());
        }
    }

    private void populateHyperlink(Plot plot) {
        HashMap hashMap = HyperlinkMapFactory.getHyperlinkMap(plot);
        List<UIMenuNameableCreator> list = this.refreshList(hashMap);
        this.superLink.refreshMenuAndAddMenuAction(list);
        ArrayList<UIMenuNameableCreator> arrayList = new ArrayList<UIMenuNameableCreator>();
        NameJavaScriptGroup nameJavaScriptGroup = plot.getHotHyperLink();
        for (int i = 0; nameJavaScriptGroup != null && i < nameJavaScriptGroup.size(); ++i) {
            NameJavaScript nameJavaScript = nameJavaScriptGroup.getNameHyperlink(i);
            if (nameJavaScript == null || nameJavaScript.getJavaScript() == null) continue;
            JavaScript javaScript = nameJavaScript.getJavaScript();
            arrayList.add(new UIMenuNameableCreator(nameJavaScript.getName(), (Object)javaScript, this.getUseMap(hashMap, javaScript.getClass())));
        }
        this.superLink.populateBean(arrayList);
        this.superLink.doLayout();
    }

    public void updateBean(Chart chart) {
        if (chart == null || chart.getPlot() == null) {
            return;
        }
        VanChartPlot vanChartPlot = (VanChartPlot)chart.getPlot();
        if (vanChartPlot.isSupportZoomDirection()) {
            this.updateChartZoom((VanChart)chart);
        }
        this.updateChartTools((VanChart)chart);
        this.updateChartAnimate(chart, vanChartPlot);
        this.updateAutoRefresh(vanChartPlot);
        this.updateHyperlink(vanChartPlot);
    }

    private void updateChartTools(VanChart vanChart) {
        VanChartTools vanChartTools = new VanChartTools();
        vanChartTools.setExport(this.exportImages.isSelected());
        vanChartTools.setFullScreen(this.fullScreenDisplay.isSelected());
        vanChartTools.setSort(this.isSort.isSelected());
        vanChartTools.setHidden(this.collapse.isSelected());
        vanChart.setVanChartTools(vanChartTools);
    }

    private void updateChartZoom(VanChart vanChart) {
        VanChartZoom vanChartZoom = vanChart.getVanChartZoom();
        if (vanChartZoom == null) {
            vanChartZoom = new VanChartZoom();
            vanChart.setVanChartZoom(vanChartZoom);
        }
        vanChartZoom.setZoomVisible(this.zoomWidget.getSelectedIndex() == 0);
        vanChartZoom.setZoomResize(this.zoomResize.getSelectedIndex() == 0);
        String string = this.from.updateBean();
        String string2 = StableUtils.maybeFormula((String)string) ? new Formula(string) : string;
        vanChartZoom.setFrom(string2);
        String string3 = this.to.updateBean();
        String string4 = StableUtils.maybeFormula((String)string3) ? new Formula(string3) : string3;
        vanChartZoom.setTo(string4);
        vanChartZoom.setZoomType((String)this.zoomType.getSelectedItem());
    }

    private void updateChartAnimate(Chart chart, Plot plot) {
        if (plot.isSupportAnimate()) {
            chart.setJSDraw(this.isChartAnimation.isSelected());
        }
    }

    private void updateAutoRefresh(VanChartPlot vanChartPlot) {
        if (vanChartPlot.isSupportAutoRefresh()) {
            vanChartPlot.setAutoRefreshPerSecond((int)this.autoRefreshTime.getValue());
        }
    }

    private void updateHyperlink(Plot plot) {
        NameJavaScriptGroup nameJavaScriptGroup = new NameJavaScriptGroup();
        nameJavaScriptGroup.clear();
        this.superLink.resetItemName();
        List list = this.superLink.updateBean();
        for (int i = 0; i < list.size(); ++i) {
            UIMenuNameableCreator uIMenuNameableCreator = (UIMenuNameableCreator)list.get(i);
            NameJavaScript nameJavaScript = new NameJavaScript(uIMenuNameableCreator.getName(), (JavaScript)uIMenuNameableCreator.getObj());
            nameJavaScriptGroup.addNameHyperlink(nameJavaScript);
        }
        plot.setHotHyperLink(nameJavaScriptGroup);
    }

    protected Class<? extends BasicBeanPane> getUseMap(HashMap hashMap, Object object) {
        if (hashMap.get(object) != null) {
            return (Class)hashMap.get(object);
        }
        for (Object k : hashMap.keySet()) {
            if (!((Class)k).isAssignableFrom((Class)object)) continue;
            return (Class)hashMap.get(k);
        }
        return null;
    }

    protected List<UIMenuNameableCreator> refreshList(HashMap hashMap) {
        ArrayList<UIMenuNameableCreator> arrayList = new ArrayList<UIMenuNameableCreator>();
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Reportlet"), (Object)new ReportletHyperlink(), this.getUseMap(hashMap, ReportletHyperlink.class)));
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Mail"), (Object)new EmailJavaScript(), ChartEmailPane.class));
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Web"), (Object)new WebHyperlink(), this.getUseMap(hashMap, WebHyperlink.class)));
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Dynamic_Parameters"), (Object)new ParameterJavaScript(), this.getUseMap(hashMap, ParameterJavaScript.class)));
        arrayList.add(new UIMenuNameableCreator("JavaScript", (Object)new JavaScriptImpl(), this.getUseMap(hashMap, JavaScriptImpl.class)));
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Float_Chart"), (Object)new ChartHyperPoplink(), this.getUseMap(hashMap, ChartHyperPoplink.class)));
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Cell"), (Object)new ChartHyperRelateCellLink(), this.getUseMap(hashMap, ChartHyperRelateCellLink.class)));
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Float"), (Object)new ChartHyperRelateFloatLink(), this.getUseMap(hashMap, ChartHyperRelateFloatLink.class)));
        FormHyperlinkProvider formHyperlinkProvider = (FormHyperlinkProvider)StableFactory.getMarkedInstanceObjectFromClass((String)"FormHyperlink", FormHyperlinkProvider.class);
        arrayList.add(new UIMenuNameableCreator(Inter.getLocText((String)"Chart-Link_Form"), (Object)formHyperlinkProvider, this.getUseMap(hashMap, FormHyperlinkProvider.class)));
        return arrayList;
    }

    public Chart updateBean() {
        return null;
    }

    public boolean shouldResponseChangeListener() {
        return true;
    }
}

