/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write.web.chwriter;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.present.Present;
import com.fr.form.ui.NameWidget;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetManager;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.WriteCellElement;
import com.fr.report.worksheet.CalculatableReport;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ColumnRow;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.web.Repository;
import com.fr.web.core.reportcase.WebReportCase;
import com.fr.web.output.html.chwriter.EditableCellWriter;
import com.fr.web.output.html.chwriter.HtmlWriteCellBox;
import com.fr.write.cal.WB;
import com.fr.write.web.output.DomOptimizer;
import java.text.Format;

public class WriteCellWriter
extends EditableCellWriter {
    private boolean showEditorAsWidget = false;

    public WriteCellWriter(Repository repository, int n2, CalculatableReport calculatableReport) {
        super(repository, n2, calculatableReport);
    }

    public WriteCellWriter(Repository repository, int n2, ReportSettingsProvider reportSettingsProvider, CalculatableReport calculatableReport) {
        super(repository, n2, reportSettingsProvider, calculatableReport);
    }

    private static String generateTdPositionAttr(ColumnRow[] columnRowArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < columnRowArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append(columnRowArray[i2] + "-" + n2);
        }
        return stringBuffer.toString();
    }

    protected boolean isVisible(HtmlWriteCellBox htmlWriteCellBox) {
        WriteCellElement writeCellElement = (WriteCellElement)htmlWriteCellBox.getCell();
        if (writeCellElement.isDel()) {
            this.resTag.cls("del");
            return false;
        }
        return super.isVisible(htmlWriteCellBox);
    }

    protected boolean shouldDrawBackground(HtmlWriteCellBox htmlWriteCellBox) {
        return this.isVisible(htmlWriteCellBox);
    }

    protected Object getDisplayValue(CellElement cellElement, Object object) {
        if (this.cellGUIAttr.isPreviewContent() && ((WriteCellElement)cellElement).getPresent() != null) {
            return ((WriteCellElement)cellElement).getShowValue();
        }
        return super.getDisplayValue(cellElement, object);
    }

    protected Widget getWidgetOfCell(CellElement cellElement) {
        return ((WriteCellElement)cellElement).getWidget();
    }

    protected void processWidget(WebReportCase webReportCase, CellElement cellElement, Widget widget, Object object, ColumnRow columnRow, Calculator calculator) {
        if (this.showEditorAsWidget && widget.isEditor()) {
            this.resTag.attr("widgetWidth", this.cellWidth - (BaseUtils.getBorderWidth((int)cellElement.getStyle().getBorderLeft()) + BaseUtils.getBorderWidth((int)cellElement.getStyle().getBorderRight()) + 1) / 2 + "");
            this.resTag.attr("widgetHeight", this.cellHeight - (BaseUtils.getBorderWidth((int)cellElement.getStyle().getBorderTop()) + BaseUtils.getBorderWidth((int)cellElement.getStyle().getBorderBottom()) + 1) / 2 + "");
        } else {
            this.resTag.attr("widgetWidth", this.cellWidth + "");
            this.resTag.attr("widgetHeight", this.cellHeight - 1 + "");
        }
        this.resTag.css("padding-left", "0").css("padding-right", "0");
        try {
            JSONObject jSONObject = this.widget2ConfigWithJSONStyle(widget, object, columnRow, cellElement, this.reportIndex, null, calculator);
            if (this.showEditorAsWidget && widget.isEditor()) {
                jSONObject.put("isEditable", true);
            }
            String string = jSONObject.toString();
            if (widget instanceof NameWidget) {
                widget = WidgetManager.getProviderInstance().getWidgetConfig(((NameWidget)widget).getName()).toWidget();
            }
            this.addEditAttr2Tag(webReportCase, widget, string, cellElement);
            this.addHasAttr(jSONObject);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
        }
    }

    protected void processNoneWidget(WebReportCase webReportCase, CellElement cellElement, Object object, ColumnRow columnRow, Calculator calculator) {
        DomOptimizer domOptimizer = ((WB)webReportCase.getPackee()).getDomOptimizer();
        domOptimizer.removeConfig(this.resTag.getAttr("id"));
    }

    protected void addEditAttr2Tag(WebReportCase webReportCase, Widget widget, String string, CellElement cellElement) {
        if (webReportCase == null || widget == null) {
            return;
        }
        if (webReportCase.isShowWidgets()) {
            this.resTag.attr("widget", string);
            if (widget.isEditor()) {
                webReportCase.setFirstSelectedFlag(this.resTag);
            }
        } else {
            String string2 = ColumnRow.valueOf((int)cellElement.getColumn(), (int)cellElement.getRow()).toString();
            DomOptimizer domOptimizer = ((WB)webReportCase.getPackee()).getDomOptimizer();
            domOptimizer.putConfig(this.resTag.getAttr("id"), string);
            if (widget.isEditor()) {
                this.resTag.attr("editor", string2);
                webReportCase.setFirstSelectedFlag(this.resTag);
            } else {
                this.resTag.attr("widget-control", string2);
            }
        }
    }

    private void addHasAttr(JSONObject jSONObject) {
        if (jSONObject.has("dependenceMap") || jSONObject.has("dependence")) {
            this.resTag.attr("hasDependece", "true");
        }
        if (jSONObject.has("watermark")) {
            this.resTag.attr("hasWatermark", "true");
        }
        if (jSONObject.has("attachment")) {
            this.resTag.attr("hasAttachment", "true");
        }
    }

    protected void processOtherAttributes(HtmlWriteCellBox htmlWriteCellBox, Calculator calculator) {
        Present present;
        super.processOtherAttributes(htmlWriteCellBox, calculator);
        WriteCellElement writeCellElement = (WriteCellElement)htmlWriteCellBox.getCell();
        ColumnRow[] columnRowArray = htmlWriteCellBox.getHtmlID();
        this.resTag.attr("idx", this.reportIndex + "");
        if (columnRowArray != null) {
            this.resTag.attr("position", WriteCellWriter.generateTdPositionAttr(columnRowArray, this.reportIndex));
        }
        if ((present = writeCellElement.getPresent()) != null) {
            this.resTag.cls("presentable");
            Object[] objectArray = present.dependence((CalculatorProvider)calculator);
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                try {
                    JSONArray jSONArray = new JSONArray((Object)objectArray);
                    this.resTag.attr("presentDep", jSONArray.toString());
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
                }
            }
        }
    }

    public boolean skipValueWrapper(CellElement cellElement) {
        if (this.showEditorAsWidget) {
            return this.getWidgetOfCell(cellElement) != null;
        }
        return this.getWidgetOfCell(cellElement) != null && !this.getWidgetOfCell(cellElement).isEditor();
    }

    public void setShowWidgetAttr(WebReportCase webReportCase) {
        if (webReportCase != null) {
            this.showEditorAsWidget = webReportCase.isShowWidgets();
        }
    }

    public int getHeightOfValueWrapper(CellElement cellElement) {
        return this.cellHeight - (BaseUtils.getBorderWidth((int)cellElement.getStyle().getBorderTop()) + BaseUtils.getBorderWidth((int)cellElement.getStyle().getBorderBottom()) + 1) / 2;
    }

    protected void displayNormalText(CellElement cellElement, Object object, Tag tag, int n2) {
        Html html = super.getHtmlValue(cellElement, object, tag, n2);
        if (this.showEditorAsWidget && this.getWidgetOfCell(cellElement) != null && this.getWidgetOfCell(cellElement).isEditor()) {
            if (!this.cellGUIAttr.isShowAsHTML() && html != null) {
                this.resTag.attr("displayValue", Style.valueToText((Object)object, (Format)cellElement.getStyle().getFormat()));
            }
            if (cellElement != null && cellElement.getNameHyperlinkGroup() == null) {
                return;
            }
        }
        if (html != null && tag != null) {
            tag.sub(html);
        }
    }
}

