/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reserve;

import com.fr.base.FRContext;
import com.fr.data.NetworkHelper;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DeclareRecordType;
import com.fr.general.Inter;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.io.collection.ExportCollection;
import com.fr.io.exporter.AppExporter;
import com.fr.io.exporter.CPTExporter;
import com.fr.io.exporter.CSVExporter;
import com.fr.io.exporter.HTMLExporter;
import com.fr.io.exporter.ImageExporter;
import com.fr.io.exporter.SVGExporter;
import com.fr.io.exporter.TextExporter;
import com.fr.io.exporter.WordExporter;
import com.fr.log.LogUtils;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.fun.ExportOperateProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.web.Browser;
import com.fr.web.core.A.YB;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.reserve.DefaultOperate;
import com.fr.web.core.reserve.ExcelOperate;
import com.fr.web.core.reserve.Operate;
import com.fr.web.core.reserve.PDFExporterFactory;
import com.fr.web.core.utils.ExportUtils;
import com.fr.web.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportFactory {
    protected static boolean offlineWriteAble = true;
    private static final Map<String, Operate> OPERATE_MAP;

    public static Operate getOperate(String string) {
        return OPERATE_MAP.get(string);
    }

    private static AppExporter getPDFExporter(HttpServletRequest httpServletRequest, ReportSessionIDInfor reportSessionIDInfor) {
        boolean bl = ComparatorUtils.equals((String)WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"isPDFPrint"), (String)"true");
        reportSessionIDInfor.setAttribute("genpdfprint", bl);
        if (bl) {
            LogUtils.recordPrintInfo(reportSessionIDInfor.getBookPath(), reportSessionIDInfor.getParameterMap4Execute4Consisent(), DeclareRecordType.PRINT_TYPE_PDF, reportSessionIDInfor);
            if (!Browser.resolve((HttpServletRequest)httpServletRequest).isIE()) {
                FRContext.getLogger().error(Inter.getLocText((String)"FR-Engine_Error-Code-PdfPrint"));
            }
        }
        YB yB2 = new YB();
        float[] fArray = yB2.B(reportSessionIDInfor);
        reportSessionIDInfor.setoffset(bl ? fArray : new float[2]);
        return PDFExporterFactory.getPDFExporter(bl);
    }

    private static DeclareRecordType getImageExportType(HttpServletRequest httpServletRequest) {
        DeclareRecordType[] declareRecordTypeArray = new DeclareRecordType[]{DeclareRecordType.EXPORT_TYPE_IMAGE_PNG, DeclareRecordType.EXPORT_TYPE_IMAGE_JPG, DeclareRecordType.EXPORT_TYPE_IMAGE_GIF, DeclareRecordType.EXPORT_TYPE_IMAGE_BMP, DeclareRecordType.EXPORT_TYPE_IMAGE_WBMP};
        String string = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"extype");
        int n2 = 0;
        if (string != null) {
            for (int i2 = 0; i2 < declareRecordTypeArray.length; ++i2) {
                if (!string.equalsIgnoreCase(declareRecordTypeArray[i2].getTypeString())) continue;
                n2 = i2;
                break;
            }
        }
        return declareRecordTypeArray[n2];
    }

    static {
        offlineWriteAble = VT4FR.isLicAvailable((byte[])StableUtils.getBytes()) && VT4FR.OFFLINE_WRITE.support();
        OPERATE_MAP = new HashMap<String, Operate>();
        OPERATE_MAP.put("pdf", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setPDFContent(httpServletResponse, string, bl);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(ExportFactory.getPDFExporter(httpServletRequest, reportSessionIDInfor));
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_PDF);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("excel", new ExcelOperate());
        OPERATE_MAP.put("word", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setWordConetent(httpServletResponse, string);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(new WordExporter());
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_WORD);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("svg", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setSVGContext(httpServletResponse, string);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(new SVGExporter());
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_SVG);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("text", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setTextContext(httpServletResponse, string);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(new TextExporter());
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_TEXT);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("csv", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setCSVContext(httpServletResponse, string);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(new CSVExporter());
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_CSV);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("image", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                DeclareRecordType declareRecordType = ExportFactory.getImageExportType(httpServletRequest);
                ExportUtils.setImageContext(httpServletResponse, string, declareRecordType.getTypeString());
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                DeclareRecordType declareRecordType = ExportFactory.getImageExportType(httpServletRequest);
                ImageExporter imageExporter = new ImageExporter(declareRecordType.getTypeString(), 96);
                exportCollection.setExporter(imageExporter);
                exportCollection.setRecordType(declareRecordType);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("cpt", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                if (StringUtils.isEmpty((String)NetworkHelper.getHTTPRequestFileNameParameter((HttpServletRequest)httpServletRequest))) {
                    string = (string + "/" + DateUtils.DATEFORMAT1.format(new Date())).replaceAll("\\/", "_");
                }
                ExportUtils.setCPTContext(httpServletResponse, string);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(new CPTExporter());
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_CPT);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("html", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setHTMLContext(httpServletResponse, string);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                ExportCollection exportCollection = ExportCollection.create();
                exportCollection.setExporter(new HTMLExporter());
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_HTML);
                return exportCollection;
            }
        });
        OPERATE_MAP.put("write_html", new DefaultOperate(){

            public void setContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
                ExportUtils.setZipContext(httpServletResponse, string, true);
            }

            public ExportCollection createCollection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, String string) {
                if (!offlineWriteAble) {
                    throw new RegistEditionException(VT4FR.OFFLINE_WRITE, false);
                }
                ExportCollection exportCollection = ExportCollection.create();
                AppExporter appExporter = (AppExporter)StableFactory.getMarkedInstanceObjectFromClass((String)"WriterHTMLExporter", AppExporter.class);
                exportCollection.setExporter(appExporter);
                exportCollection.setRecordType(DeclareRecordType.EXPORT_TYPE_WRITE_HTML);
                return exportCollection;
            }
        });
        Set set = ExtraReportClassManager.getInstance().getArray("ExportOperateProvider");
        for (ExportOperateProvider exportOperateProvider : set) {
            OPERATE_MAP.put(exportOperateProvider.markType(), exportOperateProvider.operate());
        }
    }
}

