/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess.operator;

import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.base.platform.PlatformProvider;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.DataModel;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.report.utils.ReportDelimiter;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.web.core.process.ProcessUtils;
import com.fr.web.core.process.reportprocess.ProcessTaskImpl;
import com.fr.web.core.process.reportprocess.operator.ProcessOperator;
import com.fr.web.core.process.reportprocess.operator.ProcessOperatorManager;
import java.util.ArrayList;

public class ProcessOperatorImpl
extends ProcessOperator {
    private int type = 0;
    private int dataSource = 1;
    private String[] ids = new String[0];
    private ArrayList<String> parentIDs = new ArrayList();
    private JSONObject operateJSON = new JSONObject();

    public ProcessOperatorImpl() {
    }

    public ProcessOperatorImpl(String string) {
        if (string != null) {
            String[] stringArray = string.split(":");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2;
                int n2;
                String string2 = stringArray[i2];
                if (!StringUtils.isNotEmpty((String)string2) || (n2 = (stringArray2 = string2.split("##")).length) <= 2) continue;
                this.dealNodeString(stringArray2, n2, i2);
            }
        }
    }

    public ProcessOperatorImpl(String string, String string2) {
        if (string != null) {
            String[] stringArray = string.split(":");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2;
                int n2;
                String string3 = stringArray[i2];
                if (!StringUtils.isNotEmpty((String)string3) || (n2 = (stringArray2 = string3.split("##")).length) <= 2) continue;
                this.dealNodeString(stringArray2, n2, i2, string2);
            }
        }
    }

    private void dealNodeString(String[] stringArray, int n2, int n3) {
        this.type = Integer.parseInt(stringArray[0]);
        this.dataSource = Integer.parseInt(stringArray[1]);
        if (this.dataSource == 3) {
            JSONArray jSONArray;
            boolean bl;
            if (this.type == 1) {
                bl = true;
                jSONArray = ProcessUtils.P().getAllUsers(false);
            } else {
                bl = false;
                jSONArray = ProcessUtils.P().getAllRoles();
            }
            this.dealIDS4Node(jSONArray, stringArray, n2, n3, bl);
        } else {
            this.ids = new String[n2 - 2];
            for (int i2 = 0; i2 < n2 - 2; ++i2) {
                this.ids[i2] = stringArray[i2 + 2];
                this.parentIDs.add(this.ids[i2]);
            }
        }
    }

    private void dealNodeString(String[] stringArray, int n2, int n3, String string) {
        JSONArray jSONArray;
        boolean bl;
        this.type = Integer.parseInt(stringArray[0]);
        this.dataSource = Integer.parseInt(stringArray[1]);
        if (this.type == 1) {
            bl = true;
            jSONArray = ProcessUtils.P().getAllUsers(false);
        } else {
            bl = false;
            jSONArray = ProcessUtils.P().getAllRoles();
        }
        if (this.dataSource == 3) {
            this.dealIDS4Node(jSONArray, stringArray, n2, n3, bl, string);
        } else {
            this.ids = new String[n2 - 2];
            for (int i2 = 0; i2 < n2 - 2; ++i2) {
                this.ids[i2] = stringArray[i2 + 2];
                this.parentIDs.add(this.ids[i2]);
            }
        }
    }

    private void dealIDS4Node(JSONArray jSONArray, String[] stringArray, int n2, int n3, boolean bl) {
        try {
            String string = stringArray[2];
            if (StringUtils.isEmpty((String)string)) {
                return;
            }
            TableData tableData = DatasourceManager.getProviderInstance().getTableData(string);
            Calculator calculator = Calculator.createCalculator();
            if (tableData == null) {
                FRContext.getLogger().error(string + " is no exist");
                return;
            }
            DataModel dataModel = tableData.createDataModel(calculator, string);
            int n4 = dataModel.getRowCount();
            if (n2 == 4) {
                String string2 = stringArray[n2 - 1];
                this.dealIDS4FirstNode(n4, dataModel, string2, jSONArray, bl);
            } else if (n2 == 5) {
                String string3 = stringArray[n2 - 2];
                String string4 = stringArray[n2 - 1];
                if (n3 == 0) {
                    this.dealIDS4FirstNode(n4, dataModel, string4, jSONArray, bl);
                } else {
                    this.dealIDS4OtherNode(n4, dataModel, string3, string4, jSONArray, bl);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void dealIDS4Node(JSONArray jSONArray, String[] stringArray, int n2, int n3, boolean bl, String string) {
        try {
            String string2 = stringArray[2];
            if (StringUtils.isEmpty((String)string2)) {
                return;
            }
            TableData tableData = DatasourceManager.getProviderInstance().getTableData(string2);
            if (tableData == null) {
                FRContext.getLogger().error(string2 + " is no exist");
                return;
            }
            Calculator calculator = Calculator.createCalculator();
            DataModel dataModel = tableData.createDataModel(calculator, string2);
            int n4 = dataModel.getRowCount();
            if (n2 == 4) {
                String string3 = stringArray[n2 - 1];
                this.dealIDS4FirstNode(n4, dataModel, string3, jSONArray, bl, string);
            } else if (n2 == 5) {
                String string4 = stringArray[n2 - 2];
                String string5 = stringArray[n2 - 1];
                if (n3 == 0) {
                    this.dealIDS4FirstNode(n4, dataModel, string5, jSONArray, bl, string);
                } else {
                    this.dealIDS4OtherNode(n4, dataModel, string4, string5, jSONArray, bl, string);
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private String getNotEmptyId(DataModel dataModel, int n2, String string) {
        String string2;
        int n3 = Integer.parseInt(string);
        try {
            while (StringUtils.isEmpty((String)(string2 = (String)dataModel.getValueAt(n2, n3)))) {
                ++n3;
            }
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private void dealIDS4FirstNode(int n2, DataModel dataModel, String string, JSONArray jSONArray, boolean bl) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = this.getNotEmptyId(dataModel, i2, string);
                int n3 = jSONArray.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string2);
                    String string3 = jSONObject.getString("value");
                    if (!bl2 || this.parentIDs.contains(string3)) continue;
                    this.parentIDs.add(string3);
                    break;
                }
                this.ids = this.parentIDs.toArray(new String[this.parentIDs.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void dealIDS4OtherNode(int n2, DataModel dataModel, String string, String string2, JSONArray jSONArray, boolean bl, String string3) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string4 = (String)dataModel.getValueAt(i2, Integer.parseInt(string));
                String string5 = (String)dataModel.getValueAt(i2, Integer.parseInt(string2));
                int n3 = jSONArray.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string4);
                    String string6 = jSONObject.getString("value");
                    if (!bl2 || this.parentIDs.contains(string6) || !ComparatorUtils.equals((String)string5, (String)string3)) continue;
                    this.parentIDs.add(string6);
                    break;
                }
                this.ids = this.parentIDs.toArray(new String[this.parentIDs.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private void dealIDS4FirstNode(int n2, DataModel dataModel, String string, JSONArray jSONArray, boolean bl, String string2) {
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = (String)dataModel.getValueAt(i2, Integer.parseInt(string));
                String string4 = (String)dataModel.getValueAt(i2, Integer.parseInt(string) + 1);
                int n3 = jSONArray.length();
                for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string3);
                    String string5 = jSONObject.getString("value");
                    if (!bl2 || this.parentIDs.contains(string5) || !ComparatorUtils.equals((String)string4, (String)string2)) continue;
                    this.parentIDs.add(string5);
                    break;
                }
                this.ids = this.parentIDs.toArray(new String[this.parentIDs.size()]);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    private void dealIDS4OtherNode(int n2, DataModel dataModel, String string, String string2, JSONArray jSONArray, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = (String)dataModel.getValueAt(i2, Integer.parseInt(string));
                int n3 = jSONArray.length();
                block3: for (int i3 = 0; i3 < n3; ++i3) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i3);
                    boolean bl2 = this.isNeedInProcess(jSONObject, bl, string3);
                    String string4 = jSONObject.getString("value");
                    if (!bl2 || !this.parentIDs.contains(string4)) continue;
                    String string5 = (String)dataModel.getValueAt(i2, Integer.parseInt(string2));
                    for (int i4 = 0; i4 < n3; ++i4) {
                        JSONObject jSONObject2 = jSONArray.getJSONObject(i4);
                        boolean bl3 = this.isNeedInProcess(jSONObject2, bl, string5);
                        if (!bl3) continue;
                        JSONObject jSONObject3 = new JSONObject();
                        String string6 = jSONObject2.getString("value");
                        if (!arrayList.contains(string6)) {
                            arrayList.add(string6);
                        }
                        if (this.operateJSON.has(string6) && this.operateJSON.get(string6) != null) {
                            jSONObject3 = this.operateJSON.getJSONObject(string6);
                        }
                        jSONObject3.put(string4, ProcessTaskImpl.NOT_COMPLETE);
                        this.operateJSON.put(string6, (Object)jSONObject3);
                        continue block3;
                    }
                }
            }
            this.ids = arrayList.toArray(new String[arrayList.size()]);
            this.parentIDs.clear();
            this.parentIDs = arrayList;
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean isNeedInProcess(JSONObject jSONObject, boolean bl, String string) throws JSONException {
        return bl ? ComparatorUtils.equals((String)jSONObject.getString("value"), (String)string) || ComparatorUtils.equals((String)jSONObject.getString("username"), (String)string) || ComparatorUtils.equals((String)jSONObject.getString("realname"), (String)string) : ComparatorUtils.equals((String)jSONObject.getString("value"), (String)string) || ComparatorUtils.equals((String)jSONObject.getString("departmentname"), (String)string) || ComparatorUtils.equals((String)jSONObject.getString("postname"), (String)string);
    }

    public ProcessOperatorImpl(String string, int n2) {
        String[] stringArray;
        if (string != null && (stringArray = string.split("##")).length > 1) {
            this.type = Integer.parseInt(stringArray[0]);
            if (n2 < 0 || n2 >= stringArray.length - 1) {
                this.ids = new String[stringArray.length - 1];
                for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
                    this.ids[i2] = stringArray[i2 + 1];
                }
            } else {
                this.ids = new String[]{stringArray[n2 + 1]};
            }
        }
    }

    public boolean isUser() {
        return this.type == 1;
    }

    public boolean isRole() {
        return !this.isUser();
    }

    public boolean isUseDataSource() {
        return this.dataSource == 3;
    }

    public void setOperateJSON(JSONObject jSONObject) {
        this.operateJSON = jSONObject;
    }

    public JSONObject getOperateJSON() {
        return this.operateJSON;
    }

    public String[] getIds() {
        return this.ids;
    }

    public int getOperatorCount() {
        return ArrayUtils.getLength((Object)this.ids);
    }

    public boolean contains(long l2) {
        return this.contains(l2 + "");
    }

    public boolean contains(String string) {
        if (string != null) {
            return (this.type == 1 || this.type == 2 && ReportDelimiter.containsRoleDelimiter(string)) && this.checkIdContain(string);
        }
        return false;
    }

    private boolean checkIdContain(String string) {
        for (String string2 : this.ids) {
            if (ComparatorUtils.equals((String)string, (String)string2)) {
                return true;
            }
            String string3 = ProcessUtils.P().getUserIdByName(string2) + "";
            if (!ComparatorUtils.equals((String)string, (String)string3)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnderTakeBy(long l2) {
        if (this.contains(l2)) {
            return true;
        }
        PlatformProvider platformProvider = ProcessUtils.P();
        long[] lArray = platformProvider.getCompanyRolesByUserIdWithAllDepartment(l2);
        if (this.checkRolesUnderTake(lArray, true)) {
            return true;
        }
        long[] lArray2 = platformProvider.getCustomRolesByUserId(l2);
        return this.checkRolesUnderTake(lArray2, false);
    }

    public boolean checkRolesUnderTake(long[] lArray, boolean bl) {
        String string = (bl ? 1 : 2) + "";
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (!this.contains(ReportDelimiter.getUserAndRoleString(string, lArray[i2]))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.type + "##" + this.dataSource;
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            string = string + "##" + this.ids[i2];
        }
        return string;
    }

    public String toNameString() {
        String string = "";
        if (this.type == 1) {
            string = string + Inter.getLocText((String)"FR-Engine_User") + ":";
            for (int i2 = 0; i2 < this.ids.length; ++i2) {
                string = string + ProcessUtils.getUserName(ProcessUtils.getUserIdFromStr(this.ids[i2]));
                if (i2 >= this.ids.length - 1) continue;
                string = string + ",";
            }
        } else {
            string = string + Inter.getLocText((String)"FR-Engine_Role") + ":";
            for (int i3 = 0; i3 < this.ids.length; ++i3) {
                string = string + ProcessOperatorManager.getRoleName(this.ids[i3]);
                if (i3 >= this.ids.length - 1) continue;
                string = string + ",";
            }
        }
        return string;
    }

    public JSONArray toJSONArray(JSONObject jSONObject, boolean bl, JSONArray jSONArray, String string) {
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            String string2 = this.ids[i2];
            JSONObject jSONObject2 = ProcessOperatorManager.getOperatorJSON(string2);
            if (bl) {
                if (jSONObject.length() > 0) {
                    if (!jSONObject.has(this.ids[i2])) continue;
                    jSONArray.put((Object)jSONObject2);
                    continue;
                }
                jSONArray.put((Object)jSONObject2);
                continue;
            }
            long[] lArray = ProcessOperatorManager.getAllUserId(string2);
            Object[] objectArray = new String[lArray.length];
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                objectArray[i3] = ProcessUtils.getUserNameById(lArray[i3]);
            }
            if (!ArrayUtils.contains((Object[])objectArray, (Object)string)) continue;
            jSONArray.put((Object)jSONObject2);
            return jSONArray;
        }
        return jSONArray;
    }

    public long[] getAllUserId() {
        if (this.type == 1) {
            long[] lArray = new long[this.ids.length];
            for (int i2 = 0; i2 < this.ids.length; ++i2) {
                lArray[i2] = ProcessUtils.getUserIdFromStr(this.ids[i2]);
            }
            return lArray;
        }
        long[] lArray = new long[]{};
        for (int i3 = 0; i3 < this.ids.length; ++i3) {
            lArray = ArrayUtils.addAll((long[])lArray, (long[])ProcessOperatorManager.getRoleUserId(this.ids[i3]));
        }
        return ProcessUtils.unique(lArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProcessOperatorImpl)) {
            return false;
        }
        ProcessOperatorImpl processOperatorImpl = (ProcessOperatorImpl)object;
        if (processOperatorImpl.type != this.type) {
            return false;
        }
        if (processOperatorImpl.ids == null || this.ids == null) {
            return false;
        }
        if (processOperatorImpl.ids.length != this.ids.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.ids.length; ++i2) {
            if (!ComparatorUtils.equals((String)processOperatorImpl.ids[i2], (String)this.ids[i2])) continue;
            return false;
        }
        return true;
    }
}

