/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.process.reportprocess.dao;

import com.fr.data.dao.DataAccessObjectSession;
import com.fr.report.ExtraReportClassManager;
import com.fr.web.core.process.reportprocess.ProcessNode;
import com.fr.web.core.process.reportprocess.dao.ProcessDAOManager;
import com.fr.web.core.process.reportprocess.dao.provider.AbstractFRProcessDaoProcessor;
import com.fr.web.core.process.reportprocess.dao.provider.ProcessNodeDaoProcessor;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessNodeDAO
extends AbstractFRProcessDaoProcessor<ProcessNode>
implements ProcessNodeDaoProcessor {
    private static ProcessNodeDAO SC = null;

    private ProcessNodeDAO() {
    }

    public static ProcessNodeDaoProcessor getInstance() {
        ProcessNodeDaoProcessor processNodeDaoProcessor = (ProcessNodeDaoProcessor)ExtraReportClassManager.getInstance().getSingle("ProcessNodeDaoProcessor");
        if (processNodeDaoProcessor == null) {
            processNodeDaoProcessor = ProcessNodeDAO.getDefaultInstance();
        }
        return processNodeDaoProcessor;
    }

    private static synchronized ProcessNodeDaoProcessor getDefaultInstance() {
        if (SC == null) {
            SC = new ProcessNodeDAO();
        }
        return SC;
    }

    private DataAccessObjectSession createSession() {
        return ProcessDAOManager.createProcessNodeSession();
    }

    @Override
    public long save(ProcessNode processNode) throws Exception {
        return this.createSession().save((Object)processNode);
    }

    @Override
    public boolean saveOrUpdate(ProcessNode processNode) throws Exception {
        return this.createSession().saveOrUpdate((Object)processNode);
    }

    @Override
    public boolean update(ProcessNode processNode) throws Exception {
        return this.createSession().update((Object)processNode);
    }

    @Override
    public boolean delete(ProcessNode processNode) throws Exception {
        if (processNode == null) {
            return false;
        }
        return this.deleteByID(processNode.getId());
    }

    @Override
    public boolean deleteByID(long l2) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        return this.createSession().deleteByPrimaryKey(ProcessNode.class, l2);
    }

    @Override
    public ProcessNode findByID(long l2) throws Exception {
        if (l2 < 0L) {
            return null;
        }
        return (ProcessNode)this.createSession().load(ProcessNode.class, l2);
    }

    @Override
    public List<ProcessNode> listByFieldValue(String string, Object object) throws Exception {
        return this.createSession().listByFieldValue(ProcessNode.class, string, object);
    }

    @Override
    public List findAll() throws Exception {
        return this.createSession().list(ProcessNode.class);
    }

    public boolean updateName(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    @Override
    public boolean updateProcessId(long l2, long l3) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("processId", l3);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateDescribe(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("describe", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateAuthority(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("authority", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateReportPath(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("reportControl", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateAlertControl(long l2, String string) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("alertControl", string);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }

    public boolean updateNeedOfflineReport(long l2, boolean bl) throws Exception {
        if (l2 < 0L) {
            return false;
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("needOfflineReport", bl);
        return this.createSession().update(ProcessNode.class, l2, hashMap);
    }
}

