/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.base.headerfooter.FormulaHFElement;
import com.fr.base.headerfooter.HFElement;
import com.fr.base.headerfooter.HFElementXMLUtils;
import com.fr.base.headerfooter.HFPaintable;
import com.fr.base.headerfooter.ImageHFElement;
import com.fr.base.headerfooter.ImageHFPaintable;
import com.fr.base.headerfooter.NewLineHFElement;
import com.fr.base.headerfooter.NumberOfPageHFElement;
import com.fr.base.headerfooter.PageNumberHFElement;
import com.fr.base.headerfooter.TextHFElement;
import com.fr.base.headerfooter.TextHFPaintable;
import com.fr.general.Background;
import com.fr.report.cell.AbstractCellElement;
import com.fr.report.core.ReportHFBase;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.CalculatorProviderContext;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReportHF
extends ReportHFBase {
    public static final String IMAGE_HEADER_FOOTER = String.valueOf(Integer.MIN_VALUE);
    public static final String PAGENUM_HEADER_FOOTER = "PAGENUM_HEADER_FOOTER";
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private Background background = null;
    private boolean printBackground = true;

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public boolean isPrintBackground() {
        return this.printBackground;
    }

    public void setPrintBackground(boolean bl) {
        this.printBackground = bl;
    }

    private void addHFElement(int n2, int n3, HFElement hFElement) {
        if (n2 == 4) {
            if (n3 == -1 || n3 >= this.getRightList().size()) {
                this.getRightList().add(hFElement);
            } else {
                this.getRightList().add(n3, hFElement);
            }
        } else if (n2 == 0) {
            if (n3 == -1 || n3 >= this.getCenterList().size()) {
                this.getCenterList().add(hFElement);
            } else {
                this.getCenterList().add(n3, hFElement);
            }
        } else if (n3 == -1 || n3 >= this.getLeftList().size()) {
            this.getLeftList().add(hFElement);
        } else {
            this.getLeftList().add(n3, hFElement);
        }
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        List list = this.toPaintableList(n2, n3, n4, n5, n6);
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.clip(rectangle2D);
        graphics2D.translate(rectangle2D.getX(), rectangle2D.getY());
        if (this.background != null && (!bl || this.printBackground)) {
            this.background.paint((Graphics)graphics2D, (Shape)new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HFPaintable hFPaintable = (HFPaintable)list.get(i2);
            hFPaintable.paint(graphics2D, n6);
        }
        graphics2D.dispose();
    }

    private List toPaintableList(int n2, int n3, int n4, int n5, int n6) {
        ArrayList<HFPaintable> arrayList = new ArrayList<HFPaintable>();
        arrayList.addAll(Arrays.asList(ReportHF.hfElements2Paintables(this.getLeftList(), n2, new CX(){

            public int calc(int n2, int n3) {
                return 0;
            }
        }, n3, n4, n5, n6)));
        arrayList.addAll(Arrays.asList(ReportHF.hfElements2Paintables(this.getCenterList(), n2, new CX(){

            public int calc(int n2, int n3) {
                return (n2 - n3) / 2;
            }
        }, n3, n4, n5, n6)));
        arrayList.addAll(Arrays.asList(ReportHF.hfElements2Paintables(this.getRightList(), n2, new CX(){

            public int calc(int n2, int n3) {
                return n2 - n3;
            }
        }, n3, n4, n5, n6)));
        return arrayList;
    }

    private static HFPaintable[] hfElements2Paintables(List list, int n2, CX cX, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        ArrayList<HFPaintable> arrayList = new ArrayList<HFPaintable>();
        ArrayList<HFPaintable> arrayList2 = new ArrayList<HFPaintable>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HFElement hFElement = (HFElement)list.get(i2);
            HFPaintable hFPaintable = ReportHF.createPaintable(hFElement, n3, n4, n5);
            if (hFElement instanceof NewLineHFElement) {
                ReportHF.setHFPaintableLocation(arrayList2, n2, n7, cX, n6);
                double d2 = ReportHF.getHeightOfPaintableList(arrayList2, n6);
                if (d2 == 0.0) {
                    d2 = hFElement.getSize(n6).getHeight();
                }
                n7 = (int)((double)n7 + d2);
                arrayList2.clear();
                continue;
            }
            if (hFElement instanceof FormulaHFElement) {
                String string = ((FormulaHFElement)hFElement).getText();
                String string2 = ((FormulaHFElement)hFElement).getFormulaContent();
                String string3 = ReportHF.evalHFPageNumberValue(string2, n3, n4, n5, string);
                ((FormulaHFElement)hFElement).setText(string3);
            }
            arrayList2.add(hFPaintable);
            arrayList.add(hFPaintable);
        }
        ReportHF.setHFPaintableLocation(arrayList2, n2, n7, cX, n6);
        return arrayList.toArray(new HFPaintable[arrayList.size()]);
    }

    private static String evalHFPageNumberValue(String string, int n2, int n3, int n4, String string2) {
        int n5 = string.indexOf("$$page_number");
        int n6 = string.indexOf("$$totalPage_number");
        if (StringUtils.isNotEmpty((String)string2) && n5 == -1 && n6 == -1) {
            return string2;
        }
        string = Utils.replace((String)string, (String)"$$page_number", (String)String.valueOf(n2 + n4 - 1));
        string = Utils.replace((String)string, (String)"$$totalPage_number", (String)String.valueOf(n3 + n4 - 1));
        try {
            Object object = Calculator.createCalculator().eval(string);
            if (object instanceof AbstractCellElement) {
                object = CalculatorProviderContext.getValueConverter().result2Value(object);
            }
            string = String.valueOf(object);
        }
        catch (UtilEvalError utilEvalError) {
            FRContext.getLogger().error(utilEvalError.getMessage());
        }
        return string;
    }

    private static double getHeightOfPaintableList(List list, int n2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HFPaintable hFPaintable = (HFPaintable)list.get(i2);
            d2 = Math.max(d2, hFPaintable.getHFElement().getSize(n2).getHeight());
        }
        return d2;
    }

    private static void setHFPaintableLocation(List list, int n2, double d2, CX cX, int n3) {
        HFPaintable hFPaintable;
        int n4;
        if (list.isEmpty()) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < list.size(); ++n4) {
            hFPaintable = (HFPaintable)list.get(n4);
            n6 = (int)((double)n6 + hFPaintable.getHFElement().getSize(n3).getWidth());
        }
        n5 = cX.calc(n2, n6);
        for (n4 = 0; n4 < list.size(); ++n4) {
            hFPaintable = (HFPaintable)list.get(n4);
            hFPaintable.setPaintLocation((Point2D)new Point2D.Double(n5, d2));
            n5 = (int)((double)n5 + hFPaintable.getHFElement().getSize(n3).getWidth());
        }
    }

    private static HFPaintable createPaintable(HFElement hFElement, int n2, int n3, int n4) {
        if (hFElement instanceof PageNumberHFElement) {
            ((PageNumberHFElement)hFElement).setText(String.valueOf(n2 + n4 - 1));
        } else if (hFElement instanceof NumberOfPageHFElement) {
            ((NumberOfPageHFElement)hFElement).setText(n3 < 0 ? "???" : String.valueOf(n3 + n4 - 1));
        }
        if (hFElement instanceof ImageHFElement) {
            return new ImageHFPaintable((ImageHFElement)hFElement);
        }
        if (hFElement instanceof TextHFElement) {
            return new TextHFPaintable((TextHFElement)hFElement);
        }
        return new TextHFPaintable(new TextHFElement());
    }

    public void readXML(XMLableReader xMLableReader) {
        this.setPrintBackground(xMLableReader.getAttrAsBoolean("printBackground", true));
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (string.equals("LeftList")) {
                        ArrayList arrayList = ReportHF.this.getLeftList();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            ReportHF.this.setLeftList(arrayList);
                        }
                        arrayList.clear();
                        ReportHF.this.readHFElement(arrayList, xMLableReader);
                    } else if (string.equals("CenterList")) {
                        ArrayList arrayList = ReportHF.this.getCenterList();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            ReportHF.this.setCenterList(arrayList);
                        }
                        arrayList.clear();
                        ReportHF.this.readHFElement(arrayList, xMLableReader);
                    } else if (string.equals("RightList")) {
                        ArrayList arrayList = ReportHF.this.getRightList();
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                            ReportHF.this.setRightList(arrayList);
                        }
                        arrayList.clear();
                        ReportHF.this.readHFElement(arrayList, xMLableReader);
                    } else if (string.equals("Background")) {
                        ReportHF.this.setBackground(BaseXMLUtils.readBackground((XMLableReader)xMLableReader));
                    }
                }
            }
        });
    }

    private void readHFElement(final List list, XMLableReader xMLableReader) {
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                HFElement hFElement;
                if (xMLableReader.isChildNode() && (hFElement = HFElementXMLUtils.readXML((XMLableReader)xMLableReader)) != null) {
                    list.add(hFElement);
                }
            }
        });
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter, boolean bl, int n2) {
        List list;
        List list2;
        if (bl) {
            xMLPrintWriter.startTAG("Header");
        } else {
            xMLPrintWriter.startTAG("Footer");
        }
        xMLPrintWriter.attr("reportPageType", n2);
        if (!this.printBackground) {
            xMLPrintWriter.attr("printBackground", this.printBackground);
        }
        BaseXMLUtils.writeBackground((XMLPrintWriter)xMLPrintWriter, (Background)this.background);
        List list3 = this.getLeftList();
        if (list3 != null) {
            this.writeHFElementList(xMLPrintWriter, list3, "LeftList");
        }
        if ((list2 = this.getCenterList()) != null) {
            this.writeHFElementList(xMLPrintWriter, list2, "CenterList");
        }
        if ((list = this.getRightList()) != null) {
            this.writeHFElementList(xMLPrintWriter, list, "RightList");
        }
        xMLPrintWriter.end();
    }

    private void writeHFElementList(XMLPrintWriter xMLPrintWriter, List list, String string) {
        xMLPrintWriter.startTAG(string);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            HFElementXMLUtils.writeXML((XMLPrintWriter)xMLPrintWriter, (HFElement)((HFElement)list.get(i2)));
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        ReportHF reportHF = (ReportHF)super.clone();
        if (this.getBackground() != null) {
            reportHF.setBackground((Background)this.getBackground().clone());
        }
        return reportHF;
    }

    private static abstract class CX {
        private CX() {
        }

        protected abstract int calc(int var1, int var2);
    }
}

