/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl;

import java.util.Collection;
import java.util.Map;
import org.activiti.crystalball.simulator.CrystalballException;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartReplayProcessEventHandler
implements SimulationEventHandler {
    private static Logger log = LoggerFactory.getLogger((String)StartReplayProcessEventHandler.class.getName());
    public static final String PROCESS_INSTANCE_ID = "_replay.processInstanceId";
    private final String eventTypeToReplay;
    private final String eventTypeToSchedule;
    private final Collection<SimulationEvent> events;
    private final String processInstanceId;
    private final String processToStartIdKey;
    private final String businessKey;
    private final String variablesKey;

    public StartReplayProcessEventHandler(String processInstanceId, String eventTypeToReplay, String eventTypeToSchedule, Collection<SimulationEvent> events, String processToStartIdKey, String businessKey, String variablesKey) {
        this.eventTypeToReplay = eventTypeToReplay;
        this.eventTypeToSchedule = eventTypeToSchedule;
        this.events = events;
        this.processInstanceId = processInstanceId;
        this.processToStartIdKey = processToStartIdKey;
        this.businessKey = businessKey;
        this.variablesKey = variablesKey;
    }

    @Override
    public void init() {
        SimulationEvent toReplayStartEvent = this.findProcessInstanceStartEvent();
        SimulationEvent startEvent = new SimulationEvent.Builder(this.eventTypeToSchedule).properties(toReplayStartEvent.getProperties()).build();
        SimulationRunContext.getEventCalendar().addEvent(startEvent);
    }

    private SimulationEvent findProcessInstanceStartEvent() {
        for (SimulationEvent event : this.events) {
            if (!this.eventTypeToReplay.equals(event.getType()) || !this.processInstanceId.equals(event.getProperty("processInstanceId"))) continue;
            return event;
        }
        throw new CrystalballException("ProcessInstance to replay start not found");
    }

    @Override
    public void handle(SimulationEvent event) {
        String processDefinitionId = (String)event.getProperty(this.processToStartIdKey);
        String businessKey = (String)event.getProperty(this.businessKey);
        Map variables = (Map)event.getProperty(this.variablesKey);
        variables.put(PROCESS_INSTANCE_ID, this.processInstanceId);
        log.debug("Starting new processDefId[{}] businessKey[{}] with variables[{}]", new Object[]{processDefinitionId, businessKey, variables});
        SimulationRunContext.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, variables);
    }
}

