/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.util;

import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.progress.ProgressMonitor;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRCUtil {
    private static final int BUF_SIZE = 16384;

    public static long computeFileCRC(String string) throws ZipException {
        return CRCUtil.computeFileCRC(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long computeFileCRC(String string, ProgressMonitor progressMonitor) throws ZipException {
        long l;
        InputStream inputStream;
        block12: {
            long l2;
            block11: {
                if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
                    throw new ZipException("input file is null or empty, cannot calculate CRC for the file");
                }
                inputStream = null;
                try {
                    try {
                        Zip4jUtil.checkFileReadAccess(string);
                        inputStream = new FileInputStream(new File(string));
                        byte[] byArray = new byte[16384];
                        int n = -2;
                        CRC32 cRC32 = new CRC32();
                        while ((n = inputStream.read(byArray)) != -1) {
                            cRC32.update(byArray, 0, n);
                            if (progressMonitor == null) continue;
                            progressMonitor.updateWorkCompleted(n);
                            if (!progressMonitor.isCancelAllTasks()) continue;
                            progressMonitor.setResult(3);
                            progressMonitor.setState(0);
                            l2 = 0L;
                            Object var9_10 = null;
                            if (inputStream == null) return l2;
                            break block11;
                        }
                        l = cRC32.getValue();
                        break block12;
                    }
                    catch (IOException iOException) {
                        throw new ZipException(iOException);
                    }
                    catch (Exception exception) {
                        throw new ZipException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new ZipException("error while closing the file after calculating crc");
                    }
                }
            }
            try {}
            catch (IOException iOException) {
                throw new ZipException("error while closing the file after calculating crc");
            }
            inputStream.close();
            return l2;
        }
        Object var9_11 = null;
        if (inputStream == null) return l;
        try {}
        catch (IOException iOException) {
            throw new ZipException("error while closing the file after calculating crc");
        }
        inputStream.close();
        return l;
    }
}

