/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.IconManager;
import com.fr.data.NetworkHelper;
import com.fr.file.ClusterConfigManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.VT4FR;
import com.fr.performance.PerformanceManager;
import com.fr.plugin.ExtraClassManager;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.fun.Service;
import com.fr.stable.monitor.MemoryHelper;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.Weblet;
import com.fr.web.ClusterHelper;
import com.fr.web.JarVersionService;
import com.fr.web.NoPrivilegeException;
import com.fr.web.core.A.$D;
import com.fr.web.core.A.AB;
import com.fr.web.core.A.EC;
import com.fr.web.core.A.h;
import com.fr.web.core.A.lD;
import com.fr.web.core.A.oD;
import com.fr.web.core.A.uC;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.factory.WebletFactory;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReportDispatcher {
    private static Service[] servicesAvailable = ReportDispatcher.initServiceArray();

    private static Service[] initServiceArray() {
        return new Service[]{lD.Y(), $D.R(), oD._(), EC.W(), h.T(), uC.V(), IconManager.getIconManager(), JarVersionService.getInstance()};
    }

    private ReportDispatcher() {
    }

    public static synchronized void registerGroupService(Service[] serviceArray) {
        if (ArrayUtils.isEmpty(serviceArray) && servicesAvailable != null) {
            return;
        }
        if (servicesAvailable == null) {
            servicesAvailable = new Service[0];
        }
        int n = servicesAvailable.length;
        int n2 = serviceArray.length;
        Service[] serviceArray2 = new Service[n + n2];
        System.arraycopy(servicesAvailable, 0, serviceArray2, 0, n);
        for (int i = 0; i < n2; ++i) {
            serviceArray2[n + i] = serviceArray[i];
        }
        servicesAvailable = serviceArray2;
    }

    public static void dealWithRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        if (ClusterConfigManager.getInstance().isUseCluster()) {
            if (ClusterHelper.CheckClusterDispatch(httpServletRequest, httpServletResponse, string, string2)) {
                return;
            }
            if (ComparatorUtils.equals(string, "cluster_share")) {
                AB.U().process(httpServletRequest, httpServletResponse, string);
            }
        }
        if ("closesessionid".equalsIgnoreCase(string) && string2 != null) {
            SessionDealWith.closeSession(string2);
            return;
        }
        if (string2 != null) {
            SessionDealWith.updateSessionID(string2);
            NameSpace nameSpace = SessionIDInfor.asNameSpace(string2);
            Calculator.putThreadSavedNameSpace(nameSpace);
        }
        if ("getSessionID".equalsIgnoreCase(string)) {
            if (string2 == null) {
                string2 = SessionDealWith.generateSessionIDWithCheckRegister(httpServletRequest, httpServletResponse);
            }
            SessionDealWith.responseSessionID(string2, httpServletResponse);
            return;
        }
        if (string2 != null && !SessionDealWith.hasSessionID(string2)) {
            SessionDealWith.writeSessionTimeout(httpServletRequest, httpServletResponse);
            return;
        }
        if (ClusterConfigManager.getInstance().isUseCluster() && ClusterHelper.CheckClusterDispatch(httpServletRequest, httpServletResponse, string, string2)) {
            return;
        }
        if (MemoryHelper.getMemoryAlarmProcessor().doSessionCheck(httpServletRequest, httpServletResponse)) {
            return;
        }
        ReportDispatcher.dealWeblet(string, string2, httpServletRequest, httpServletResponse);
    }

    private static void dealWeblet(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Weblet weblet;
        try {
            weblet = WebletFactory.createWebletByRequest(httpServletRequest, httpServletResponse);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            return;
        }
        if (weblet != null) {
            SessionDealWith.generateSessionID_checkPromptRegisted(httpServletRequest, httpServletResponse);
            weblet.dealWeblet(httpServletRequest, httpServletResponse);
            return;
        }
        if (string != null) {
            PerformanceManager.bindSessionInfo(string2);
            ReportDispatcher.dealWithOp(string, string2, httpServletRequest, httpServletResponse);
        } else {
            ReportDispatcher.dealWithoutOp(httpServletRequest, httpServletResponse);
        }
    }

    private static void dealWithoutOp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (NetworkHelper.getHTTPRequestParameter(httpServletRequest, "sessionID") != null) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (VT4FR.isLicAvailable(StableUtils.getBytes()) && VT4FR.FS_BI.support()) {
            hashMap.put("isSupportFS", "true");
        }
        hashMap.put("__locale__", WebUtils.getLocale(httpServletRequest));
        WebUtils.writeOutTemplate("/com/fr/web/core/deploySuccess.html", httpServletResponse, hashMap);
    }

    private static void dealWithOp(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        string = string.toLowerCase();
        httpServletRequest.setAttribute("op", (Object)string);
        Set set = ExtraClassManager.getInstance().getArray("SessionPrivilegeFilterProvider");
        for (Object object : set) {
            object.filterSession(httpServletRequest, httpServletResponse);
        }
        for (int i = 0; i < servicesAvailable.length; ++i) {
            Object object;
            object = servicesAvailable[i];
            String string3 = object.actionOP();
            if (!string.equalsIgnoreCase(string3)) continue;
            object.process(httpServletRequest, httpServletResponse, string, string2);
            return;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.println("Unresolvable Operation:" + StableUtils.replaceScript4Xss(string) + "  in class ReportDispatcher");
        printWriter.flush();
        printWriter.close();
    }

    static /* synthetic */ Service[] access$002(Service[] serviceArray) {
        servicesAvailable = serviceArray;
        return serviceArray;
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                ReportDispatcher.access$002(null);
            }

            public void onServletStart() {
                ReportDispatcher.access$002(ArrayUtils.addAll(servicesAvailable, ReportDispatcher.initServiceArray()));
            }
        });
    }
}

