/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.stable.FRException;
import com.fr.stable.HandlerMethod;
import com.fr.stable.fun.impl.AbstractErrorHandler;
import com.fr.web.core.DefaultHandlerMethod;
import com.fr.web.core.HandlerMethodHelper;
import com.fr.web.utils.WebUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultErrorHandler
extends AbstractErrorHandler {
    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable throwable) {
        this.error(httpServletRequest, httpServletResponse, throwable.getMessage(), throwable);
    }

    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        this.error(httpServletRequest, httpServletResponse, string, null);
    }

    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) {
        if (WebUtils.getDevice(httpServletRequest).isMobile()) {
            HandlerMethodHelper.postErrorMessageWithJSONObject(httpServletRequest, httpServletResponse, string, throwable);
        } else {
            HandlerMethodHelper.postErrorMessageOnPC(httpServletRequest, httpServletResponse, string, throwable);
        }
    }

    public void error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FRException fRException) {
        switch (fRException.getErrorType()) {
            case ERROR_CODE: {
                FRContext.getLogger().errorWithServerLevel(fRException.getMessage(), fRException.getCause());
                break;
            }
            default: {
                FRContext.getLogger().error(fRException.getMessage());
            }
        }
        HandlerMethod handlerMethod = fRException.getHandler();
        if (handlerMethod == null) {
            handlerMethod = new DefaultHandlerMethod();
        }
        if (WebUtils.getDevice(httpServletRequest).isMobile()) {
            handlerMethod.handlerMethodOnMobile(httpServletRequest, httpServletResponse, fRException);
        } else {
            handlerMethod.handlerMethodOnPC(httpServletRequest, httpServletResponse, fRException.getMessage(), fRException.getCause());
        }
    }
}

