/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.bridge;

import com.fr.stable.StableUtils;
import com.fr.stable.bridge.Aggregate;
import com.fr.stable.bridge.Transmitter;
import com.fr.stable.bridge.container.JavaScriptFilesContainer;
import com.fr.stable.bridge.container.StyleFileContainer;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.Weblet;
import com.fr.stable.xml.XMLable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StableFactory {
    private static StableFactory instance = new StableFactory();
    private Map<String, XMLable> xmlMap = new HashMap<String, XMLable>();
    private Map<String, Class> webletMap = new HashMap<String, Class>();
    private Set<String> localeFileDirSet = new LinkedHashSet<String>();
    private JavaScriptFilesContainer javaScriptFilesContainer = new JavaScriptFilesContainer();
    private Map<String, Aggregate> javascriptFilesAggregate = new HashMap<String, Aggregate>();
    private StyleFileContainer styleFileContainer = new StyleFileContainer();
    private Map<String, Object> markedMap = new HashMap<String, Object>();
    private Map<String, Class<?>> markedClassMap = new HashMap();
    private Map<String, List<Object>> markedLinkedListMap = new HashMap<String, List<Object>>();
    private ExtraClassManagerProvider extraClassManagerProvider = null;

    public static StableFactory getInstance() {
        return instance;
    }

    private StableFactory() {
    }

    public static void registerMarkedObject(String string, Object object) {
        StableFactory.instance.markedMap.put(string, object);
    }

    public static <T> T getMarkedObject(String string, Class<? extends T> clazz) {
        return StableFactory.getMarkedObject(string, clazz, null);
    }

    public static <T> T getMarkedObject(String string, Class<? extends T> clazz, T t) {
        Object object = StableFactory.instance.markedMap.get(string);
        if (object == null) {
            return t;
        }
        if (StableUtils.objectInstanceOf(object, clazz)) {
            return (T)object;
        }
        return t;
    }

    public static void registerMarkedClass(String string, Class<?> clazz) {
        StableFactory.instance.markedClassMap.put(string, clazz);
    }

    public static <T> Class<? extends T> getMarkedClass(String string, Class<T> clazz) {
        Class<?> clazz2 = StableFactory.instance.markedClassMap.get(string);
        if (clazz2 == null) {
            return null;
        }
        if (StableUtils.classInstanceOf(clazz2, clazz)) {
            return clazz2;
        }
        return null;
    }

    public static <T> T getMarkedInstanceObjectFromClass(String string, Class<? extends T> clazz) {
        return StableFactory.getMarkedInstanceObjectFromClass(string, clazz, null);
    }

    public static <T> T getMarkedInstanceObjectFromClass(String string, Class<? extends T> clazz, T t) {
        Class<?> clazz2 = StableFactory.instance.markedClassMap.get(string);
        if (clazz2 == null) {
            return t;
        }
        if (StableUtils.classInstanceOf(clazz2, clazz)) {
            try {
                return (T)clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return t;
    }

    public static <T> T getStaticMarkedInstanceObjectFromClass(String string, Class<? extends T> clazz) {
        Class<?> clazz2 = StableFactory.instance.markedClassMap.get(string);
        if (clazz2 == null) {
            return null;
        }
        if (StableUtils.classInstanceOf(clazz2, clazz)) {
            try {
                Method method = clazz2.getDeclaredMethod("getInstance", new Class[0]);
                return (T)method.invoke(clazz2, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T getMarkedInstanceObjectFromClass(String string, Object[] objectArray, Class<? extends T> clazz) {
        return StableFactory.getMarkedInstanceObjectFromClass(string, objectArray, new HashMap<String, Class>(), clazz, null);
    }

    public static <T> T getMarkedInstanceObjectFromClass(String string, Object[] objectArray, HashMap<String, Class> hashMap, Class<? extends T> clazz) {
        return StableFactory.getMarkedInstanceObjectFromClass(string, objectArray, hashMap, clazz, null);
    }

    public static <T> T getMarkedInstanceObjectFromClass(String string, Object[] objectArray, HashMap<String, Class> hashMap, Class<? extends T> clazz, T t) {
        Class<?> clazz2 = StableFactory.instance.markedClassMap.get(string);
        if (clazz2 == null) {
            return t;
        }
        if (StableUtils.classInstanceOf(clazz2, clazz)) {
            try {
                int n = objectArray.length;
                Class[] classArray = new Class[n];
                for (int i = 0; i < n; ++i) {
                    Class<?> clazz3 = hashMap.get(String.valueOf(i));
                    Class<?> clazz4 = clazz3 == null ? objectArray[i].getClass() : clazz3;
                    classArray[i] = StableFactory.dealWithPrimitvie(clazz4);
                }
                Constructor<?> constructor = clazz2.getConstructor(classArray);
                return (T)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Class not found : " + string);
            }
        }
        return t;
    }

    public static <T> T[] getMarkedObjectsFromCollection(String string, Class<? extends T> clazz) {
        List<Object> list = StableFactory.instance.markedLinkedListMap.get(string);
        if (list == null) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    public static void registerMarkedObjectToCollection(String string, Object object) {
        List<Object> list = StableFactory.instance.markedLinkedListMap.get(string);
        if (list == null) {
            list = new LinkedList<Object>();
            StableFactory.instance.markedLinkedListMap.put(string, list);
        }
        list.add(object);
    }

    public static void registerMarkedObjectToCollection(String string, Object[] objectArray) {
        List<Object> list = StableFactory.instance.markedLinkedListMap.get(string);
        if (list == null) {
            list = new LinkedList<Object>();
            StableFactory.instance.markedLinkedListMap.put(string, list);
        }
        for (Object object : objectArray) {
            list.add(object);
        }
    }

    public static void registerXMLDescription(String string, XMLable xMLable) {
        StableFactory.instance.xmlMap.put(string, xMLable);
    }

    public static XMLable createXmlObject(String string) {
        XMLable xMLable = StableFactory.instance.xmlMap.get(string);
        if (xMLable != null) {
            try {
                return (XMLable)xMLable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
        } else {
            throw new RuntimeException("Class not found : " + string);
        }
        return null;
    }

    public static String[] getJavaScriptFiles(String string) {
        return StableFactory.instance.javaScriptFilesContainer.getJavaScriptFiles(string);
    }

    public static void registerJavaScriptFiles(String string, String[] stringArray) {
        StableFactory.instance.javaScriptFilesContainer.registerJavaScriptFiles(string, stringArray);
    }

    public static Aggregate getJavaScriptAggregate(String string) {
        return StableFactory.instance.javascriptFilesAggregate.get(string);
    }

    public static void registerJavaScriptFiles(String string, String[] stringArray, Transmitter transmitter) {
        Aggregate aggregate = StableFactory.instance.javascriptFilesAggregate.get(string);
        if (aggregate == null) {
            aggregate = new Aggregate(stringArray, transmitter);
            StableFactory.instance.javascriptFilesAggregate.put(string, aggregate);
        }
    }

    public static String[] getStyleFiles(String string) {
        return StableFactory.instance.styleFileContainer.getStyleFiles(string);
    }

    public static void registerStyleFiles(String string, String[] stringArray) {
        StableFactory.instance.styleFileContainer.registerStyleFiles(string, stringArray);
    }

    public static String[] getLocaleFiles() {
        return StableFactory.instance.localeFileDirSet.toArray(new String[StableFactory.instance.localeFileDirSet.size()]);
    }

    public static void registerLocaleFile(String[] stringArray) {
        for (String string : stringArray) {
            StableFactory.instance.localeFileDirSet.add(string);
        }
    }

    public static Class getRegisteredClass(String string) {
        return StableFactory.getMarkedClass(string, Object.class);
    }

    private static Class<?> dealWithPrimitvie(Class<?> clazz) {
        try {
            return clazz == null ? null : (Class)clazz.getField("TYPE").get(null);
        }
        catch (Exception exception) {
            return clazz;
        }
    }

    public static void registerWeblet(String string, Class clazz) {
        StableFactory.instance.webletMap.put(string, clazz);
    }

    public static Weblet createWeblet(String string, String string2) {
        return StableFactory.createWeblet(string, string2, null);
    }

    public static Weblet createWeblet(String string, String string2, Map map) {
        Class clazz = StableFactory.instance.webletMap.get(string);
        if (clazz != null) {
            try {
                Weblet weblet = (Weblet)clazz.newInstance();
                weblet.setTplPath(string2);
                weblet.setParameterMap(map);
                return weblet;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtraClassManagerProvider getExtraClassManager() {
        if (StableFactory.instance.extraClassManagerProvider != null) {
            return StableFactory.instance.extraClassManagerProvider;
        }
        Class<StableFactory> clazz = StableFactory.class;
        synchronized (StableFactory.class) {
            try {
                Class<?> clazz2 = Class.forName("com.fr.plugin.ExtraClassManager");
                Method method = clazz2.getMethod("getInstance", new Class[0]);
                StableFactory.instance.extraClassManagerProvider = (ExtraClassManagerProvider)method.invoke(clazz2, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return StableFactory.instance.extraClassManagerProvider;
        }
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStart() {
                if (instance == null) {
                    instance = new StableFactory();
                }
            }

            public void onServletStop() {
                instance.javaScriptFilesContainer.close();
                instance.styleFileContainer.close();
                instance = new StableFactory();
            }
        });
    }
}

