/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Table;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.LogDuration;
import com.fr.general.Record;
import com.fr.stable.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class NTRecord
implements Record {
    public static final String TNAME_COLUMNNAME = "tname";
    public static final int TNAME_COLUMNTYPE = 12;
    public static final String TYPE_COLUMNNAME = "type";
    public static final int TYPE_COLUMNTYPE = -6;
    public static final String PARAM_COLUMNNAME = "param";
    public static final int PARAM_COLUMNTYPE = 12;
    public static final String LOGTIME_COLUMNNAME = "logtime";
    public static final int LOGTIME_COLUMNTYPE = 93;
    public static final String IP_COLUMNNAME = "ip";
    public static final int IP_COLUMNTYPE = 12;
    public static final String USERNAME_COLUMNNAME = "username";
    public static final int USERNAME_COLUMNTYPE = 12;
    public static final String USERROLE_COLUMNNAME = "userrole";
    public static final int USERROLE_COLUMNTYPE = 12;
    protected static final int MAX_PARA_SIZE = 2047;
    protected static final int MAX_SQL_SIZE = 10240;

    public Insert createInsert(String string, short s, String string2) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        Map map = this.getDurationParaMap();
        Insert insert = new Insert(new Table(this.getTableName()));
        insert.addColumn(TNAME_COLUMNNAME, 12, string);
        insert.addColumn(TYPE_COLUMNNAME, -6, new Short(s));
        this.addParaColumn(string2, insert);
        this.insertFromMapSource(map, IP_COLUMNNAME, 12, insert);
        this.insertFromMapSource(map, USERNAME_COLUMNNAME, 12, insert);
        this.insertFromMapSource(map, USERROLE_COLUMNNAME, 12, insert);
        insert.addColumn(LOGTIME_COLUMNNAME, 93, new Date());
        return insert;
    }

    private void addParaColumn(String string, Insert insert) {
        if (string == null) {
            return;
        }
        if (string.getBytes().length > 2047) {
            try {
                string = StringUtils.subStringByByteLength(string, "UTF8", 2047);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FRLogger.getLogger().error(unsupportedEncodingException.getMessage());
            }
        }
        insert.addColumn(PARAM_COLUMNNAME, 12, string);
    }

    protected Map getDurationParaMap() {
        LogDuration logDuration = FRLogManager.getSession();
        Map<Object, Object> map = new HashMap();
        if (logDuration != null) {
            map = logDuration.durationParameters();
        }
        return map;
    }

    protected void insertFromMapSource(Map map, String string, int n, Insert insert) {
        if (map.containsKey(string)) {
            insert.addColumn(string, n, map.get(string));
        }
    }
}

