/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.DateUtils;
import com.fr.general.doubleparse.NumberParser;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.ArrayProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.pinyin.ChineseHelper;
import com.fr.stable.pinyin.PinyinHelper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ComparatorUtils {
    private static Class[] commonIntNumberType = new Class[]{Integer.class, Long.class, Short.class, Byte.class};
    private static Class[] commonDecimalNumberType = new Class[]{Double.class, Float.class};

    private ComparatorUtils() {
    }

    public static int compare(Object object, Object object2) {
        return ComparatorUtils.compare(object, object2, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().toLowerCase().compareTo(object2.toString().toLowerCase());
            }
        });
    }

    public static int compare(Object object, Object object2, Comparator comparator) {
        if (object == null || object2 == null) {
            return object == null && object2 == null ? 0 : (object == null ? -1 : 1);
        }
        if (object instanceof Date || object2 instanceof Date) {
            long l;
            Date date = DateUtils.object2Date(object, true);
            Date date2 = DateUtils.object2Date(object2, true);
            long l2 = date == null ? 0L : date.getTime();
            long l3 = l = date2 == null ? 0L : date2.getTime();
            return l2 < l ? -1 : (l2 == l ? 0 : 1);
        }
        if (object instanceof Number && !(object2 instanceof Number)) {
            object2 = ComparatorUtils.parseDouble(object2);
        }
        if (object2 instanceof Number && !(object instanceof Number)) {
            object = ComparatorUtils.parseDouble(object);
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ComparatorUtils.compareNumber((Number)object, (Number)object2);
        }
        return comparator.compare(object.toString().toLowerCase(), object2.toString().toLowerCase());
    }

    public static int compareSQLType(Object object, Object object2) throws IllegalArgumentException {
        if (object == null || object2 == null) {
            return ComparatorUtils.compareIfHasNull(object, object2);
        }
        if (object == Primitive.NULL || object2 == Primitive.NULL) {
            return ComparatorUtils.compareIfHasPrimitiveNull(object, object2);
        }
        return ComparatorUtils.compareIfNotNull(object, object2);
    }

    private static int compareIfHasPrimitiveNull(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        return object == Primitive.NULL ? -1 : 1;
    }

    private static int compareIfHasNull(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        return object == null ? -1 : 1;
    }

    private static int compareIfHasNumber(Object object, Object object2) {
        if (!(object instanceof Number)) {
            return 1;
        }
        if (!(object2 instanceof Number)) {
            return -1;
        }
        return ComparatorUtils.compareNumber((Number)object, (Number)object2);
    }

    private static int compareNumber(Number number, Number number2) {
        if (ComparatorUtils.isInfinite(number, number2)) {
            return ComparatorUtils.compare(number.doubleValue(), number2.doubleValue());
        }
        if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
            return ComparatorUtils.compareIfHasBigDecimal(number, number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            return ComparatorUtils.compareIfHasBigInteger(number, number2);
        }
        return ComparatorUtils.compare(number.doubleValue(), number2.doubleValue());
    }

    private static int compareIfHasBigDecimal(Number number, Number number2) {
        if (number instanceof BigDecimal && number2 instanceof BigDecimal) {
            return ((BigDecimal)number).compareTo((BigDecimal)number2);
        }
        if (number instanceof BigDecimal) {
            return ComparatorUtils.compareBigDecimalWithOther((BigDecimal)number, number2);
        }
        return -ComparatorUtils.compareBigDecimalWithOther((BigDecimal)number2, number);
    }

    private static boolean isInfinite(Number number, Number number2) {
        return number instanceof Double && ((Double)number).isInfinite() || number2 instanceof Double && ((Double)number2).isInfinite();
    }

    private static int compareBigDecimalWithOther(BigDecimal bigDecimal, Number number) {
        if (ComparatorUtils.isCommonIntNumber(number)) {
            return bigDecimal.compareTo(new BigDecimal(number.longValue()));
        }
        return bigDecimal.compareTo(new BigDecimal(number.toString()));
    }

    private static int compareIfHasBigInteger(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).compareTo((BigInteger)number2);
        }
        if (number instanceof BigInteger) {
            return ComparatorUtils.compareBigIntegerWithOther((BigInteger)number, number2);
        }
        return -ComparatorUtils.compareBigIntegerWithOther((BigInteger)number2, number);
    }

    private static int compareBigIntegerWithOther(BigInteger bigInteger, Number number) {
        if (ComparatorUtils.isCommonIntNumber(number)) {
            return bigInteger.compareTo(BigInteger.valueOf(number.longValue()));
        }
        return new BigDecimal(bigInteger).compareTo(new BigDecimal(number.toString()));
    }

    private static boolean isCommonIntNumber(Number number) {
        return ComparatorUtils.isBelongTypeArray(commonIntNumberType, number);
    }

    private static boolean isBelongTypeArray(Class[] classArray, Number number) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(number)) continue;
            return true;
        }
        return false;
    }

    private static Object parseDouble(Object object) {
        NumberParser numberParser;
        Object object2 = object;
        String string = object2.toString();
        if (StableUtils.isNumber(string) && (numberParser = NumberParser.readJavaFormatString(string)) != NumberParser.EMPTY) {
            object2 = new Double(numberParser.doubleValue());
        }
        return object2;
    }

    public static int compare(double d, double d2) {
        if (d == d2) {
            return 0;
        }
        return d > d2 ? 1 : -1;
    }

    public static int compare(Comparator comparator, Object object, Object object2) {
        if (comparator instanceof Collator && object != null && object2 != null) {
            return comparator.compare(object.toString().toLowerCase(), object2.toString().toLowerCase());
        }
        return ComparatorUtils.compare(object, object2);
    }

    public static boolean arg1InArg2(Object object, Object object2) {
        if (object2 instanceof ArrayProvider) {
            ArrayProvider arrayProvider = (ArrayProvider)object2;
            boolean bl = false;
            int n = arrayProvider.length();
            for (int i = 0; i < n; ++i) {
                if (arrayProvider.elementAt(i) instanceof JSONArray) {
                    JSONArray jSONArray = (JSONArray)arrayProvider.elementAt(i);
                    int n2 = jSONArray.length();
                    for (int j = 0; j < n2; ++j) {
                        try {
                            if (!ComparatorUtils.equals(object, jSONArray.get(j))) continue;
                            bl = true;
                            break;
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    if (bl) break;
                }
                if (!ComparatorUtils.equals(object, arrayProvider.elementAt(i))) continue;
                bl = true;
                break;
            }
            return bl;
        }
        if (object instanceof String && object2 instanceof String) {
            return object2.toString().indexOf(object.toString()) >= 0;
        }
        if (object instanceof Number && object2 instanceof Number) {
            return (Double)ComparatorUtils.parseDouble(object2) >= (Double)ComparatorUtils.parseDouble(object);
        }
        try {
            if (object instanceof Number && object2 instanceof String || object2 instanceof Number && object instanceof String) {
                return ComparatorUtils.arg1InArg2(object.toString(), object2.toString()) || ComparatorUtils.arg1InArg2(Double.valueOf(object.toString()), Double.valueOf(object2.toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return ComparatorUtils.equals(object, object2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (object instanceof Primitive || object2 instanceof Primitive) {
            return object == object2;
        }
        if (object instanceof String && object2 instanceof String) {
            return object.equals(object2);
        }
        if (object instanceof Date || object2 instanceof Date) {
            return ComparatorUtils.compare(object, object2) == 0;
        }
        try {
            if (object instanceof String && object2 instanceof BigDecimal) {
                return ((BigDecimal)object2).compareTo(new BigDecimal((String)object)) == 0;
            }
            if (object2 instanceof String && object instanceof BigDecimal) {
                return ((BigDecimal)object).compareTo(new BigDecimal((String)object2)) == 0;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (object instanceof Number && !(object2 instanceof Number) && !((object2 = ComparatorUtils.parseDouble(object2)) instanceof Number)) {
            return false;
        }
        if (object2 instanceof Number && !(object instanceof Number) && !((object = ComparatorUtils.parseDouble(object)) instanceof Number)) {
            return false;
        }
        return ComparatorUtils.otherEquals(object, object2);
    }

    private static boolean otherEquals(Object object, Object object2) {
        if (object instanceof Number && object2 instanceof Number) {
            return ComparatorUtils.compareNumber((Number)object, (Number)object2) == 0;
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return object.toString().equals(object2.toString());
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return ComparatorUtils.arrayEquals(object, object2);
        }
        if (object instanceof List && object2 instanceof List) {
            return ComparatorUtils.equals((List)object, (List)object2);
        }
        if (object instanceof Set && object2 instanceof Set) {
            return ComparatorUtils.equals((Set)object, (Set)object2);
        }
        return object.equals(object2);
    }

    private static boolean arrayEquals(Object object, Object object2) {
        int n;
        int n2 = Array.getLength(object);
        if (n2 != (n = Array.getLength(object2))) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (ComparatorUtils.equals(Array.get(object, i), Array.get(object2, i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Set set, Set set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        Iterator iterator = set.iterator();
        Iterator iterator2 = set2.iterator();
        while (iterator.hasNext()) {
            if (ComparatorUtils.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (ComparatorUtils.equals(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals_exactly(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (object instanceof Date && object2 instanceof Date) {
            return ((Date)object).getTime() == ((Date)object2).getTime();
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
        }
        return object.equals(object2);
    }

    public static boolean tableDataColumnNameEquals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string.equals(string2)) {
            return true;
        }
        return string.toLowerCase().equals(string2.toLowerCase());
    }

    public static boolean equals(Iterator iterator, Iterator iterator2) {
        if (iterator == null) {
            iterator = Collections.EMPTY_LIST.iterator();
        }
        if (iterator2 == null) {
            iterator2 = Collections.EMPTY_LIST.iterator();
        }
        boolean bl = iterator.hasNext();
        boolean bl2 = iterator2.hasNext();
        while (bl && bl2) {
            if (!ComparatorUtils.equals(iterator.next(), iterator2.next())) {
                return false;
            }
            bl = iterator.hasNext();
            bl2 = iterator2.hasNext();
        }
        return bl == bl2;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray2 == null) {
            return objectArray == null && objectArray2 == null;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (ComparatorUtils.equals(objectArray[i], objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return nArray == null && nArray2 == null;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == null || lArray2 == null) {
            return lArray == null && lArray2 == null;
        }
        if (lArray.length != lArray2.length) {
            return false;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return dArray == null && dArray2 == null;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == null || cArray2 == null) {
            return cArray == null && cArray2 == null;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null || blArray2 == null) {
            return blArray == null && blArray2 == null;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int compareIfHasEmpty(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        return object == "" ? -1 : 1;
    }

    private static int compareIfNotNull(Object object, Object object2) {
        if (object instanceof String) {
            object = ComparatorUtils.parseDouble(object);
        }
        if (object2 instanceof String) {
            object2 = ComparatorUtils.parseDouble(object2);
        }
        if (object instanceof Number || object2 instanceof Number) {
            return ComparatorUtils.compareIfHasNumber(object, object2);
        }
        if (object instanceof String && object2 instanceof String) {
            return ((String)object).compareTo((String)object2);
        }
        if (object instanceof Date || object2 instanceof Date) {
            return ComparatorUtils.compare(object, object2);
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            return object.toString().compareTo(object2.toString());
        }
        throw new IllegalArgumentException("Unknown comparable type:" + object.getClass() + " " + object2.getClass());
    }

    public static int compareCommonType(Object object, Object object2) {
        if (object == null || object2 == null) {
            return ComparatorUtils.compareIfHasNull(object, object2);
        }
        if (object == Primitive.NULL || object2 == Primitive.NULL) {
            return ComparatorUtils.compareIfHasPrimitiveNull(object, object2);
        }
        if (object == "" || object2 == "") {
            return ComparatorUtils.compareIfHasEmpty(object, object2);
        }
        if (ComparatorUtils.hasNumberType(object, object2)) {
            return ComparatorUtils.compareIfHasNumber(ComparatorUtils.parseDouble(object), ComparatorUtils.parseDouble(object2));
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return ComparatorUtils.compareStringIfNotNull(string, string2);
        }
        return ComparatorUtils.compareIfNotNull(object, object2);
    }

    private static int compareStringIfNotNull(String string, String string2) {
        if (string.compareTo(string2) == 0) {
            return 0;
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            String string3 = String.valueOf(string.charAt(i));
            String string4 = String.valueOf(string2.charAt(i));
            int n4 = 0;
            n4 = ChineseHelper.isChinese(string3) && ChineseHelper.isChinese(string4) ? ComparatorUtils.compareIfNotNull(PinyinHelper.parseCNToPinyin(string3), PinyinHelper.parseCNToPinyin(string4)) : ComparatorUtils.compareIfNotNull(string3, string4);
            if (n4 == 0) continue;
            return n4;
        }
        return n - n2;
    }

    private static boolean hasNumberType(Object object, Object object2) {
        object = ComparatorUtils.parseDouble(object);
        object2 = ComparatorUtils.parseDouble(object2);
        return object instanceof Number || object2 instanceof Number;
    }
}

