/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.handler;

import com.fr.cache.Attachment;
import com.fr.data.core.db.BinaryObject;
import com.fr.data.core.db.handler.BlobDelegate;
import com.fr.data.core.db.handler.SQLTypeHandler;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.stable.Primitive;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.imageio.ImageIO;

public class BlobTypeHandler
implements SQLTypeHandler {
    private static final Image DEFAULT_IMAGE = IOUtils.readImage("/com/fr/base/images/image.png");
    private int defaultSize = 32768;

    public void setValue(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        byte[] byArray = new byte[]{};
        if (object instanceof byte[]) {
            byArray = (byte[])object;
        } else if (object instanceof Attachment) {
            byArray = ((Attachment)object).getBytes();
        } else if (object instanceof InputStream || object instanceof Blob) {
            if (object instanceof Blob) {
                object = ((Blob)object).getBinaryStream();
            }
            try {
                int n3;
                byte[] byArray2 = new byte[this.defaultSize];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n3 = ((InputStream)object).read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n3);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        } else if (object instanceof BufferedImage) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                if (ImageIO.write((RenderedImage)((BufferedImage)object), "png", byteArrayOutputStream)) {
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        } else {
            byArray = object instanceof BinaryObject ? ((BinaryObject)object).getBytes() : (object instanceof BlobDelegate ? ((BlobDelegate)object).getValue() : ("" + object).getBytes());
        }
        this.setBinaryStream(preparedStatement, n, byArray);
    }

    private void setBinaryStream(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        if (byArray.length == 0) {
            this.setNullBinaryStream(preparedStatement, n);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
        }
    }

    private void setNullBinaryStream(PreparedStatement preparedStatement, int n) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(" ".getBytes());
        preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, 0);
    }

    public Object getValue(ResultSet resultSet, int n, int n2) throws SQLException {
        switch (n2) {
            case 2004: {
                return resultSet.getBlob(n);
            }
            case -3: {
                return resultSet.getString(n);
            }
        }
        try {
            InputStream inputStream = resultSet.getBinaryStream(n);
            if (inputStream == null) {
                return Primitive.NULL;
            }
            return new BinaryObject(IOUtils.inputStream2Bytes(inputStream));
        }
        catch (Throwable throwable) {
            return DEFAULT_IMAGE;
        }
    }
}

