/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.data.AbstractTableData;
import com.fr.general.AppContentGenerator;
import com.fr.general.ComparatorUtils;
import com.fr.general.EnvProvider;
import com.fr.general.FRLogger;
import com.fr.general.FUNC;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.IOUtils;
import com.fr.general.ManagerFactory;
import com.fr.json.JSONObject;
import com.fr.stable.LicUtils;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class VersionInfoTableData
extends AbstractTableData {
    public static Object CONCURRENCY_IP = "5";
    private String[] columnNames;
    private Object[][] rowData;
    private static final String VERSION_UNREGISTERED = "FR-Engine_Unregistered";

    public VersionInfoTableData() {
        String[] stringArray = new String[]{"Key", "Value"};
        Object[][] objectArray = this.initDatas();
        this.columnNames = stringArray;
        this.rowData = objectArray;
    }

    public Object[][] initDatas() {
        MatchLic matchLic;
        LicWrapper licWrapper;
        SysInfoWrapper sysInfoWrapper;
        try {
            JSONObject jSONObject = this.generateJSONFromLic();
            sysInfoWrapper = this.readFromSystem();
            licWrapper = this.readFromLicJo(jSONObject);
            matchLic = this.validMatch(jSONObject, licWrapper, sysInfoWrapper);
        }
        catch (Exception exception) {
            sysInfoWrapper = new SysInfoWrapper();
            licWrapper = new LicWrapper();
            matchLic = new MatchLic();
            FRLogger.getLogger().error(exception.getMessage());
        }
        return this.getResultset(sysInfoWrapper, licWrapper, matchLic);
    }

    private Object[][] getResultset(SysInfoWrapper sysInfoWrapper, LicWrapper licWrapper, MatchLic matchLic) {
        return new Object[][]{{"Re-all-server-mac", sysInfoWrapper.macAddresses}, {"Re-first-mac", sysInfoWrapper.firstMacAddress}, {"Re-AppName", sysInfoWrapper.webAppName}, {"Re-uuid-in-system", sysInfoWrapper.uuid_in_system}, {"About-Version", licWrapper.version}, {"Re-version-in-lic", licWrapper.versionNumberInLic}, {"Re-binding-mac", licWrapper.bindingMacInLic}, {"Re-isonline-check", StringUtils.isNotEmpty(licWrapper.onlineKey)}, {"Re-appname-in-lic", licWrapper.appNameInLic}, {"Re-system-version", ProductConstants.VERSION}, {"Re-deadline", licWrapper.deadLine}, {"Re-lock-serial", licWrapper.lockSerial}, {"Re-sametime-ip", licWrapper.concurrency}, {"Re-uuid-in-lic", licWrapper.uuid_in_lic}, {"Re-lic-out-date", matchLic.isLicOutOfDate}, {"Re-uuid-match", matchLic.isUuidMatch}, {"Re-version-match", matchLic.isVersionNumberMatch}, {"Re-mac-match", matchLic.isMacAddressMatch}, {"Re-appname-match", matchLic.isAppNameMatch}, {"Re-appcontent-match", matchLic.isAppContentMatch}, {"Re-online-match", matchLic.isOnlineMatch}, {"Re-Jar", this.getBuildInfo()}};
    }

    private String getBuildInfo() {
        return "Build #" + GeneralUtils.readFullBuildNO();
    }

    private SysInfoWrapper readFromSystem() throws Exception {
        String string = StringUtils.join("\n", GeneralUtils.getMacAddresses());
        String string2 = GeneralUtils.getMacAddress();
        String string3 = GeneralUtils.getUUID();
        String string4 = GeneralContext.getCurrentAppNameOfEnv();
        String string5 = AppContentGenerator.generateAppContent();
        SysInfoWrapper sysInfoWrapper = new SysInfoWrapper();
        sysInfoWrapper.setFirstMacAddress(string2);
        sysInfoWrapper.setMacAddresses(string);
        sysInfoWrapper.setUuid_in_system(string3);
        sysInfoWrapper.setWebAppName(string4);
        sysInfoWrapper.setWebAppContent(string5);
        return sysInfoWrapper;
    }

    private LicWrapper readFromLicJo(JSONObject jSONObject) throws Exception {
        LicWrapper licWrapper = new LicWrapper();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Object object = "";
        String string7 = "";
        Object object2 = 0;
        Object object3 = 0;
        if (jSONObject != null && jSONObject.has("DEADLINE")) {
            string2 = FUNC.getEditionByFunc();
            object = jSONObject.get("VERSION");
            string3 = jSONObject.optString("APPNAME");
            string4 = jSONObject.optString("APPCONTENT");
            string6 = jSONObject.optString("UUID");
            Date date = new Date(jSONObject.getLong("DEADLINE"));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            string5 = simpleDateFormat.format(date);
            object2 = jSONObject.opt("SERIALNUMBER");
            object3 = jSONObject.opt("CONCURRENCY");
            if (ComparatorUtils.equals((Object)"0", object3)) {
                object3 = "FR-Engine_Not_limited_IP";
            }
            if (jSONObject.has("ONLINECHECK")) {
                string7 = jSONObject.optString("ONLINECHECK");
                if (!StableUtils.isMatchOnline()) {
                    string2 = VERSION_UNREGISTERED;
                    object3 = 2;
                }
            } else {
                string = jSONObject.optString("MACADDRESS");
            }
        } else {
            string2 = VERSION_UNREGISTERED;
            object = "FR-Engine_-None";
        }
        licWrapper.setAppNameInLic(string3);
        licWrapper.setAppContentInLic(string4);
        licWrapper.setBindingMacInLic(string);
        licWrapper.setConcurrency(object3);
        licWrapper.setDeadLine(string5);
        licWrapper.setLockSerial(object2);
        licWrapper.setUuid_in_lic(string6);
        licWrapper.setVersion(string2);
        licWrapper.setVersionNumberInLic(object);
        licWrapper.setOnlineKey(string7);
        return licWrapper;
    }

    private MatchLic validMatch(JSONObject jSONObject, LicWrapper licWrapper, SysInfoWrapper sysInfoWrapper) throws Exception {
        boolean bl;
        boolean bl2;
        String string = sysInfoWrapper.webAppName;
        String string2 = sysInfoWrapper.webAppContent;
        String string3 = licWrapper.bindingMacInLic;
        String string4 = licWrapper.uuid_in_lic;
        Object object = licWrapper.versionNumberInLic;
        String string5 = licWrapper.appNameInLic;
        String string6 = licWrapper.appContentInLic;
        boolean bl3 = jSONObject.optLong("DEADLINE") < Calendar.getInstance().getTimeInMillis();
        boolean bl4 = ComparatorUtils.equals((Object)ProductConstants.VERSION, object);
        if (ManagerFactory.getConfigProvider().isLicUseLock()) {
            bl2 = true;
            bl = true;
        } else {
            bl = GeneralUtils.isMacAddressMatch(string3);
            bl2 = GeneralUtils.isUUIDMatch(string4);
        }
        boolean bl5 = StringUtils.isEmpty(string5) || ComparatorUtils.equalsIgnoreCase(string5, string);
        boolean bl6 = StringUtils.isEmpty(string6) || ComparatorUtils.equalsIgnoreCase(string6, string2);
        MatchLic matchLic = new MatchLic();
        matchLic.setAppNameMatch(bl5);
        matchLic.setAppContentMatch(bl6);
        matchLic.setLicOutOfDate(bl3);
        matchLic.setMacAddressMatch(bl);
        matchLic.setUuidMatch(bl2);
        matchLic.setVersionNumberMatch(bl4);
        if (jSONObject.has("ONLINECHECK")) {
            matchLic.setOnlineMatch(!VERSION_UNREGISTERED.equals(licWrapper.version));
        }
        return matchLic;
    }

    private JSONObject generateJSONFromLic() {
        JSONObject jSONObject = null;
        try {
            byte[] byArray = StableUtils.getBytes();
            if (byArray == null) {
                InputStream inputStream = null;
                EnvProvider envProvider = GeneralContext.getEnvProvider();
                if (envProvider != null) {
                    inputStream = envProvider.readBean(envProvider.getLicName(), "resources");
                }
                if (inputStream != null) {
                    byArray = IOUtils.inputStream2Bytes(inputStream);
                }
            }
            jSONObject = LicUtils.getJsonFromBytes(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jSONObject;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.rowData.length;
    }

    public Object getValueAt(int n, int n2) {
        return this.rowData[n][n2];
    }

    private class MatchLic {
        boolean isVersionNumberMatch = false;
        boolean isMacAddressMatch = false;
        boolean isAppNameMatch = false;
        boolean isAppContentMatch = false;
        boolean isLicOutOfDate = false;
        boolean isUuidMatch = false;
        boolean isOnlineMatch = true;

        public boolean isVersionNumberMatch() {
            return this.isVersionNumberMatch;
        }

        public void setVersionNumberMatch(boolean bl) {
            this.isVersionNumberMatch = bl;
        }

        public boolean isMacAddressMatch() {
            return this.isMacAddressMatch;
        }

        public void setMacAddressMatch(boolean bl) {
            this.isMacAddressMatch = bl;
        }

        public boolean isAppNameMatch() {
            return this.isAppNameMatch;
        }

        public void setAppNameMatch(boolean bl) {
            this.isAppNameMatch = bl;
        }

        public boolean isLicOutOfDate() {
            return this.isLicOutOfDate;
        }

        public void setLicOutOfDate(boolean bl) {
            this.isLicOutOfDate = bl;
        }

        public boolean isUuidMatch() {
            return this.isUuidMatch;
        }

        public void setUuidMatch(boolean bl) {
            this.isUuidMatch = bl;
        }

        public boolean isAppContentMatch() {
            return this.isAppContentMatch;
        }

        public void setAppContentMatch(boolean bl) {
            this.isAppContentMatch = bl;
        }

        public boolean isOnlineMatch() {
            return this.isOnlineMatch;
        }

        public void setOnlineMatch(boolean bl) {
            this.isOnlineMatch = bl;
        }
    }

    private class LicWrapper {
        Object versionNumberInLic = "";
        String bindingMacInLic = "";
        String version = "FR-Engine_Unregistered";
        String appNameInLic = "";
        String appContentInLic = "";
        String deadLine = "";
        Object lockSerial = "FR-Engine_None";
        Object concurrency = CONCURRENCY_IP;
        String uuid_in_lic = "";
        String onlineKey = "";

        public Object getVersionNumberInLic() {
            return this.versionNumberInLic;
        }

        public void setVersionNumberInLic(Object object) {
            this.versionNumberInLic = object;
        }

        public String getBindingMacInLic() {
            return this.bindingMacInLic;
        }

        public void setBindingMacInLic(String string) {
            this.bindingMacInLic = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getAppNameInLic() {
            return this.appNameInLic;
        }

        public void setAppNameInLic(String string) {
            this.appNameInLic = string;
        }

        public String getDeadLine() {
            return this.deadLine;
        }

        public void setDeadLine(String string) {
            this.deadLine = string;
        }

        public Object getLockSerial() {
            return this.lockSerial;
        }

        public void setLockSerial(Object object) {
            this.lockSerial = object;
        }

        public Object getConcurrency() {
            return this.concurrency;
        }

        public void setConcurrency(Object object) {
            this.concurrency = object;
        }

        public String getUuid_in_lic() {
            return this.uuid_in_lic;
        }

        public void setUuid_in_lic(String string) {
            this.uuid_in_lic = string;
        }

        public String getOnlineKey() {
            return this.onlineKey;
        }

        public void setOnlineKey(String string) {
            this.onlineKey = string;
        }

        public String getAppContentInLic() {
            return this.appContentInLic;
        }

        public void setAppContentInLic(String string) {
            this.appContentInLic = string;
        }
    }

    private class SysInfoWrapper {
        String macAddresses = "";
        String firstMacAddress = "";
        String webAppName = "";
        String webAppContent = "";
        String uuid_in_system = "";

        public String getMacAddresses() {
            return this.macAddresses;
        }

        public void setMacAddresses(String string) {
            this.macAddresses = string;
        }

        public String getFirstMacAddress() {
            return this.firstMacAddress;
        }

        public void setFirstMacAddress(String string) {
            this.firstMacAddress = string;
        }

        public String getWebAppName() {
            return this.webAppName;
        }

        public void setWebAppName(String string) {
            this.webAppName = string;
        }

        public String getUuid_in_system() {
            return this.uuid_in_system;
        }

        public void setUuid_in_system(String string) {
            this.uuid_in_system = string;
        }

        public String getWebAppContent() {
            return this.webAppContent;
        }

        public void setWebAppContent(String string) {
            this.webAppContent = string;
        }
    }
}

