/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.CompressableOutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class BitOutputStream
extends CompressableOutputStream
implements FinishableOutputStream {
    private int bits = 0;
    private int bitPos = 0;

    public BitOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n2) throws IOException {
        super.write(n2);
    }

    public void finish() throws IOException {
        this.flushByte();
        if (this.out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)((Object)this.out)).finish();
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    protected void flushByte() throws IOException {
        if (this.bitPos == 0) {
            return;
        }
        this.write(this.bits);
        this.bits = 0;
        this.bitPos = 0;
    }

    public void byteAlign() throws IOException {
        this.flushByte();
    }

    public void writeBitFlag(boolean bl) throws IOException {
        this.writeUBits(bl ? 1L : 0L, 1);
    }

    public void writeSBits(long l2, int n2) throws IOException {
        long l3 = l2 & Integer.MAX_VALUE;
        if (l2 < 0L) {
            l3 |= 1L << n2 - 1;
        }
        this.writeUBits(l3, n2);
    }

    public void writeFBits(float f2, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        long l2 = (long)(f2 * 65536.0f);
        this.writeSBits(l2, n2);
    }

    public void writeUBits(long l2, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.bitPos == 0) {
            this.bitPos = 8;
        }
        int n3 = n2;
        while (n3 > 0) {
            while (this.bitPos > 0 && n3 > 0) {
                long l3 = l2 & 1L << n3 - 1;
                int n4 = this.bitPos - n3;
                l3 = n4 < 0 ? (l3 >>= -n4) : (l3 <<= n4);
                this.bits = (int)((long)this.bits | l3);
                --n3;
                --this.bitPos;
            }
            if (this.bitPos != 0) continue;
            this.write(this.bits);
            this.bits = 0;
            if (n3 <= 0) continue;
            this.bitPos = 8;
        }
    }

    public static int minBits(float f2) {
        return BitOutputStream.minBits((int)f2, true) + 16;
    }

    public static int minBits(long l2) {
        return BitOutputStream.minBits(l2, l2 < 0L);
    }

    public static int minBits(long l2, boolean bl) {
        int n2;
        l2 = Math.abs(l2);
        long l3 = 1L;
        for (n2 = 1; n2 <= 64 && (l3 <<= 1) <= l2; ++n2) {
        }
        return n2 + (bl ? 1 : 0);
    }
}

