/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.util.io.Action;
import org.freehep.util.io.TaggedInputStream;
import org.freehep.util.io.TaggedOutputStream;

public abstract class SWFAction
extends Action {
    private int version;

    protected SWFAction(int n2, int n3) {
        super(n2);
        this.version = n3;
    }

    public int getVersion() {
        return this.version;
    }

    public Action read(int n2, TaggedInputStream taggedInputStream, int n3) throws IOException {
        return this.read(n2, (SWFInputStream)taggedInputStream, n3);
    }

    public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        return this;
    }

    public void write(int n2, TaggedOutputStream taggedOutputStream) throws IOException {
        this.write(n2, (SWFOutputStream)taggedOutputStream);
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
    }

    public static class StringGreater
    extends SWFAction {
        public StringGreater() {
            super(104, 6);
        }
    }

    public static class Greater
    extends SWFAction {
        public Greater() {
            super(103, 6);
        }
    }

    public static class StrictEquals
    extends SWFAction {
        public StrictEquals() {
            super(102, 6);
        }
    }

    public static class Enumerate2
    extends SWFAction {
        public Enumerate2() {
            super(85, 6);
        }
    }

    public static class InstanceOf
    extends SWFAction {
        public InstanceOf() {
            super(84, 6);
        }
    }

    public static class BitURShift
    extends SWFAction {
        public BitURShift() {
            super(101, 5);
        }
    }

    public static class BitRShift
    extends SWFAction {
        public BitRShift() {
            super(100, 5);
        }
    }

    public static class BitLShift
    extends SWFAction {
        public BitLShift() {
            super(99, 5);
        }
    }

    public static class BitXor
    extends SWFAction {
        public BitXor() {
            super(98, 5);
        }
    }

    public static class BitOr
    extends SWFAction {
        public BitOr() {
            super(97, 5);
        }
    }

    public static class BitAnd
    extends SWFAction {
        public BitAnd() {
            super(96, 5);
        }
    }

    public static class NewMethod
    extends SWFAction {
        public NewMethod() {
            super(83, 5);
        }
    }

    public static class CallMethod
    extends SWFAction {
        public CallMethod() {
            super(82, 5);
        }
    }

    public static class Decrement
    extends SWFAction {
        public Decrement() {
            super(81, 5);
        }
    }

    public static class Increment
    extends SWFAction {
        public Increment() {
            super(80, 5);
        }
    }

    public static class SetMember
    extends SWFAction {
        public SetMember() {
            super(79, 5);
        }
    }

    public static class GetMember
    extends SWFAction {
        public GetMember() {
            super(78, 5);
        }
    }

    public static class StackSwap
    extends SWFAction {
        public StackSwap() {
            super(77, 5);
        }
    }

    public static class PushDuplicate
    extends SWFAction {
        public PushDuplicate() {
            super(76, 5);
        }
    }

    public static class ToString
    extends SWFAction {
        public ToString() {
            super(75, 5);
        }
    }

    public static class ToNumber
    extends SWFAction {
        public ToNumber() {
            super(74, 5);
        }
    }

    public static class Equals2
    extends SWFAction {
        public Equals2() {
            super(73, 5);
        }
    }

    public static class Less2
    extends SWFAction {
        public Less2() {
            super(72, 5);
        }
    }

    public static class Add2
    extends SWFAction {
        public Add2() {
            super(71, 5);
        }
    }

    public static class Enumerate
    extends SWFAction {
        public Enumerate() {
            super(70, 5);
        }
    }

    public static class TargetPath
    extends SWFAction {
        public TargetPath() {
            super(69, 5);
        }
    }

    public static class TypeOf
    extends SWFAction {
        public TypeOf() {
            super(68, 5);
        }
    }

    public static class InitObject
    extends SWFAction {
        public InitObject() {
            super(67, 5);
        }
    }

    public static class InitArray
    extends SWFAction {
        public InitArray() {
            super(66, 5);
        }
    }

    public static class DefineLocal2
    extends SWFAction {
        public DefineLocal2() {
            super(65, 5);
        }
    }

    public static class NewObject
    extends SWFAction {
        public NewObject() {
            super(64, 5);
        }
    }

    public static class Modulo
    extends SWFAction {
        public Modulo() {
            super(63, 5);
        }
    }

    public static class Return
    extends SWFAction {
        public Return() {
            super(62, 5);
        }
    }

    public static class CallFunction
    extends SWFAction {
        public CallFunction() {
            super(61, 5);
        }
    }

    public static class DefineLocal
    extends SWFAction {
        public DefineLocal() {
            super(60, 5);
        }
    }

    public static class Delete2
    extends SWFAction {
        public Delete2() {
            super(59, 5);
        }
    }

    public static class Delete
    extends SWFAction {
        public Delete() {
            super(58, 5);
        }
    }

    public static class DefineFunction
    extends SWFAction {
        private String name;
        private String[] params;
        private byte[] code;

        public DefineFunction(String string, String[] stringArray, byte[] byArray) {
            this();
            this.name = string;
            this.params = stringArray;
            this.code = byArray;
        }

        public DefineFunction() {
            super(155, 5);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            int n4;
            DefineFunction defineFunction = new DefineFunction();
            defineFunction.name = sWFInputStream.readString();
            int n5 = sWFInputStream.readUnsignedShort();
            for (n4 = 0; n4 < n5; ++n4) {
                defineFunction.params[n4] = sWFInputStream.readString();
            }
            n4 = sWFInputStream.readUnsignedShort();
            defineFunction.code = sWFInputStream.readByte(n4);
            return defineFunction;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeString(this.name);
            sWFOutputStream.writeUnsignedShort(this.params.length);
            for (int i2 = 0; i2 < this.params.length; ++i2) {
                sWFOutputStream.writeString(this.params[i2]);
            }
            sWFOutputStream.writeUnsignedShort(this.code.length);
            sWFOutputStream.writeByte(this.code);
        }

        public String toString() {
            return super.toString() + ", " + this.name + ", " + new String(this.code);
        }
    }

    public static class With
    extends SWFAction {
        private int size;
        private String block;

        public With(int n2, String string) {
            this();
            this.size = n2;
            this.block = string;
        }

        public With() {
            super(148, 5);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            With with = new With();
            with.size = sWFInputStream.readUnsignedShort();
            with.block = sWFInputStream.readString();
            return with;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeUnsignedShort(this.size);
            sWFOutputStream.writeString(this.block);
        }

        public String toString() {
            return super.toString() + ", " + this.size + ", " + this.block;
        }
    }

    public static class ConstantPool
    extends SWFAction {
        private String[] pool;

        public ConstantPool(String[] stringArray) {
            this();
            this.pool = stringArray;
        }

        public ConstantPool() {
            super(136, 5);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            ConstantPool constantPool = new ConstantPool();
            constantPool.pool = new String[sWFInputStream.readUnsignedShort()];
            for (int i2 = 0; i2 < constantPool.pool.length; ++i2) {
                constantPool.pool[i2] = sWFInputStream.readString();
            }
            return constantPool;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeUnsignedShort(this.pool.length);
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                sWFOutputStream.writeString(this.pool[i2]);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("[");
            for (int i2 = 0; i2 < this.pool.length; ++i2) {
                if (i2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.pool[i2]);
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static class StoreRegister
    extends SWFAction {
        private byte number;

        public StoreRegister(byte by) {
            this();
            this.number = by;
        }

        public StoreRegister() {
            super(135, 5);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            StoreRegister storeRegister = new StoreRegister();
            storeRegister.number = sWFInputStream.readByte();
            return storeRegister;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeByte(this.number);
        }

        public String toString() {
            return super.toString() + ", " + this.number;
        }
    }

    public static class MBAsciiToChar
    extends SWFAction {
        public MBAsciiToChar() {
            super(55, 4);
        }
    }

    public static class MBCharToAscii
    extends SWFAction {
        public MBCharToAscii() {
            super(54, 4);
        }
    }

    public static class MBStringExtract
    extends SWFAction {
        public MBStringExtract() {
            super(53, 4);
        }
    }

    public static class GetTime
    extends SWFAction {
        public GetTime() {
            super(52, 4);
        }
    }

    public static class AsciiToChar
    extends SWFAction {
        public AsciiToChar() {
            super(51, 4);
        }
    }

    public static class CharToAscii
    extends SWFAction {
        public CharToAscii() {
            super(50, 4);
        }
    }

    public static class MBStringLength
    extends SWFAction {
        public MBStringLength() {
            super(49, 4);
        }
    }

    public static class RandomNumber
    extends SWFAction {
        public RandomNumber() {
            super(48, 4);
        }
    }

    public static class StringLess
    extends SWFAction {
        public StringLess() {
            super(41, 4);
        }
    }

    public static class EndDrag
    extends SWFAction {
        public EndDrag() {
            super(40, 4);
        }
    }

    public static class StartDrag
    extends SWFAction {
        public StartDrag() {
            super(39, 4);
        }
    }

    public static class Trace
    extends SWFAction {
        public Trace() {
            super(38, 4);
        }
    }

    public static class RemoveSprite
    extends SWFAction {
        public RemoveSprite() {
            super(37, 4);
        }
    }

    public static class CloneSprite
    extends SWFAction {
        public CloneSprite() {
            super(36, 4);
        }
    }

    public static class SetProperty
    extends SWFAction {
        public SetProperty() {
            super(35, 4);
        }
    }

    public static class GetProperty
    extends SWFAction {
        public GetProperty() {
            super(34, 4);
        }
    }

    public static class StringAdd
    extends SWFAction {
        public StringAdd() {
            super(33, 4);
        }
    }

    public static class SetTarget2
    extends SWFAction {
        public SetTarget2() {
            super(32, 4);
        }
    }

    public static class GotoFrame2
    extends SWFAction {
        private byte play;

        public GotoFrame2(byte by) {
            this();
            this.play = by;
        }

        public GotoFrame2() {
            super(159, 4);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            GotoFrame2 gotoFrame2 = new GotoFrame2();
            gotoFrame2.play = sWFInputStream.readByte();
            return gotoFrame2;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeByte(this.play);
        }

        public String toString() {
            return super.toString() + ", " + this.play;
        }
    }

    public static class Call
    extends SWFAction {
        public Call() {
            super(158, 4);
        }
    }

    public static class If
    extends SWFAction {
        private short offset;

        public If(short s2) {
            this();
            this.offset = s2;
        }

        public If() {
            super(157, 4);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            If if_ = new If();
            if_.offset = sWFInputStream.readShort();
            return if_;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeShort(this.offset);
        }

        public String toString() {
            return super.toString() + ", " + this.offset;
        }
    }

    public static class SetVariable
    extends SWFAction {
        public SetVariable() {
            super(29, 4);
        }
    }

    public static class GetVariable
    extends SWFAction {
        public GetVariable() {
            super(28, 4);
        }
    }

    public static class GetURL2
    extends SWFAction {
        private byte method;
        public static final int NONE = 0;
        public static final int GET = 1;
        public static final int POST = 2;

        public GetURL2(byte by) {
            this();
            this.method = by;
        }

        public GetURL2() {
            super(154, 4);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            GetURL2 getURL2 = new GetURL2();
            getURL2.method = sWFInputStream.readByte();
            return getURL2;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeByte(this.method);
        }

        public String toString() {
            return super.toString() + ", " + this.method;
        }
    }

    public static class Jump
    extends SWFAction {
        private short offset;

        public Jump(short s2) {
            this();
            this.offset = s2;
        }

        public Jump() {
            super(153, 4);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            Jump jump = new Jump();
            jump.offset = sWFInputStream.readShort();
            return jump;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeShort(this.offset);
        }

        public String toString() {
            return super.toString() + ", " + this.offset;
        }
    }

    public static class ToInteger
    extends SWFAction {
        public ToInteger() {
            super(24, 4);
        }
    }

    public static class Pop
    extends SWFAction {
        public Pop() {
            super(23, 4);
        }
    }

    public static class Push
    extends SWFAction {
        public static final int STRING = 0;
        public static final int FLOAT = 1;
        public static final int NULL = 2;
        public static final int UNDEFINED = 3;
        public static final int REGISTER = 4;
        public static final int BOOLEAN = 5;
        public static final int DOUBLE = 6;
        public static final int INTEGER = 7;
        public static final int LOOKUP = 8;
        public static final int LOOKUP2 = 9;
        private Vector values;

        public Push() {
            super(150, 4);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            Push push = new Push();
            push.values = new Vector();
            try {
                while (true) {
                    push.values.add(Value.read(sWFInputStream));
                }
            }
            catch (EOFException eOFException) {
                return push;
            }
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            for (int i2 = 0; i2 < this.values.size(); ++i2) {
                ((Value)this.values.get(i2)).write(sWFOutputStream);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append("\n");
            for (int i2 = 0; i2 < this.values.size(); ++i2) {
                stringBuffer.append("   ");
                stringBuffer.append(this.values.get(i2));
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public static class Value {
            private byte type;
            private Object value;
            private byte[] data;

            public Value(String string) {
                this.type = 0;
                this.value = string;
            }

            public Value(float f2) {
                this.type = 1;
                this.value = new Float(f2);
            }

            public Value(Object object) {
                this.type = (byte)2;
                this.value = null;
            }

            public Value(byte by) {
                this.type = (byte)4;
                this.value = new Byte(by);
            }

            public Value(boolean bl) {
                this.type = (byte)5;
                this.value = new Boolean(bl);
            }

            public Value(double d2) {
                this.type = (byte)6;
                this.value = new Double(d2);
            }

            public Value(int n2) {
                this.type = (byte)7;
                this.value = new Integer(n2);
            }

            public Value(short s2) {
                this.type = (byte)8;
                this.value = new Short(s2);
            }

            public Value(byte by, byte[] byArray) {
                this.type = by;
                this.data = byArray;
            }

            public static Value read(SWFInputStream sWFInputStream) throws IOException {
                byte by = sWFInputStream.readByte();
                switch (by) {
                    case 0: {
                        return new Value(sWFInputStream.readString());
                    }
                    case 1: {
                        return new Value(sWFInputStream.readFloat());
                    }
                    case 2: {
                        return new Value(null);
                    }
                    case 4: {
                        return new Value((byte)sWFInputStream.readUnsignedByte());
                    }
                    case 5: {
                        return new Value(sWFInputStream.readByte() != 0);
                    }
                    case 6: {
                        return new Value(sWFInputStream.readDouble());
                    }
                    case 7: {
                        return new Value(sWFInputStream.readInt());
                    }
                    case 8: {
                        return new Value((short)sWFInputStream.readUnsignedByte());
                    }
                    case 9: {
                        return new Value(9, sWFInputStream.readByte(2));
                    }
                }
                return new Value(by, sWFInputStream.readByte((int)sWFInputStream.getLength()));
            }

            public void write(SWFOutputStream sWFOutputStream) throws IOException {
                sWFOutputStream.writeByte(this.type);
                switch (this.type) {
                    case 0: {
                        sWFOutputStream.writeString((String)this.value);
                        break;
                    }
                    case 1: {
                        sWFOutputStream.writeFloat(((Float)this.value).floatValue());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        sWFOutputStream.writeUnsignedByte(((Byte)this.value).byteValue());
                        break;
                    }
                    case 5: {
                        sWFOutputStream.writeBoolean((Boolean)this.value);
                        break;
                    }
                    case 6: {
                        sWFOutputStream.writeDouble((Double)this.value);
                        break;
                    }
                    case 7: {
                        sWFOutputStream.writeInt((Integer)this.value);
                        break;
                    }
                    case 8: {
                        sWFOutputStream.writeUnsignedByte(((Short)this.value).shortValue());
                        break;
                    }
                    case 9: {
                        sWFOutputStream.writeShort(((Short)this.value).shortValue());
                        break;
                    }
                    default: {
                        sWFOutputStream.writeByte(this.data);
                    }
                }
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("PushValue ");
                if (this.type < 0 || this.type > 9) {
                    stringBuffer.append("Unknown Data Type " + this.type + " with length " + this.data.length);
                } else {
                    stringBuffer.append(this.value);
                }
                return stringBuffer.toString();
            }
        }
    }

    public static class StringExtract
    extends SWFAction {
        public StringExtract() {
            super(21, 4);
        }
    }

    public static class StringLength
    extends SWFAction {
        public StringLength() {
            super(20, 4);
        }
    }

    public static class StringEquals
    extends SWFAction {
        public StringEquals() {
            super(19, 4);
        }
    }

    public static class Not
    extends SWFAction {
        public Not() {
            super(18, 4);
        }
    }

    public static class Or
    extends SWFAction {
        public Or() {
            super(17, 4);
        }
    }

    public static class And
    extends SWFAction {
        public And() {
            super(16, 4);
        }
    }

    public static class Less
    extends SWFAction {
        public Less() {
            super(15, 4);
        }
    }

    public static class Equals
    extends SWFAction {
        public Equals() {
            super(14, 4);
        }
    }

    public static class WaitForFrame2
    extends SWFAction {
        private int skip;

        public WaitForFrame2(int n2) {
            this();
            this.skip = n2;
        }

        public WaitForFrame2() {
            super(141, 4);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            WaitForFrame2 waitForFrame2 = new WaitForFrame2();
            waitForFrame2.skip = sWFInputStream.readUnsignedByte();
            return waitForFrame2;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeUnsignedByte(this.skip);
        }

        public String toString() {
            return super.toString() + ", skipCount:" + this.skip;
        }
    }

    public static class Divide
    extends SWFAction {
        public Divide() {
            super(13, 4);
        }
    }

    public static class Multiply
    extends SWFAction {
        public Multiply() {
            super(12, 4);
        }
    }

    public static class Subtract
    extends SWFAction {
        public Subtract() {
            super(11, 4);
        }
    }

    public static class Add
    extends SWFAction {
        public Add() {
            super(10, 4);
        }
    }

    public static class GotoLabel
    extends SWFAction {
        private String label;

        public GotoLabel(String string) {
            this();
            this.label = string;
        }

        public GotoLabel() {
            super(140, 3);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            GotoLabel gotoLabel = new GotoLabel();
            gotoLabel.label = sWFInputStream.readString();
            return gotoLabel;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeString(this.label);
        }

        public String toString() {
            return super.toString() + ", label " + this.label;
        }
    }

    public static class SetTarget
    extends SWFAction {
        private String target;

        public SetTarget(String string) {
            this();
            this.target = string;
        }

        public SetTarget() {
            super(139, 3);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            SetTarget setTarget = new SetTarget();
            setTarget.target = sWFInputStream.readString();
            return setTarget;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeString(this.target);
        }

        public String toString() {
            return super.toString() + ", target " + this.target;
        }
    }

    public static class WaitForFrame
    extends SWFAction {
        private int frame;
        private int skip;

        public WaitForFrame(int n2, int n3) {
            this();
            this.frame = n2;
            this.skip = n3;
        }

        public WaitForFrame() {
            super(138, 3);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            WaitForFrame waitForFrame = new WaitForFrame();
            waitForFrame.frame = sWFInputStream.readUnsignedShort();
            waitForFrame.skip = sWFInputStream.readUnsignedByte();
            return waitForFrame;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeUnsignedShort(this.frame);
            sWFOutputStream.writeUnsignedByte(this.skip);
        }

        public String toString() {
            return super.toString() + ", frame " + this.frame + ", skip " + this.skip;
        }
    }

    public static class StopSounds
    extends SWFAction {
        public StopSounds() {
            super(9, 3);
        }
    }

    public static class ToggleQuality
    extends SWFAction {
        public ToggleQuality() {
            super(8, 3);
        }
    }

    public static class Stop
    extends SWFAction {
        public Stop() {
            super(7, 3);
        }
    }

    public static class Play
    extends SWFAction {
        public Play() {
            super(6, 3);
        }
    }

    public static class PreviousFrame
    extends SWFAction {
        public PreviousFrame() {
            super(5, 3);
        }
    }

    public static class NextFrame
    extends SWFAction {
        public NextFrame() {
            super(4, 3);
        }
    }

    public static class GetURL
    extends SWFAction {
        private String url;
        private String window;

        public GetURL(String string, String string2) {
            this();
            this.url = string;
            this.window = string2;
        }

        public GetURL() {
            super(131, 3);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            GetURL getURL = new GetURL();
            getURL.url = sWFInputStream.readString();
            getURL.window = sWFInputStream.readString();
            return getURL;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeString(this.url);
            sWFOutputStream.writeString(this.window);
        }

        public String toString() {
            return super.toString() + ", URL " + this.url + ", window " + this.window;
        }
    }

    public static class GotoFrame
    extends SWFAction {
        private int frame;

        public GotoFrame(int n2) {
            this();
            this.frame = n2;
        }

        public GotoFrame() {
            super(129, 3);
        }

        public SWFAction read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
            GotoFrame gotoFrame = new GotoFrame();
            gotoFrame.frame = sWFInputStream.readUnsignedShort();
            return gotoFrame;
        }

        public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
            sWFOutputStream.writeUnsignedShort(this.frame);
        }

        public String toString() {
            return super.toString() + ", frame " + this.frame;
        }
    }
}

