/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.images.ImageUtilities;

public class DefineBitsJPEG2
extends DefinitionTag {
    protected int character;
    protected RenderedImage image;
    protected Properties options;
    private byte[] imageBytes;

    public DefineBitsJPEG2(int n2, Image image, Properties properties, Color color, ImageObserver imageObserver) {
        this(n2, ImageUtilities.createRenderedImage(image, imageObserver, color), color, properties);
    }

    public DefineBitsJPEG2(int n2, RenderedImage renderedImage, Color color, Properties properties) {
        this();
        this.character = n2;
        this.image = renderedImage;
        this.options = properties;
    }

    public DefineBitsJPEG2() {
        super(21, 2);
    }

    protected DefineBitsJPEG2(int n2, int n3) {
        super(n2, n3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineBitsJPEG2 defineBitsJPEG2 = new DefineBitsJPEG2();
        defineBitsJPEG2.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineBitsJPEG2.character, defineBitsJPEG2);
        byte[] byArray = sWFInputStream.readByte(n3 - 2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        defineBitsJPEG2.image = ImageGraphics2D.readImage("JPG".toLowerCase(), byteArrayInputStream);
        if (byteArrayInputStream.available() > 0) {
            System.err.println("DefineBitsJPEG2: not all bytes read: " + byteArrayInputStream.available());
        }
        return defineBitsJPEG2;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 2;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            this.imageBytes = ImageGraphics2D.toByteArray(this.image, "JPG", null, this.options);
        }
        return this.imageBytes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:  " + this.character + "\n");
        stringBuffer.append("  image:      " + this.image + "\n");
        return stringBuffer.toString();
    }
}

