/*
 * Decompiled with CFR 0.152.
 */
package com.fr.xml;

import com.fr.base.BaseObjectTokenizer;
import com.fr.base.BaseUtils;
import com.fr.base.ConfigManager;
import com.fr.base.DynamicUnitList;
import com.fr.base.EmailManager;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Painter;
import com.fr.base.Parameter;
import com.fr.base.ScreenResolution;
import com.fr.base.Style;
import com.fr.base.chart.BaseChartCollection;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.parameter.ParameterUI;
import com.fr.base.present.DictPresent;
import com.fr.base.present.FormulaPresent;
import com.fr.base.present.Present;
import com.fr.data.impl.TableColumn;
import com.fr.form.ui.Button;
import com.fr.form.ui.CellWidget;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.FieldEditor;
import com.fr.form.ui.FreeButton;
import com.fr.form.ui.Label;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetValue;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.BaseObjectXMLWriterFinder;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralUtils;
import com.fr.general.PageCalObj;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.main.parameter.processor.FormulaUnitProcessor;
import com.fr.main.parameter.processor.SQLQueryUnitProcessor;
import com.fr.main.parameter.processor.UnitProcessor;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.BarcodePresent;
import com.fr.report.cell.cellattr.DefaultPresent;
import com.fr.report.cell.cellattr.PageExportCellElement;
import com.fr.report.cell.cellattr.core.ResultSubReport;
import com.fr.report.cell.cellattr.core.RichText;
import com.fr.report.cell.cellattr.core.SubReport;
import com.fr.report.cell.cellattr.core.group.ConditionGroup;
import com.fr.report.cell.cellattr.core.group.CustomGrouper;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.cell.cellattr.core.group.FunctionGrouper;
import com.fr.report.cell.cellattr.core.group.IndexGrouper;
import com.fr.report.cell.cellattr.core.group.MonoGrouper;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.report.cell.cellattr.core.group.SummaryGrouper;
import com.fr.report.cell.cellattr.highlight.BackgroundHighlightAction;
import com.fr.report.cell.cellattr.highlight.BorderHighlightAction;
import com.fr.report.cell.cellattr.highlight.ColWidthHighlightAction;
import com.fr.report.cell.cellattr.highlight.DefaultHighlight;
import com.fr.report.cell.cellattr.highlight.FRFontHighlightAction;
import com.fr.report.cell.cellattr.highlight.ForegroundHighlightAction;
import com.fr.report.cell.cellattr.highlight.Highlight;
import com.fr.report.cell.cellattr.highlight.HighlightAction;
import com.fr.report.cell.cellattr.highlight.HyperlinkHighlightAction;
import com.fr.report.cell.cellattr.highlight.PaddingHighlightAction;
import com.fr.report.cell.cellattr.highlight.PageHighlightAction;
import com.fr.report.cell.cellattr.highlight.PresentHighlightAction;
import com.fr.report.cell.cellattr.highlight.RowHeightHighlightAction;
import com.fr.report.cell.cellattr.highlight.ValueHighlightAction;
import com.fr.report.cell.cellattr.highlight.WidgetHighlightAction;
import com.fr.report.cell.painter.BiasTextPainter;
import com.fr.report.cell.painter.shape.IssoscelesTriangleShapePainter;
import com.fr.report.cell.painter.shape.LineShapePainter;
import com.fr.report.cell.painter.shape.OvalShapePainter;
import com.fr.report.cell.painter.shape.RectangleShapePainter;
import com.fr.report.cell.painter.shape.RoundedRectangleShapePainter;
import com.fr.report.cell.painter.shape.ShapePainter;
import com.fr.report.cellcase.CellElementCaseGetter;
import com.fr.report.fun.ObjectMakeProvider;
import com.fr.report.report.Report;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.report.web.button.form.FormResetButton;
import com.fr.report.worksheet.AnalysisRWorkSheet;
import com.fr.report.worksheet.PageRWorkSheet;
import com.fr.report.worksheet.WorkSheet;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.FRFile;
import com.fr.stable.xml.ObjectXMLWriter;
import com.fr.stable.xml.XML;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.attr.ReportWebAttr;
import com.fr.xml.SynchronizedNameWidget;
import com.fr.xml.SynchronizedStyleList;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ReportXMLUtils {
    private ReportXMLUtils() {
    }

    private static Object tokenizeDetailObject(XMLableReader xMLableReader, String string, String string2) {
        if (ComparatorUtils.equals("CC", string)) {
            XMLable xMLable = StableFactory.createXmlObject("CC");
            if (xMLable != null) {
                xMLableReader.readXMLObject(xMLable);
            }
            return xMLable;
        }
        if (ComparatorUtils.equals("CP", string)) {
            XMLable xMLable = StableFactory.createXmlObject("CP");
            xMLableReader.readXMLObject(xMLable);
            return xMLable;
        }
        if (ComparatorUtils.equals("BiasTextPainter", string)) {
            BiasTextPainter biasTextPainter = new BiasTextPainter("");
            xMLableReader.readXMLObject(biasTextPainter);
            return biasTextPainter;
        }
        if (ReportXMLUtils.isDSColumn(string)) {
            DSColumn dSColumn = new DSColumn();
            xMLableReader.readXMLObject(dSColumn);
            return dSColumn;
        }
        if (ComparatorUtils.equals("SubReport", string)) {
            SubReport subReport = new SubReport();
            xMLableReader.readXMLObject(subReport);
            return subReport;
        }
        if (ComparatorUtils.equals("ResultSubReport", string)) {
            ResultSubReport resultSubReport = new ResultSubReport();
            xMLableReader.readXMLObject(resultSubReport);
            return resultSubReport;
        }
        if (ComparatorUtils.equals("RichText", string)) {
            RichText richText = new RichText();
            xMLableReader.readXMLObject(richText);
            return richText;
        }
        if (ComparatorUtils.equals("TableColumn", string)) {
            TableColumn tableColumn = new TableColumn();
            xMLableReader.readXMLObject(tableColumn);
            return tableColumn;
        }
        if ("ShapePainter".equals(string)) {
            return ReportXMLUtils.tokenizeShapePainter(xMLableReader, string2);
        }
        if ("Report".equals(string)) {
            return ReportXMLUtils.tokenizeSubReport(xMLableReader, string2);
        }
        if ("PB".equals(string)) {
            return ReportXMLUtils.readOldPBElement(xMLableReader);
        }
        if ("PE".equals(string)) {
            return ReportXMLUtils.readOldPEElement(xMLableReader);
        }
        if ("PR".equals(string)) {
            return ReportXMLUtils.tokenizeParameterRef(xMLableReader);
        }
        return ReportXMLUtils.readExtraObject(xMLableReader, string);
    }

    private static Object readExtraObject(XMLableReader xMLableReader, String string) {
        Set set = ExtraReportClassManager.getInstance().getArray("ObjectMakeProvider");
        for (ObjectMakeProvider objectMakeProvider : set) {
            if (!ComparatorUtils.equals(objectMakeProvider.xmlTag(), string)) continue;
            ObjectMakeProvider objectMakeProvider2 = objectMakeProvider.clone();
            xMLableReader.readXMLObject(objectMakeProvider2);
            return objectMakeProvider2;
        }
        return null;
    }

    private static boolean isDSColumn(String string) {
        return ComparatorUtils.equals("DSColumn", string) || ComparatorUtils.equals(string, "LinearDSColumn") || ComparatorUtils.equals(string, "ComplexDSColumn");
    }

    private static Object tokenizeShapePainter(XMLableReader xMLableReader, String string) {
        ShapePainter shapePainter = null;
        string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                shapePainter = (ShapePainter)GeneralUtils.classForName(string).newInstance();
            }
            catch (Exception exception) {
                shapePainter = new RectangleShapePainter();
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        xMLableReader.readXMLObject(shapePainter);
        return shapePainter;
    }

    private static Object tokenizeSubReport(XMLableReader xMLableReader, String string) {
        Report report = null;
        string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                report = (Report)GeneralUtils.classForName(string).newInstance();
            }
            catch (Exception exception) {
                report = new WorkSheet();
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        xMLableReader.readXMLObject(report);
        return report;
    }

    private static Object tokenizeParameterRef(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isChildNode() && ComparatorUtils.equals(xMLableReader.getTagName(), "ParameterRef") && (string = xMLableReader.getAttrAsString("name", null)) != null) {
                    this.obj = SynchronizedNameWidget.get(string);
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return xMLObject.getObject();
    }

    public static Report readReportFromClassName(String string) {
        Report report;
        if (string.endsWith(".WorkSheet")) {
            report = new WorkSheet();
        } else if (string.endsWith(".CommonERReport")) {
            report = new PageRWorkSheet();
        } else if (string.endsWith(".AnalysisRWorkSheet")) {
            report = new AnalysisRWorkSheet();
        } else if (string.endsWith(".PageRWorkSheet")) {
            report = new PageRWorkSheet();
        } else {
            try {
                Class clazz = GeneralUtils.classForName(string);
                report = (Report)clazz.newInstance();
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
                report = new WorkSheet();
            }
        }
        if (report == null) {
            report = new WorkSheet();
        }
        return report;
    }

    public static Highlight readHighlight(XMLableReader xMLableReader) {
        Highlight highlight = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".DefaultHighlight") || string.endsWith(".CellHighlight")) {
                highlight = new DefaultHighlight();
            } else {
                try {
                    highlight = (Highlight)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            }
        }
        if (highlight == null) {
            return highlight;
        }
        xMLableReader.readXMLObject(highlight);
        return highlight;
    }

    public static HighlightAction readHighlightAction(XMLableReader xMLableReader) {
        HighlightAction highlightAction = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string == null) {
            return highlightAction;
        }
        if (string.endsWith(".ValueHighlightAction") || string.endsWith(".NewValueHighlightAction")) {
            highlightAction = new ValueHighlightAction();
        } else if (string.endsWith(".PresentHighlightAction")) {
            highlightAction = new PresentHighlightAction();
        } else if (string.endsWith(".ForegroundHighlightAction")) {
            highlightAction = new ForegroundHighlightAction();
        } else if (string.endsWith(".BackgroundHighlightAction")) {
            highlightAction = new BackgroundHighlightAction();
        } else if (string.endsWith(".RowHeightHighlightAction")) {
            highlightAction = new RowHeightHighlightAction();
        } else if (string.endsWith(".ColWidthHighlightAction")) {
            highlightAction = new ColWidthHighlightAction();
        } else if (string.endsWith(".PageHighlightAction")) {
            highlightAction = new PageHighlightAction();
        } else if (string.endsWith(".PaddingHighlightAction")) {
            highlightAction = new PaddingHighlightAction();
        } else if (string.endsWith(".FRFontHighlightAction")) {
            highlightAction = new FRFontHighlightAction();
        } else if (string.endsWith(".HyperlinkHighlightAction")) {
            highlightAction = new HyperlinkHighlightAction();
        } else if (string.endsWith(".BorderHighlightAction")) {
            highlightAction = new BorderHighlightAction();
        } else if (string.endsWith(".WidgetHighlightAction")) {
            highlightAction = new WidgetHighlightAction();
        } else {
            try {
                highlightAction = (HighlightAction)GeneralUtils.classForName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                FRContext.getLogger().error(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRContext.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRContext.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        if (highlightAction != null) {
            xMLableReader.readXMLObject(highlightAction);
        }
        return highlightAction;
    }

    public static void writeReportPageCellElement(XMLPrintWriter xMLPrintWriter, PageExportCellElement pageExportCellElement) {
        if (pageExportCellElement == null) {
            return;
        }
        xMLPrintWriter.startTAG("C");
        ReportXMLUtils.writeCellCR(xMLPrintWriter, pageExportCellElement);
        pageExportCellElement.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private static void writeCellCR(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
        xMLPrintWriter.attr("c", cellElement.getColumn()).attr("r", cellElement.getRow());
        if (cellElement.getColumnSpan() != 1) {
            xMLPrintWriter.attr("cs", cellElement.getColumnSpan());
        }
        if (cellElement.getRowSpan() != 1) {
            xMLPrintWriter.attr("rs", cellElement.getRowSpan());
        }
    }

    private static void writeCellCRAndStyle(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
        ReportXMLUtils.writeCellCR(xMLPrintWriter, cellElement);
        if (cellElement.getStyle() != null && !ComparatorUtils.equals(cellElement.getStyle(), Style.DEFAULT_STYLE)) {
            SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList();
            xMLPrintWriter.attr("s", synchronizedStyleList.indexOfStyle(cellElement.getStyle()));
        }
    }

    public static void writeCellElement(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
        if (cellElement == null) {
            return;
        }
        xMLPrintWriter.startTAG("C");
        ReportXMLUtils.writeCellCRAndStyle(xMLPrintWriter, cellElement);
        cellElement.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeCellElementWithCommonResultAttr(XMLPrintWriter xMLPrintWriter, CellElement cellElement) {
        if (cellElement == null) {
            return;
        }
        xMLPrintWriter.startTAG("C");
        ReportXMLUtils.writeCellCRAndStyle(xMLPrintWriter, cellElement);
        cellElement.writeCommonResultAttrXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static Button readOldPBElement(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                String string;
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ParameterButton") && StringUtils.isNotBlank(string = xMLableReader.getAttrAsString("type", null))) {
                    if (string.equals("0")) {
                        FreeButton freeButton = StableFactory.getMarkedInstanceObjectFromClass("SubmitButton", FreeButton.class);
                        if (freeButton != null) {
                            arrayList.add(freeButton);
                        }
                    } else if (string.equals("1")) {
                        arrayList.add(new FormResetButton(xMLableReader.getAttrAsString("name", null)));
                    }
                }
            }
        });
        return arrayList.isEmpty() ? null : (Button)arrayList.get(0);
    }

    public static FieldEditor readOldPEElement(XMLableReader xMLableReader) {
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ParameterEditor")) {
                    ParameterEditor parameterEditor = new ParameterEditor();
                    xMLableReader.readXMLObject(parameterEditor);
                    arrayList.add(parameterEditor);
                }
            }
        });
        return arrayList.isEmpty() ? null : ((ParameterEditor)arrayList.get(0)).toFieldEditor();
    }

    public static void writeIndexStyle(XMLPrintWriter xMLPrintWriter, Style style) {
        if (style == null) {
            return;
        }
        SynchronizedStyleList synchronizedStyleList = SynchronizedStyleList.getSynchronizedStyleList();
        xMLPrintWriter.startTAG("Style").attr("index", synchronizedStyleList.indexOfStyle(style)).end();
    }

    public static void writeFloatElement(XMLPrintWriter xMLPrintWriter, FloatElement floatElement) {
        if (floatElement == null) {
            return;
        }
        xMLPrintWriter.startTAG(floatElement.getClass().getName());
        floatElement.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void readFloatElementList(XMLableReader xMLableReader, final List list, CellElementCaseGetter cellElementCaseGetter) {
        xMLableReader.setContextAttribute(CellElementCaseGetter.class, cellElementCaseGetter);
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode()) {
                    Object object;
                    String string = xMLableReader.getTagName();
                    Object object2 = null;
                    if (string.equals("ShapeFloatElement")) {
                        object = xMLableReader.getAttrAsString("class", null);
                        if (object != null) {
                            if (((String)object).endsWith(".IssoscelesTriangleShapeFloatElement")) {
                                object2 = new IssoscelesTriangleShapePainter();
                            } else if (((String)object).endsWith(".LineShapeFloatElement")) {
                                object2 = new LineShapePainter();
                            } else if (((String)object).endsWith(".OvalShapeFloatElement")) {
                                object2 = new OvalShapePainter();
                            } else if (((String)object).endsWith(".RectangleShapeFloatElement")) {
                                object2 = new RectangleShapePainter();
                            } else if (((String)object).endsWith(".RoundedRectangleShapeFloatElement")) {
                                object2 = new RoundedRectangleShapePainter();
                            }
                        }
                    } else if (string.equals("ImageFloatElement")) {
                        object2 = ((XMLObject)xMLableReader.readXMLObject(new XMLObject(){

                            public void readXML(XMLableReader xMLableReader) {
                                if (xMLableReader.isChildNode()) {
                                    if (xMLableReader.getTagName().equals("IM")) {
                                        this.obj = GeneralXMLTools.readImage(xMLableReader);
                                    } else if ("Image".equals(xMLableReader.getTagName())) {
                                        this.obj = GeneralXMLTools.deprecatedReadImage(xMLableReader);
                                    }
                                }
                            }
                        })).getObject();
                    }
                    if (object2 != null && object2 instanceof Painter) {
                        xMLableReader.readXMLObject((Painter)object2);
                    }
                    object = new FloatElement();
                    ((FloatElement)object).setValue(object2);
                    xMLableReader.readXMLObject((XMLReadable)object);
                    list.add(object);
                }
            }
        });
        xMLableReader.removeContextAttribute(CellElementCaseGetter.class);
    }

    public static ParameterUI readParameterUI(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        ParameterUI parameterUI = null;
        if (string != null) {
            if ("com.fr.main.parameter.UI.CustomParameterUI".equals(string)) {
                string = "com.fr.form.main.parameter.FormParameterUI";
            } else if ("com.fr.main.parameter.UI.FormParameterUI".equals("")) {
                string = "com.fr.form.main.parameter.FormParameterUI";
            }
            if (string.endsWith(".FormParameterUI")) {
                parameterUI = StableFactory.getMarkedInstanceObjectFromClass("FormParameterUI", ParameterUI.class);
                xMLableReader.readXMLObject(parameterUI);
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR65_XML_VERSION()) {
                    // empty if block
                }
                parameterUI.checkContainer();
            } else if (ReportXMLUtils.isCustomParameterUI(string)) {
                WorkSheet workSheet = new WorkSheet();
                xMLableReader.readXMLObject(workSheet);
                Dimension dimension = new Dimension();
                CellWidget[] cellWidgetArray = ReportXMLUtils.getCellWidgets(workSheet, dimension);
                parameterUI = StableFactory.getMarkedInstanceObjectFromClass("FormParameterUI", ParameterUI.class);
                parameterUI.setCellWidgets(cellWidgetArray);
                parameterUI.setDesignSize(dimension);
            } else {
                try {
                    parameterUI = StableFactory.getMarkedInstanceObjectFromClass("FormParameterUI", ParameterUI.class);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage());
                }
            }
        }
        return parameterUI;
    }

    public static void writeParameterUI(XMLPrintWriter xMLPrintWriter, ParameterUI parameterUI) {
        if (parameterUI == null) {
            return;
        }
        xMLPrintWriter.startTAG("ParameterUI");
        xMLPrintWriter.attr("class", parameterUI.getClass().getName());
        parameterUI.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    private static CellWidget[] getCellWidgets(WorkSheet workSheet, Dimension dimension) {
        ArrayList arrayList = new ArrayList();
        DynamicUnitList dynamicUnitList = ReportHelper.createColumnWidthList(workSheet);
        DynamicUnitList dynamicUnitList2 = ReportHelper.createRowHeightList(workSheet);
        int n2 = ScreenResolution.getScreenResolution();
        int n3 = ReportHelper.getTotalColumnWidth(workSheet).toPixI(n2);
        Iterator iterator = workSheet.cellIterator();
        int n4 = 0;
        int n5 = 0;
        while (iterator.hasNext()) {
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            Style style = templateCellElement.getStyle();
            Object object = templateCellElement.getValue();
            Widget widget = templateCellElement.getWidget();
            if ((object == null || !StringUtils.isNotEmpty(object.toString())) && widget == null && style.getBackground() == null) continue;
            ++n4;
            int n6 = templateCellElement.getColumn();
            int n7 = templateCellElement.getColumnSpan();
            int n8 = templateCellElement.getRow();
            int n9 = templateCellElement.getRowSpan();
            int n10 = dynamicUnitList.getRangeValueFromZero(n6).toPixI(n2);
            int n11 = dynamicUnitList2.getRangeValueFromZero(n8).toPixI(n2);
            int n12 = dynamicUnitList.getRangeValue(n6, n6 + n7).toPixI(n2);
            int n13 = dynamicUnitList2.getRangeValue(n8, n8 + n9).toPixI(n2);
            n5 = n13 == 19 ? 2 : 0;
            Rectangle rectangle = new Rectangle(n10, n11, n12, n13);
            ReportXMLUtils.dealWithWidgets(arrayList, widget, object, style, rectangle, n4);
        }
        int n14 = ReportHelper.getTotalRowHeight(workSheet).toPixI(n2);
        dimension.height = n14 += n5;
        dimension.width = n3 <= 800 ? 800 : n3;
        return arrayList.toArray(new CellWidget[arrayList.size()]);
    }

    private static void dealWithWidgets(List list, Widget widget, Object object, Style style, Rectangle rectangle, int n2) {
        if (widget == null) {
            Label label = new Label();
            label.setWidgetName("label" + n2);
            if (object != null && StringUtils.isNotEmpty(object.toString())) {
                WidgetValue.convertWidgetValue(label, object);
                label.setFont(style.getFRFont());
                int n3 = BaseUtils.getAlignment4Horizontal(style);
                label.setTextalign(n3 == -1 ? 2 : n3);
                label.setVerticalCenter(true);
            }
            list.add(new CellWidget(label, style, rectangle, object));
        } else {
            if (StringUtils.isEmpty(widget.getWidgetName())) {
                widget.setWidgetName("widget" + n2);
            }
            if (object != null && StringUtils.isNotEmpty(object.toString())) {
                if (widget instanceof DataControl) {
                    WidgetValue.convertWidgetValue((DataControl)((Object)widget), object);
                } else {
                    try {
                        Method method = widget.getClass().getMethod("setText", String.class);
                        method.invoke((Object)widget, object.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            list.add(new CellWidget(widget, style, rectangle, object));
        }
    }

    private static boolean isCustomParameterUI(String string) {
        return string.endsWith(".CustomParameterUI") || string.endsWith(".CustomParameterInterface") || string.endsWith(".CustomEmbeddedParameterInterface");
    }

    public static UnitProcessor readUnitProcessor(XMLableReader xMLableReader) {
        UnitProcessor unitProcessor = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".SQLQueryUnitProcessor")) {
                unitProcessor = new SQLQueryUnitProcessor();
            } else if (string.endsWith(".FormulaUnitProcessor")) {
                unitProcessor = new FormulaUnitProcessor();
            } else {
                try {
                    unitProcessor = (UnitProcessor)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    unitProcessor = null;
                }
            }
        }
        if (unitProcessor instanceof XMLable) {
            xMLableReader.readXMLObject((XMLReadable)((Object)unitProcessor));
        }
        return unitProcessor;
    }

    public static void writeUnitProcessor(XMLPrintWriter xMLPrintWriter, UnitProcessor unitProcessor) {
        xMLPrintWriter.startTAG("UP").attr("class", unitProcessor.getClass().getName());
        if (unitProcessor instanceof XMLable) {
            ((XMLable)((Object)unitProcessor)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static Formula readFormula(XMLableReader xMLableReader) {
        Formula formula = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                Class clazz = GeneralUtils.classForName(string);
                formula = (Formula)clazz.newInstance();
                xMLableReader.readXMLObject(formula);
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        return formula;
    }

    public static Present readPresent(XMLableReader xMLableReader) {
        Present present = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".DictPresent")) {
                present = new DictPresent();
            } else if (string.endsWith(".BarcodePresent")) {
                present = new BarcodePresent();
            } else if (string.endsWith(".FormulaPresent")) {
                present = new FormulaPresent();
            } else if (string.endsWith(".DefaultPresent")) {
                present = new DefaultPresent();
            } else {
                try {
                    if (string.startsWith("com.fr.report.cellElement")) {
                        string = string.replaceFirst("com.fr.report.cellElement", "com.fr.report.cell.cellattr");
                    }
                    if (string.startsWith("com.fr.report.cellattr")) {
                        string = string.replaceFirst("com.fr.report.cellattr", "com.fr.report.cell.cellattr");
                    }
                    Class clazz = GeneralUtils.classForName(string);
                    present = (Present)clazz.newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            }
            if (present != null) {
                xMLableReader.readXMLObject(present);
            }
        }
        return present;
    }

    public static void writeRectangle(XMLPrintWriter xMLPrintWriter, Rectangle rectangle, String string) {
        if (rectangle == null) {
            return;
        }
        xMLPrintWriter.startTAG(string).attr("x", rectangle.x).attr("y", rectangle.y).attr("w", rectangle.width).attr("h", rectangle.height).end();
    }

    public static Rectangle readRectangle(XMLableReader xMLableReader) {
        return new Rectangle(xMLableReader.getAttrAsInt("x", 0), xMLableReader.getAttrAsInt("y", 0), xMLableReader.getAttrAsInt("w", 0), xMLableReader.getAttrAsInt("h", 0));
    }

    public static RecordGrouper readXMLRecordGrouper(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if ("GC".equals(string)) {
            return ReportXMLUtils.readGroupCalculator2RecordGrouper(xMLableReader);
        }
        if ("SpecifiedGroupAttr".equals(string)) {
            return ReportXMLUtils.readGA2RecordGrouper(xMLableReader);
        }
        RecordGrouper recordGrouper = null;
        String string2 = xMLableReader.getAttrAsString("class", null);
        if (string2 != null) {
            if (string2.endsWith(".ValueGrouper")) {
                recordGrouper = new FunctionGrouper();
            } else if (string2.endsWith(".IndexGrouper")) {
                recordGrouper = new IndexGrouper();
            } else if (string2.endsWith(".MonoGrouper")) {
                recordGrouper = new MonoGrouper();
            } else if (string2.endsWith(".SummaryGrouper")) {
                recordGrouper = new SummaryGrouper();
            } else if (string2.endsWith(".CustomGrouper")) {
                recordGrouper = new CustomGrouper();
            } else if (string2.endsWith(".FunctionGrouper")) {
                recordGrouper = new FunctionGrouper();
            } else {
                try {
                    if (string2.startsWith("com.fr.report.cellElement")) {
                        string2 = string2.replaceAll("com.fr.report.cellElement.core", "com.fr.report.cell.cellattr.core.group");
                    }
                    recordGrouper = (RecordGrouper)GeneralUtils.classForName(string2).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
            }
            xMLableReader.readXMLObject(recordGrouper);
        }
        return recordGrouper;
    }

    private static RecordGrouper readGroupCalculator2RecordGrouper(XMLableReader xMLableReader) {
        String string;
        RecordGrouper recordGrouper = null;
        String string2 = xMLableReader.getAttrAsString("class", null);
        if (string2.endsWith(".DefaultGroupCalculator")) {
            XMLObject xMLObject = new XMLObject(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && ("GA".equals(string = xMLableReader.getTagName()) || "SpecifiedGroupAttr".equals(string))) {
                        this.obj = ReportXMLUtils.readGA2RecordGrouper(xMLableReader);
                    }
                }
            };
            xMLableReader.readXMLObject(xMLObject);
            recordGrouper = (RecordGrouper)xMLObject.getObject();
        } else if (string2.endsWith(".FormulaGroupCalculator") && (string = xMLableReader.getElementValue()) != null && string.length() > 0) {
            recordGrouper = new FunctionGrouper();
            ((FunctionGrouper)recordGrouper).setFormulaContent(string);
        }
        return recordGrouper;
    }

    private static RecordGrouper readGA2RecordGrouper(XMLableReader xMLableReader) {
        CustomGrouper customGrouper = new CustomGrouper();
        String string = xMLableReader.getAttrAsString("other", null);
        if (string != null) {
            customGrouper.setOther(Integer.parseInt(string));
        }
        if ((string = xMLableReader.getAttrAsString("odisplay", null)) != null) {
            customGrouper.setOdisplay(string);
        }
        if ((string = xMLableReader.getAttrAsString("force", null)) != null) {
            customGrouper.setForce(Boolean.valueOf(string));
        }
        final ArrayList arrayList = new ArrayList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ConditionListGroup")) {
                    ConditionGroup conditionGroup = new ConditionGroup();
                    xMLableReader.readXMLObject(conditionGroup);
                    arrayList.add(conditionGroup);
                }
            }
        });
        customGrouper.setConditionGroups(arrayList.toArray(new ConditionGroup[arrayList.size()]));
        return customGrouper;
    }

    public static void writeXMLPloyBlockAttr(XMLPrintWriter xMLPrintWriter, PolyBlockAttr polyBlockAttr) {
        if (polyBlockAttr == null) {
            return;
        }
        xMLPrintWriter.startTAG("PolyBlockAttr");
        xMLPrintWriter.attr("class", polyBlockAttr.getClass().getName());
        polyBlockAttr.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static PolyBlockAttr readXMLPolyBlockAttr(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if ("com.fr.report.poly.PolyBlockAttr".equals(string)) {
            string = "com.fr.report.stable.PolyBlockAttr";
        }
        PolyBlockAttr polyBlockAttr = null;
        if (StringUtils.isNotEmpty(string)) {
            try {
                polyBlockAttr = (PolyBlockAttr)GeneralUtils.classForName(string).newInstance();
                polyBlockAttr.readXML(xMLableReader);
            }
            catch (InstantiationException instantiationException) {
                FRContext.getLogger().error(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRContext.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRContext.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        return polyBlockAttr;
    }

    private static class REPORT
    extends XML {
        REPORT(Report report) {
            this.xml = report;
        }

        public String type() {
            return "Report";
        }

        public String className() {
            return this.xml.getClass().getName();
        }
    }

    private static class SP
    extends XML {
        SP(ShapePainter shapePainter) {
            this.xml = shapePainter;
        }

        public String type() {
            return "ShapePainter";
        }

        public String className() {
            return this.xml.getClass().getName();
        }
    }

    private static class TABLECOLUMN
    extends XML {
        TABLECOLUMN(TableColumn tableColumn) {
            this.xml = tableColumn;
        }

        public String type() {
            return "TableColumn";
        }
    }

    private static class RESULTSUBREPORT
    extends XML {
        RESULTSUBREPORT(ResultSubReport resultSubReport) {
            this.xml = resultSubReport;
        }

        public String type() {
            return "ResultSubReport";
        }
    }

    private static class RICHTEXT
    extends XML {
        RICHTEXT(RichText richText) {
            this.xml = richText;
        }

        public String type() {
            return "RichText";
        }
    }

    private static class SUBREPORT
    extends XML {
        SUBREPORT(SubReport subReport) {
            this.xml = subReport;
        }

        public String type() {
            return "SubReport";
        }
    }

    private static class DSCOLUMN
    extends XML {
        DSCOLUMN(DSColumn dSColumn) {
            this.xml = dSColumn;
        }

        public String type() {
            return "DSColumn";
        }
    }

    private static class BTP
    extends XML {
        BTP(BiasTextPainter biasTextPainter) {
            this.xml = biasTextPainter;
        }

        public String type() {
            return "BiasTextPainter";
        }
    }

    private static class CP
    extends XML {
        CP(BaseChartPainter baseChartPainter) {
            this.xml = baseChartPainter;
        }

        public String type() {
            return "CP";
        }
    }

    private static class CC
    extends XML {
        CC(BaseChartCollection baseChartCollection) {
            this.xml = baseChartCollection;
        }

        public String type() {
            return "CC";
        }
    }

    private static class XMLABLE
    extends XML {
        public XMLABLE(XMLable xMLable) {
            this.xml = xMLable;
        }

        public String type() {
            return "XMLable";
        }

        public String className() {
            return this.xml.getClass().getName();
        }
    }

    private static class FRFILEXML
    extends XML {
        public FRFILEXML(FRFile fRFile) {
            this.xml = fRFile;
        }

        public String type() {
            return "FRF";
        }
    }

    private static class PAGECALOBJXML
    extends XML {
        public PAGECALOBJXML(PageCalObj pageCalObj) {
            this.xml = pageCalObj;
        }

        public String type() {
            return "PCOBJ";
        }
    }

    public static class ReportObjectXMLWriterFinder
    extends BaseObjectXMLWriterFinder {
        public ObjectXMLWriter as(Object object) {
            ObjectXMLWriter objectXMLWriter = super.as(object);
            if (objectXMLWriter instanceof BaseObjectXMLWriterFinder.ElseAsString) {
                Set set = ExtraReportClassManager.getInstance().getArray("ObjectMakeProvider");
                for (ObjectMakeProvider objectMakeProvider : set) {
                    if (!objectMakeProvider.accept(object)) continue;
                    return objectMakeProvider.asXMLObject(object);
                }
                if (object instanceof BaseChartCollection) {
                    return new CC((BaseChartCollection)object);
                }
                if (object instanceof BaseChartPainter) {
                    return new CP((BaseChartPainter)object);
                }
                if (object instanceof BiasTextPainter) {
                    return new BTP((BiasTextPainter)object);
                }
                if (object instanceof DSColumn) {
                    return new DSCOLUMN((DSColumn)object);
                }
                if (object instanceof SubReport) {
                    return new SUBREPORT((SubReport)object);
                }
                if (object instanceof ResultSubReport) {
                    return new RESULTSUBREPORT((ResultSubReport)object);
                }
                if (object instanceof ShapePainter) {
                    return new SP((ShapePainter)object);
                }
                if (object instanceof Report) {
                    return new REPORT((Report)object);
                }
                if (object instanceof TableColumn) {
                    return new TABLECOLUMN((TableColumn)object);
                }
                if (object instanceof PageCalObj) {
                    return new PAGECALOBJXML((PageCalObj)object);
                }
                if (object instanceof FRFile) {
                    return new FRFILEXML((FRFile)object);
                }
                if (object instanceof RichText) {
                    return new RICHTEXT((RichText)object);
                }
                if (object instanceof XMLable) {
                    return new XMLABLE((XMLable)object);
                }
                return new BaseObjectXMLWriterFinder.ElseAsString(object);
            }
            return objectXMLWriter;
        }
    }

    private static final class ParameterEditor
    implements XMLReadable {
        private String name;
        private FieldEditor editor;
        private Object defaultValue;

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode()) {
                String string = xMLableReader.getTagName();
                if ("CellEditorDef".equals(string)) {
                    this.editor = WidgetXmlUtils.readFieldEditor(xMLableReader);
                } else if ("O".equals(string)) {
                    this.defaultValue = GeneralXMLTools.readObject(xMLableReader);
                } else if ("Name".equals(string)) {
                    this.name = xMLableReader.getElementValue();
                }
            }
        }

        public FieldEditor toFieldEditor() {
            if (this.editor != null) {
                this.editor.setWidgetName(this.name);
            }
            return this.editor;
        }
    }

    private static class CompateEmailManagerInReportWebAttrWhen652
    implements XMLReadable {
        private ReportWebAttr attr;
        private ConfigManager configManager;

        CompateEmailManagerInReportWebAttrWhen652(ConfigManager configManager, ReportWebAttr reportWebAttr) {
            this.configManager = configManager;
            this.attr = reportWebAttr;
        }

        public void readXML(XMLableReader xMLableReader) {
            this.attr.readXML(xMLableReader);
            if (xMLableReader.isChildNode() && "EmailManager".equals(xMLableReader.getTagName())) {
                EmailManager emailManager = new EmailManager();
                xMLableReader.readXMLObject(emailManager);
                this.configManager.setEmailManager(emailManager);
            }
        }
    }

    public static class ReportObjectTokenizer
    extends BaseObjectTokenizer {
        public Object tokenizerObject(XMLableReader xMLableReader, boolean bl, String string, ThreadLocal threadLocal) {
            String string2 = null;
            Object object = super.tokenizerObject(xMLableReader, bl, string, threadLocal);
            if (threadLocal != null) {
                if (threadLocal.get() instanceof Parameter) {
                    if ("Widget".equals(string) || "CellEditorDef".equals(string)) {
                        Parameter parameter = (Parameter)threadLocal.get();
                        FieldEditor fieldEditor = WidgetXmlUtils.readFieldEditor(xMLableReader);
                        SynchronizedNameWidget.put(parameter.getName(), fieldEditor);
                        SynchronizedNameWidget.put(parameter.getName(), parameter.getValue());
                        return fieldEditor;
                    }
                } else if (threadLocal.get() instanceof ConfigManager && "ReportWebAttr".equals(string)) {
                    ReportWebAttr reportWebAttr = new ReportWebAttr();
                    ConfigManager configManager = (ConfigManager)threadLocal.get();
                    configManager.putGlobalAttribute(ReportWebAttr.class, reportWebAttr);
                    xMLableReader.readXMLObject(new CompateEmailManagerInReportWebAttrWhen652(configManager, reportWebAttr));
                }
                threadLocal.set(null);
            }
            if (object != null) {
                return object;
            }
            return ReportXMLUtils.tokenizeDetailObject(xMLableReader, string, string2);
        }
    }
}

