/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.writers;

import com.fr.third.javax.xml.stream.xerces.util.XMLStringBuffer;
import java.io.IOException;
import java.io.Writer;

public class XMLWriter
extends Writer {
    private Writer writer;
    private int size;
    private XMLStringBuffer buffer = new XMLStringBuffer(12288);
    private static final int THRESHHOLD_LENGTH = 4096;
    private static final boolean DEBUG = false;

    public XMLWriter(Writer writer) {
        this(writer, 4096);
    }

    public XMLWriter(Writer writer, int n2) {
        this.writer = writer;
        this.size = n2;
    }

    public void write(int n2) throws IOException {
        this.ensureOpen();
        this.buffer.append((char)n2);
        this.conditionalWrite();
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n3 > this.size) {
            this.writeBufferedData();
            this.writer.write(cArray, n2, n3);
        } else {
            this.buffer.append(cArray, n2, n3);
            this.conditionalWrite();
        }
    }

    public void write(String string, int n2, int n3) throws IOException {
        this.write(string.toCharArray(), n2, n3);
    }

    public void write(String string) throws IOException {
        if (string.length() > this.size) {
            this.writeBufferedData();
            this.writer.write(string);
        } else {
            this.buffer.append(string);
            this.conditionalWrite();
        }
    }

    public void close() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.flush();
        this.writer.close();
        this.writer = null;
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.writeBufferedData();
        this.writer.flush();
    }

    public void reset() {
        this.writer = null;
        this.buffer.clear();
        this.size = 4096;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
        this.buffer.clear();
        this.size = 4096;
    }

    public void setWriter(Writer writer, int n2) {
        this.writer = writer;
        this.size = n2;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    private void conditionalWrite() throws IOException {
        if (this.buffer.length > this.size) {
            this.writeBufferedData();
        }
    }

    private void writeBufferedData() throws IOException {
        this.writer.write(this.buffer.ch, this.buffer.offset, this.buffer.length);
        this.buffer.clear();
    }

    private void ensureOpen() throws IOException {
        if (this.writer == null) {
            throw new IOException("Stream closed");
        }
    }
}

