/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.PropertyManager;
import com.fr.third.javax.xml.stream.XMLEntityManager;
import com.fr.third.javax.xml.stream.XMLEntityReaderImpl;
import com.fr.third.javax.xml.stream.XMLEntityStorage;
import com.fr.third.javax.xml.stream.XMLErrorReporter;
import com.fr.third.javax.xml.stream.events.XMLEvent;
import com.fr.third.javax.xml.stream.xerces.util.SymbolTable;
import com.fr.third.javax.xml.stream.xerces.util.XMLChar;
import com.fr.third.javax.xml.stream.xerces.util.XMLResourceIdentifierImpl;
import com.fr.third.javax.xml.stream.xerces.util.XMLStringBuffer;
import com.fr.third.javax.xml.stream.xerces.xni.XMLAttributes;
import com.fr.third.javax.xml.stream.xerces.xni.XMLResourceIdentifier;
import com.fr.third.javax.xml.stream.xerces.xni.XMLString;
import com.fr.third.javax.xml.stream.xerces.xni.XNIException;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponent;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLConfigurationException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class XMLScanner
implements XMLComponent {
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final boolean DEBUG_ATTR_NORMALIZATION = false;
    private boolean fNeedNonNormalizedValue = false;
    protected ArrayList attributeValueCache = new ArrayList();
    protected ArrayList stringBufferCache = new ArrayList();
    protected int fStringBufferIndex = 0;
    protected boolean fAttributeCacheInitDone = false;
    protected int fAttributeCacheUsedCount = 0;
    protected boolean fValidation = false;
    protected boolean fNotifyCharRefs = false;
    protected PropertyManager fPropertyManager = null;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityManager fEntityManager = null;
    protected XMLEntityStorage fEntityStore = null;
    protected XMLEvent fEvent;
    protected XMLEntityReaderImpl fEntityScanner = null;
    protected int fEntityDepth;
    protected String fCharRefLiteral = null;
    protected boolean fScanningAttribute;
    protected boolean fReportEntity;
    protected static final String fVersionSymbol = "version".intern();
    protected static final String fEncodingSymbol = "encoding".intern();
    protected static final String fStandaloneSymbol = "standalone".intern();
    protected static final String fAmpSymbol = "amp".intern();
    protected static final String fLtSymbol = "lt".intern();
    protected static final String fGtSymbol = "gt".intern();
    protected static final String fQuotSymbol = "quot".intern();
    protected static final String fAposSymbol = "apos".intern();
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer3 = new XMLStringBuffer();
    protected XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    int initialCacheCount = 6;

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)xMLComponentManager.getProperty(ENTITY_MANAGER);
        this.init();
        try {
            this.fValidation = xMLComponentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fNotifyCharRefs = xMLComponentManager.getFeature(NOTIFY_CHAR_REFS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNotifyCharRefs = false;
        }
    }

    protected void setPropertyManager(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            } else if (string2.equals("internal/entity-manager")) {
                this.fEntityManager = (XMLEntityManager)object;
            }
        }
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (VALIDATION.equals(string)) {
            this.fValidation = bl;
        } else if (NOTIFY_CHAR_REFS.equals(string)) {
            this.fNotifyCharRefs = bl;
        }
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        if (VALIDATION.equals(string)) {
            return this.fValidation;
        }
        if (NOTIFY_CHAR_REFS.equals(string)) {
            return this.fNotifyCharRefs;
        }
        throw new XMLConfigurationException(0, string);
    }

    public void reset(PropertyManager propertyManager) {
        this.init();
        this.fSymbolTable = (SymbolTable)propertyManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        this.fEntityManager = (XMLEntityManager)propertyManager.getProperty(ENTITY_MANAGER);
        this.fEntityStore = this.fEntityManager.getEntityStore();
        this.fEntityScanner = (XMLEntityReaderImpl)this.fEntityManager.getEntityReader();
        this.fValidation = false;
        this.fNotifyCharRefs = false;
    }

    protected void scanXMLDeclOrTextDecl(boolean bl, String[] stringArray) throws IOException, XNIException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = 2;
        int n3 = 3;
        int n4 = 0;
        boolean bl4 = false;
        boolean bl5 = this.fEntityScanner.skipSpaces();
        while (this.fEntityScanner.peekChar() != 63) {
            bl4 = true;
            String string4 = this.scanPseudoAttribute(bl, this.fString);
            switch (n4) {
                case 0: {
                    if (string4.equals(fVersionSymbol)) {
                        if (!bl5) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeVersionInTextDecl" : "SpaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        string = this.fString.toString();
                        n4 = 1;
                        if (this.versionSupported(string)) break;
                        this.reportFatalError("VersionNotSupported", new Object[]{string});
                        break;
                    }
                    if (string4.equals(fEncodingSymbol)) {
                        if (!bl) {
                            this.reportFatalError("VersionInfoRequired", null);
                        }
                        if (!bl5) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n4 = bl ? 3 : 2;
                        break;
                    }
                    if (bl) {
                        this.reportFatalError("EncodingDeclRequired", null);
                        break;
                    }
                    this.reportFatalError("VersionInfoRequired", null);
                    break;
                }
                case 1: {
                    if (string4.equals(fEncodingSymbol)) {
                        if (!bl5) {
                            this.reportFatalError(bl ? "SpaceRequiredBeforeEncodingInTextDecl" : "SpaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n4 = bl ? 3 : 2;
                        break;
                    }
                    if (!bl && string4.equals(fStandaloneSymbol)) {
                        if (!bl5) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string3 = this.fString.toString();
                        n4 = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                case 2: {
                    if (string4.equals(fStandaloneSymbol)) {
                        if (!bl5) {
                            this.reportFatalError("SpaceRequiredBeforeStandalone", null);
                        }
                        string3 = this.fString.toString();
                        n4 = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.reportFatalError("SDDeclInvalid", null);
                        break;
                    }
                    this.reportFatalError("EncodingDeclRequired", null);
                    break;
                }
                default: {
                    this.reportFatalError("NoMorePseudoAttributes", null);
                }
            }
            bl5 = this.fEntityScanner.skipSpaces();
        }
        if (bl && n4 != 3) {
            this.reportFatalError("MorePseudoAttributes", null);
        }
        if (bl) {
            if (!bl4 && string2 == null) {
                this.reportFatalError("EncodingDeclRequired", null);
            }
        } else if (!bl4 && string == null) {
            this.reportFatalError("VersionInfoRequired", null);
        }
        if (!this.fEntityScanner.skipChar(63)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("XMLDeclUnterminated", null);
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
    }

    public String scanPseudoAttribute(boolean bl, XMLString xMLString) throws IOException, XNIException {
        String string = this.fEntityScanner.scanName();
        if (string == null) {
            this.reportFatalError("PseudoAttrNameExpected", null);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError(bl ? "EqRequiredInTextDecl" : "EqRequiredInXMLDecl", new Object[]{string});
        }
        this.fEntityScanner.skipSpaces();
        int n2 = this.fEntityScanner.peekChar();
        if (n2 != 39 && n2 != 34) {
            this.reportFatalError(bl ? "QuoteRequiredInTextDecl" : "QuoteRequiredInXMLDecl", new Object[]{string});
        }
        this.fEntityScanner.scanChar();
        int n3 = this.fEntityScanner.scanLiteral(n2, xMLString);
        if (n3 != n2) {
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append(xMLString);
                if (n3 == -1) continue;
                if (n3 == 38 || n3 == 37 || n3 == 60 || n3 == 93) {
                    this.fStringBuffer2.append((char)this.fEntityScanner.scanChar());
                    continue;
                }
                if (XMLChar.isHighSurrogate(n3)) {
                    this.scanSurrogates(this.fStringBuffer2);
                    continue;
                }
                if (!XMLScanner.isInvalidLiteral(n3)) continue;
                String string2 = bl ? "InvalidCharInTextDecl" : "InvalidCharInXMLDecl";
                this.reportFatalError(string2, new Object[]{Integer.toString(n3, 16)});
                this.fEntityScanner.scanChar();
            } while ((n3 = this.fEntityScanner.scanLiteral(n2, xMLString)) != n2);
            this.fStringBuffer2.append(xMLString);
            xMLString.setValues(this.fStringBuffer2);
        }
        if (!this.fEntityScanner.skipChar(n2)) {
            this.reportFatalError(bl ? "CloseQuoteMissingInTextDecl" : "CloseQuoteMissingInXMLDecl", new Object[]{string});
        }
        return string;
    }

    protected void scanPI(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        this.fReportEntity = false;
        String string = this.fEntityScanner.scanName();
        if (string == null) {
            this.reportFatalError("PITargetRequired", null);
        }
        this.scanPIData(string, xMLStringBuffer);
        this.fReportEntity = true;
    }

    protected void scanPIData(String string, XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        int n2;
        if (string.length() == 3) {
            n2 = Character.toLowerCase(string.charAt(0));
            char c2 = Character.toLowerCase(string.charAt(1));
            char c3 = Character.toLowerCase(string.charAt(2));
            if (n2 == 120 && c2 == 'm' && c3 == 'l') {
                this.reportFatalError("ReservedPITarget", null);
            }
        }
        if (!this.fEntityScanner.skipSpaces()) {
            if (this.fEntityScanner.skipString("?>")) {
                return;
            }
            this.reportFatalError("SpaceRequiredInPI", null);
        }
        if (this.fEntityScanner.scanData("?>", xMLStringBuffer)) {
            do {
                if ((n2 = this.fEntityScanner.peekChar()) == -1) continue;
                if (XMLChar.isHighSurrogate(n2)) {
                    this.scanSurrogates(xMLStringBuffer);
                    continue;
                }
                if (!XMLScanner.isInvalidLiteral(n2)) continue;
                this.reportFatalError("InvalidCharInPI", new Object[]{Integer.toHexString(n2)});
                this.fEntityScanner.scanChar();
            } while (this.fEntityScanner.scanData("?>", xMLStringBuffer));
        }
    }

    protected void scanComment(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        xMLStringBuffer.clear();
        while (this.fEntityScanner.scanData("--", xMLStringBuffer)) {
            int n2 = this.fEntityScanner.peekChar();
            if (n2 == -1) continue;
            if (XMLChar.isHighSurrogate(n2)) {
                this.scanSurrogates(xMLStringBuffer);
            }
            if (!XMLScanner.isInvalidLiteral(n2)) continue;
            this.reportFatalError("InvalidCharInComment", new Object[]{Integer.toHexString(n2)});
            this.fEntityScanner.scanChar();
        }
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("DashDashInComment", null);
        }
    }

    protected void scanAttributeValue(XMLString xMLString, XMLString xMLString2, String string, XMLAttributes xMLAttributes, int n2, boolean bl) throws IOException, XNIException {
        int n3;
        XMLStringBuffer xMLStringBuffer = null;
        int n4 = this.fEntityScanner.peekChar();
        if (n4 != 39 && n4 != 34) {
            this.reportFatalError("OpenQuoteExpected", new Object[]{string});
        }
        this.fEntityScanner.scanChar();
        int n5 = this.fEntityDepth;
        int n6 = this.fEntityScanner.scanLiteral(n4, xMLString);
        if (this.fNeedNonNormalizedValue) {
            this.fStringBuffer2.clear();
            this.fStringBuffer2.append(xMLString);
        }
        if (this.fEntityScanner.whiteSpaceLen > 0) {
            this.normalizeWhitespace(xMLString);
        }
        if (n6 != n4) {
            this.fScanningAttribute = true;
            xMLStringBuffer = this.getStringBuffer();
            xMLStringBuffer.clear();
            do {
                xMLStringBuffer.append(xMLString);
                if (n6 == 38) {
                    this.fEntityScanner.skipChar(38);
                    if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                        this.fStringBuffer2.append('&');
                    }
                    if (this.fEntityScanner.skipChar(35)) {
                        int n7;
                        if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                            this.fStringBuffer2.append('#');
                        }
                        if ((n7 = this.fNeedNonNormalizedValue ? this.scanCharReferenceValue(xMLStringBuffer, this.fStringBuffer2) : this.scanCharReferenceValue(xMLStringBuffer, null)) == -1) {
                            // empty if block
                        }
                    } else {
                        String string2 = this.fEntityScanner.scanName();
                        if (string2 == null) {
                            this.reportFatalError("NameRequiredInReference", null);
                        } else if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                            this.fStringBuffer2.append(string2);
                        }
                        if (!this.fEntityScanner.skipChar(59)) {
                            this.reportFatalError("SemicolonRequiredInReference", new Object[]{string2});
                        } else if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                            this.fStringBuffer2.append(';');
                        }
                        if (string2 == fAmpSymbol) {
                            xMLStringBuffer.append('&');
                        } else if (string2 == fAposSymbol) {
                            xMLStringBuffer.append('\'');
                        } else if (string2 == fLtSymbol) {
                            xMLStringBuffer.append('<');
                        } else if (string2 == fGtSymbol) {
                            xMLStringBuffer.append('>');
                        } else if (string2 == fQuotSymbol) {
                            xMLStringBuffer.append('\"');
                        } else if (this.fEntityStore.isExternalEntity(string2)) {
                            this.reportFatalError("ReferenceToExternalEntity", new Object[]{string2});
                        } else {
                            if (!this.fEntityStore.isDeclaredEntity(string2)) {
                                if (bl) {
                                    if (this.fValidation) {
                                        this.fErrorReporter.reportError(this.fEntityScanner, "http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{string2}, (short)1);
                                    }
                                } else {
                                    this.reportFatalError("EntityNotDeclared", new Object[]{string2});
                                }
                            }
                            this.fEntityManager.startEntity(string2, true);
                        }
                    }
                } else if (n6 == 60) {
                    Object[] objectArray = new Object[2];
                    objectArray[1] = string;
                    this.reportFatalError("LessthanInAttValue", objectArray);
                    this.fEntityScanner.scanChar();
                    if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                        this.fStringBuffer2.append((char)n6);
                    }
                } else if (n6 == 37 || n6 == 93) {
                    this.fEntityScanner.scanChar();
                    xMLStringBuffer.append((char)n6);
                    if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                        this.fStringBuffer2.append((char)n6);
                    }
                } else if (n6 == 183) {
                    this.fEntityScanner.scanChar();
                    xMLStringBuffer.append('\u00b7');
                    if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                        this.fStringBuffer2.append('\n');
                    }
                } else if (n6 == 10 || n6 == 13) {
                    this.fEntityScanner.scanChar();
                    xMLStringBuffer.append(' ');
                    if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                        this.fStringBuffer2.append('\n');
                    }
                } else if (n6 != -1 && XMLChar.isHighSurrogate(n6)) {
                    if (this.scanSurrogates(this.fStringBuffer3)) {
                        xMLStringBuffer.append(this.fStringBuffer3);
                        if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                            this.fStringBuffer2.append(this.fStringBuffer3);
                        }
                    }
                } else if (n6 != -1 && XMLScanner.isInvalidLiteral(n6)) {
                    this.reportFatalError("InvalidCharInAttValue", new Object[]{Integer.toString(n6, 16)});
                    this.fEntityScanner.scanChar();
                    if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                        this.fStringBuffer2.append((char)n6);
                    }
                }
                n6 = this.fEntityScanner.scanLiteral(n4, xMLString);
                if (n5 == this.fEntityDepth && this.fNeedNonNormalizedValue) {
                    this.fStringBuffer2.append(xMLString);
                }
                if (this.fEntityScanner.whiteSpaceLen <= 0) continue;
                this.normalizeWhitespace(xMLString);
            } while (n6 != n4 || n5 != this.fEntityDepth);
            xMLStringBuffer.append(xMLString);
            xMLString.setValues(xMLStringBuffer);
            this.fScanningAttribute = false;
        }
        if (this.fNeedNonNormalizedValue) {
            xMLString2.setValues(this.fStringBuffer2);
        }
        if ((n3 = this.fEntityScanner.scanChar()) != n4) {
            this.reportFatalError("CloseQuoteExpected", new Object[]{string});
        }
    }

    protected void scanExternalID(String[] stringArray, boolean bl) throws IOException, XNIException {
        String string = null;
        String string2 = null;
        if (this.fEntityScanner.skipString("PUBLIC")) {
            if (!this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterPUBLIC", null);
            }
            this.scanPubidLiteral(this.fString);
            string2 = this.fString.toString();
            if (!this.fEntityScanner.skipSpaces() && !bl) {
                this.reportFatalError("SpaceRequiredBetweenPublicAndSystem", null);
            }
        }
        if (string2 != null || this.fEntityScanner.skipString("SYSTEM")) {
            int n2;
            if (string2 == null && !this.fEntityScanner.skipSpaces()) {
                this.reportFatalError("SpaceRequiredAfterSYSTEM", null);
            }
            if ((n2 = this.fEntityScanner.peekChar()) != 39 && n2 != 34) {
                if (string2 != null && bl) {
                    stringArray[0] = null;
                    stringArray[1] = string2;
                    return;
                }
                this.reportFatalError("QuoteRequiredInSystemID", null);
            }
            this.fEntityScanner.scanChar();
            XMLString xMLString = this.fString;
            if (this.fEntityScanner.scanLiteral(n2, xMLString) != n2) {
                this.fStringBuffer.clear();
                do {
                    this.fStringBuffer.append(xMLString);
                    int n3 = this.fEntityScanner.peekChar();
                    if (!XMLChar.isMarkup(n3) && n3 != 93) continue;
                    this.fStringBuffer.append((char)this.fEntityScanner.scanChar());
                } while (this.fEntityScanner.scanLiteral(n2, xMLString) != n2);
                this.fStringBuffer.append(xMLString);
                xMLString = this.fStringBuffer;
            }
            string = xMLString.toString();
            if (!this.fEntityScanner.skipChar(n2)) {
                this.reportFatalError("SystemIDUnterminated", null);
            }
        }
        stringArray[0] = string;
        stringArray[1] = string2;
    }

    protected boolean scanPubidLiteral(XMLString xMLString) throws IOException, XNIException {
        int n2 = this.fEntityScanner.scanChar();
        if (n2 != 39 && n2 != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            int n3;
            if ((n3 = this.fEntityScanner.scanChar()) == 32 || n3 == 10 || n3 == 13) {
                if (bl) continue;
                this.fStringBuffer.append(' ');
                bl = true;
                continue;
            }
            if (n3 == n2) {
                if (bl) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(n3)) {
                this.fStringBuffer.append((char)n3);
                bl = false;
                continue;
            }
            if (n3 == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            bl2 = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(n3)});
        }
        xMLString.setValues(this.fStringBuffer);
        return bl2;
    }

    protected void normalizeWhitespace(XMLString xMLString) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.fEntityScanner.whiteSpaceLookup;
        int n4 = this.fEntityScanner.whiteSpaceLen;
        int n5 = xMLString.offset + xMLString.length;
        while (n2 < n4) {
            n3 = nArray[n2];
            if (n3 < n5) {
                xMLString.ch[n3] = 32;
            }
            ++n2;
        }
    }

    public void startEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2) throws XNIException {
        ++this.fEntityDepth;
    }

    public void endEntity(String string) throws IOException, XNIException {
        --this.fEntityDepth;
    }

    protected int scanCharReferenceValue(XMLStringBuffer xMLStringBuffer, XMLStringBuffer xMLStringBuffer2) throws IOException, XNIException {
        int n2;
        int n3;
        boolean bl = false;
        if (this.fEntityScanner.skipChar(120)) {
            if (xMLStringBuffer2 != null) {
                xMLStringBuffer2.append('x');
            }
            bl = true;
            this.fStringBuffer3.clear();
            n3 = 1;
            n2 = this.fEntityScanner.peekChar();
            int n4 = n3 = !(n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102 || n2 >= 65 && n2 <= 70) ? 0 : 1;
            if (n3 != 0) {
                if (xMLStringBuffer2 != null) {
                    xMLStringBuffer2.append((char)n2);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n2);
                do {
                    int n5 = n3 = !((n2 = this.fEntityScanner.peekChar()) >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 102 || n2 >= 65 && n2 <= 70) ? 0 : 1;
                    if (n3 == 0) continue;
                    if (xMLStringBuffer2 != null) {
                        xMLStringBuffer2.append((char)n2);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)n2);
                } while (n3 != 0);
            } else {
                this.reportFatalError("HexdigitRequiredInCharRef", null);
            }
        } else {
            this.fStringBuffer3.clear();
            n3 = 1;
            n2 = this.fEntityScanner.peekChar();
            int n6 = n3 = n2 >= 48 && n2 <= 57 ? 1 : 0;
            if (n3 != 0) {
                if (xMLStringBuffer2 != null) {
                    xMLStringBuffer2.append((char)n2);
                }
                this.fEntityScanner.scanChar();
                this.fStringBuffer3.append((char)n2);
                do {
                    int n7 = n3 = (n2 = this.fEntityScanner.peekChar()) >= 48 && n2 <= 57 ? 1 : 0;
                    if (n3 == 0) continue;
                    if (xMLStringBuffer2 != null) {
                        xMLStringBuffer2.append((char)n2);
                    }
                    this.fEntityScanner.scanChar();
                    this.fStringBuffer3.append((char)n2);
                } while (n3 != 0);
            } else {
                this.reportFatalError("DigitRequiredInCharRef", null);
            }
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInCharRef", null);
        }
        if (xMLStringBuffer2 != null) {
            xMLStringBuffer2.append(';');
        }
        n3 = -1;
        try {
            n3 = Integer.parseInt(this.fStringBuffer3.toString(), bl ? 16 : 10);
            if (XMLScanner.isInvalid(n3)) {
                StringBuffer stringBuffer = new StringBuffer(this.fStringBuffer3.length + 1);
                if (bl) {
                    stringBuffer.append('x');
                }
                stringBuffer.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
                this.reportFatalError("InvalidCharRef", new Object[]{stringBuffer.toString()});
            }
        }
        catch (NumberFormatException numberFormatException) {
            StringBuffer stringBuffer = new StringBuffer(this.fStringBuffer3.length + 1);
            if (bl) {
                stringBuffer.append('x');
            }
            stringBuffer.append(this.fStringBuffer3.ch, this.fStringBuffer3.offset, this.fStringBuffer3.length);
            this.reportFatalError("InvalidCharRef", new Object[]{stringBuffer.toString()});
        }
        if (!XMLChar.isSupplemental(n3)) {
            xMLStringBuffer.append((char)n3);
        } else {
            xMLStringBuffer.append(XMLChar.highSurrogate(n3));
            xMLStringBuffer.append(XMLChar.lowSurrogate(n3));
        }
        if (this.fNotifyCharRefs && n3 != -1) {
            String string = "#" + (bl ? "x" : "") + this.fStringBuffer3.toString();
            if (!this.fScanningAttribute) {
                this.fCharRefLiteral = string;
            }
        }
        return n3;
    }

    protected static boolean isInvalid(int n2) {
        return XMLChar.isInvalid(n2);
    }

    protected static boolean isInvalidLiteral(int n2) {
        return XMLChar.isInvalid(n2);
    }

    protected static boolean isValidNameChar(int n2) {
        return XMLChar.isName(n2);
    }

    protected static boolean isValidNCName(int n2) {
        return XMLChar.isNCName(n2);
    }

    protected static boolean isValidNameStartChar(int n2) {
        return XMLChar.isNameStart(n2);
    }

    protected boolean versionSupported(String string) {
        return string.equals("1.0");
    }

    protected boolean scanSurrogates(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        int n2 = this.fEntityScanner.scanChar();
        int n3 = this.fEntityScanner.peekChar();
        if (!XMLChar.isLowSurrogate(n3)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n2, 16)});
            return false;
        }
        this.fEntityScanner.scanChar();
        int n4 = XMLChar.supplemental((char)n2, (char)n3);
        if (XMLScanner.isInvalid(n4)) {
            this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(n4, 16)});
            return false;
        }
        xMLStringBuffer.append((char)n2);
        xMLStringBuffer.append((char)n3);
        return true;
    }

    protected void reportFatalError(String string, Object[] objectArray) throws XNIException {
        this.fErrorReporter.reportError(this.fEntityScanner, "http://www.w3.org/TR/1998/REC-xml-19980210", string, objectArray, (short)2);
    }

    private void init() {
        this.fEntityDepth = 0;
        this.fReportEntity = true;
        this.fResourceIdentifier.clear();
    }

    XMLStringBuffer getStringBuffer() {
        if (this.fStringBufferIndex < this.initialCacheCount || this.fStringBufferIndex < this.stringBufferCache.size()) {
            return (XMLStringBuffer)this.stringBufferCache.get(this.fStringBufferIndex++);
        }
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
        this.stringBufferCache.add(this.fStringBufferIndex, xMLStringBuffer);
        return xMLStringBuffer;
    }
}

