/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoder;
import com.fr.third.JAI.JPEGDecodeParam;
import com.fr.third.JAI.JPEGEncodeParam;
import com.fr.third.JAI.JPEGImageDecoder;
import com.fr.third.JAI.JPEGImageEncoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JPEGCodec
extends ImageCodec {
    public String getFormatName() {
        return "jpeg";
    }

    public Class getEncodeParamClass() {
        return JPEGEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return JPEGDecodeParam.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        JPEGEncodeParam jPEGEncodeParam = null;
        if (imageEncodeParam != null) {
            jPEGEncodeParam = (JPEGEncodeParam)imageEncodeParam;
        }
        return new JPEGImageEncoder(outputStream, jPEGEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder(inputStream, imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new JPEGImageDecoder(new FileInputStream(file), imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new JPEGImageDecoder((InputStream)seekableStream, imageDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 3;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1;
    }
}

