/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.xml;

import com.fr.stable.Ascii85InputStream;
import com.fr.stable.Ascii85OutputStream;
import com.fr.stable.StableUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class XMLEncodeUtils {
    private static String[] deprecated_XmlImageDataArray = new String[]{"]]", "]]A"};
    private static String[] xmlImageDataArray = new String[]{"]", "]A"};

    private XMLEncodeUtils() {
    }

    public static byte[] zipDeflate(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9, true), 512);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            deflaterOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] zipInflate(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater(true), 512);
            byte[] byArray2 = new byte[512];
            while ((n2 = inflaterInputStream.read(byArray2, 0, byArray2.length)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] encodeAscii85(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Ascii85OutputStream ascii85OutputStream = new Ascii85OutputStream(byteArrayOutputStream);
            ascii85OutputStream.write(byArray, 0, byArray.length);
            ascii85OutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decodeAscii85(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n2;
            Ascii85InputStream ascii85InputStream = new Ascii85InputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[512];
            while ((n2 = ascii85InputStream.read(byArray2, 0, byArray2.length)) >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String encodeBytesAsString(byte[] byArray) {
        try {
            return new String(XMLEncodeUtils.encodeAscii85(XMLEncodeUtils.zipDeflate(byArray)), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static byte[] decodeStringAsBytes(String string) {
        try {
            return XMLEncodeUtils.zipInflate(XMLEncodeUtils.decodeAscii85(string.getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static String wrapCDATA(String string) {
        return "<![CDATA[" + XMLEncodeUtils.cdataEncode(string) + "]]>";
    }

    public static String cdataEncode(String string) {
        return StableUtils.replaceAllString(string, xmlImageDataArray[0], xmlImageDataArray[1]);
    }

    public static String cdataDecode(String string) {
        return StableUtils.replaceAllString(string, xmlImageDataArray[1], xmlImageDataArray[0]);
    }

    public static String deprecatedCDATADecode(String string) {
        return StableUtils.replaceAllString(string, deprecated_XmlImageDataArray[1], deprecated_XmlImageDataArray[0]);
    }
}

