/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.encoder;

import com.fr.stable.encoder.IntHashtableEntry;
import com.fr.stable.encoder.IntHashtableEnumerator;
import java.util.Dictionary;
import java.util.Enumeration;

public class IntHashtable
extends Dictionary
implements Cloneable {
    private IntHashtableEntry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public IntHashtable(int n2, float f2) {
        if (n2 <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f2;
        this.table = new IntHashtableEntry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    public IntHashtable(int n2) {
        this(n2, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new IntHashtableEnumerator(this.table, true);
    }

    public synchronized Enumeration elements() {
        return new IntHashtableEnumerator(this.table, false);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = intHashtableEntryArray.length;
        while (n2-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n2];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.value.equals(object)) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n3 && intHashtableEntry.key == n2) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return false;
    }

    public synchronized Object get(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n3 && intHashtableEntry.key == n2) {
                return intHashtableEntry.value;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return null;
    }

    public Object get(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n2 = (Integer)object;
        int n3 = n2;
        return this.get(n3);
    }

    protected void rehash() {
        int n2 = this.table.length;
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2 * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n3];
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = intHashtableEntryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.next;
                int n5 = (intHashtableEntry2.hash & Integer.MAX_VALUE) % n3;
                intHashtableEntry2.next = intHashtableEntryArray2[n5];
                intHashtableEntryArray2[n5] = intHashtableEntry2;
            }
        }
    }

    public synchronized Object put(int n2, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n3 && intHashtableEntry.key == n2) {
                Object object2 = intHashtableEntry.value;
                intHashtableEntry.value = object;
                return object2;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n2, object);
        }
        intHashtableEntry = new IntHashtableEntry();
        intHashtableEntry.hash = n3;
        intHashtableEntry.key = n2;
        intHashtableEntry.value = object;
        intHashtableEntry.next = intHashtableEntryArray[n4];
        intHashtableEntryArray[n4] = intHashtableEntry;
        ++this.count;
        return null;
    }

    public Object put(Object object, Object object2) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n2 = (Integer)object;
        int n3 = n2;
        return this.put(n3, object2);
    }

    public synchronized Object remove(int n2) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n3 = n2;
        int n4 = (n3 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n4];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n3 && intHashtableEntry.key == n2) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.next = intHashtableEntry.next;
                } else {
                    intHashtableEntryArray[n4] = intHashtableEntry.next;
                }
                --this.count;
                return intHashtableEntry.value;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.next;
        }
        return null;
    }

    public Object remove(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n2 = (Integer)object;
        int n3 = n2;
        return this.remove(n3);
    }

    public synchronized void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = intHashtableEntryArray.length;
        while (--n2 >= 0) {
            intHashtableEntryArray[n2] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.table = new IntHashtableEntry[this.table.length];
            int n2 = this.table.length;
            while (n2-- > 0) {
                intHashtable.table[n2] = this.table[n2] != null ? (IntHashtableEntry)this.table[n2].clone() : null;
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append('{');
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

