/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMap<V>
implements Iterable<Entry<V>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int n2) {
        this(n2, 0.8f);
    }

    public IntMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public IntMap(IntMap<? extends V> intMap) {
        this((int)Math.floor((float)intMap.capacity * intMap.loadFactor), intMap.loadFactor);
        this.stashSize = intMap.stashSize;
        System.arraycopy(intMap.keyTable, 0, this.keyTable, 0, intMap.keyTable.length);
        System.arraycopy(intMap.valueTable, 0, this.valueTable, 0, intMap.valueTable.length);
        this.size = intMap.size;
        this.zeroValue = intMap.zeroValue;
        this.hasZeroValue = intMap.hasZeroValue;
    }

    public V put(int n2, V v2) {
        int n3;
        if (n2 == 0) {
            V v3 = this.zeroValue;
            this.zeroValue = v2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v3;
        }
        int[] nArray = this.keyTable;
        int n4 = n2 & this.mask;
        int n5 = nArray[n4];
        if (n5 == n2) {
            V v4 = this.valueTable[n4];
            this.valueTable[n4] = v2;
            return v4;
        }
        int n6 = this.hash2(n2);
        int n7 = nArray[n6];
        if (n7 == n2) {
            V v5 = this.valueTable[n6];
            this.valueTable[n6] = v2;
            return v5;
        }
        int n8 = this.hash3(n2);
        int n9 = nArray[n8];
        if (n9 == n2) {
            V v6 = this.valueTable[n8];
            this.valueTable[n8] = v2;
            return v6;
        }
        int n10 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n10; ++n3) {
            if (nArray[n3] != n2) continue;
            V v7 = this.valueTable[n3];
            this.valueTable[n3] = v2;
            return v7;
        }
        if (n5 == 0) {
            nArray[n4] = n2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n7 == 0) {
            nArray[n6] = n2;
            this.valueTable[n6] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n9 == 0) {
            nArray[n8] = n2;
            this.valueTable[n8] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(n2, v2, n4, n5, n6, n7, n8, n9);
        return null;
    }

    public void putAll(IntMap<V> intMap) {
        for (Entry<V> entry : intMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(int n2, V v2) {
        if (n2 == 0) {
            this.zeroValue = v2;
            this.hasZeroValue = true;
            return;
        }
        int n3 = n2 & this.mask;
        int n4 = this.keyTable[n3];
        if (n4 == 0) {
            this.keyTable[n3] = n2;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n2);
        int n6 = this.keyTable[n5];
        if (n6 == 0) {
            this.keyTable[n5] = n2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n7 = this.hash3(n2);
        int n8 = this.keyTable[n7];
        if (n8 == 0) {
            this.keyTable[n7] = n2;
            this.valueTable[n7] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, v2, n3, n4, n5, n6, n7, n8);
    }

    private void push(int n2, V v2, int n3, int n4, int n5, int n6, int n7, int n8) {
        V v3;
        int n9;
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n10 = this.mask;
        int n11 = 0;
        int n12 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n9 = n4;
                    v3 = VArray[n3];
                    nArray[n3] = n2;
                    VArray[n3] = v2;
                    break;
                }
                case 1: {
                    n9 = n6;
                    v3 = VArray[n5];
                    nArray[n5] = n2;
                    VArray[n5] = v2;
                    break;
                }
                default: {
                    n9 = n8;
                    v3 = VArray[n7];
                    nArray[n7] = n2;
                    VArray[n7] = v2;
                }
            }
            n3 = n9 & n10;
            n4 = nArray[n3];
            if (n4 == 0) {
                nArray[n3] = n9;
                VArray[n3] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash2(n9);
            n6 = nArray[n5];
            if (n6 == 0) {
                nArray[n5] = n9;
                VArray[n5] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash3(n9);
            n8 = nArray[n7];
            if (n8 == 0) {
                nArray[n7] = n9;
                VArray[n7] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n11 == n12) break;
            n2 = n9;
            v2 = v3;
        }
        this.putStash(n9, v3);
    }

    private void putStash(int n2, V v2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n2, v2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = n2;
        this.valueTable[n3] = v2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(int n2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.getStash(n2, null);
        }
        return this.valueTable[n3];
    }

    public V get(int n2, V v2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return v2;
            }
            return this.zeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.getStash(n2, v2);
        }
        return this.valueTable[n3];
    }

    private V getStash(int n2, V v2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (nArray[n3] != n2) continue;
            return this.valueTable[n3];
        }
        return v2;
    }

    public V remove(int n2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            V v2 = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return v2;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] == n2) {
            this.keyTable[n3] = 0;
            V v3 = this.valueTable[n3];
            this.valueTable[n3] = null;
            --this.size;
            return v3;
        }
        n3 = this.hash2(n2);
        if (this.keyTable[n3] == n2) {
            this.keyTable[n3] = 0;
            V v4 = this.valueTable[n3];
            this.valueTable[n3] = null;
            --this.size;
            return v4;
        }
        n3 = this.hash3(n2);
        if (this.keyTable[n3] == n2) {
            this.keyTable[n3] = 0;
            V v5 = this.valueTable[n3];
            this.valueTable[n3] = null;
            --this.size;
            return v5;
        }
        return this.removeStash(n2);
    }

    V removeStash(int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (nArray[n3] != n2) continue;
            V v2 = this.valueTable[n3];
            this.removeStashIndex(n3);
            --this.size;
            return v2;
        }
        return null;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
            this.valueTable[n2] = this.valueTable[n3];
            this.valueTable[n3] = null;
        } else {
            this.valueTable[n2] = null;
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            nArray[n2] = 0;
            VArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            int[] nArray = this.keyTable;
            int n2 = this.capacity + this.stashSize;
            while (n2-- > 0) {
                if (nArray[n2] == 0 || VArray[n2] != null) continue;
                return true;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (VArray[n3] != object) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (!object.equals(VArray[n4])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int n2) {
        if (n2 == 0) {
            return this.hasZeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            return this.containsKeyStash(n2);
        }
        return true;
    }

    private boolean containsKeyStash(int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (nArray[n3] != n2) continue;
            return true;
        }
        return false;
    }

    public int findKey(Object object, boolean bl, int n2) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            int[] nArray = this.keyTable;
            int n3 = this.capacity + this.stashSize;
            while (n3-- > 0) {
                if (nArray[n3] == 0 || VArray[n3] != null) continue;
                return nArray[n3];
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0;
            }
            int n4 = this.capacity + this.stashSize;
            while (n4-- > 0) {
                if (VArray[n4] != object) continue;
                return this.keyTable[n4];
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0;
            }
            int n5 = this.capacity + this.stashSize;
            while (n5-- > 0) {
                if (!object.equals(VArray[n5])) continue;
                return this.keyTable[n5];
            }
        }
        return n2;
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new int[n2 + this.stashCapacity];
        this.valueTable = new Object[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[i2];
                if (n5 == 0) continue;
                this.putResize(n5, VArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.hasZeroValue && this.zeroValue != null) {
            n2 += this.zeroValue.hashCode();
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 == 0) continue;
            n2 += n4 * 31;
            V v2 = VArray[i2];
            if (v2 == null) continue;
            n2 += v2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        IntMap intMap = (IntMap)object;
        if (intMap.size != this.size) {
            return false;
        }
        if (intMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (intMap.zeroValue == null ? this.zeroValue != null : !intMap.zeroValue.equals(this.zeroValue))) {
            return false;
        }
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            int n3 = nArray[i2];
            if (n3 == 0 || !((v2 = VArray[i2]) == null ? !intMap.containsKey(n3) || intMap.get(n3) != null : !v2.equals(intMap.get(n3)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n3]);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n3]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values<V> values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntMap intMap) {
            super(intMap);
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n2 = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n2;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values<V>
    extends MapIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(IntMap<V> intMap) {
            super(intMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v2 = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return v2;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> entry = new Entry();

        public Entries(IntMap intMap) {
            super(intMap);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = nArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<V> {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntMap<V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(IntMap<V> intMap) {
            this.map = intMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.map.keyTable;
            int n2 = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n2) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.zeroValue = null;
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0;
                    this.map.valueTable[this.currentIndex] = null;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        public int key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

