/*
 * Decompiled with CFR 0.152.
 */
package com.fr.script;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.PageCalObj;
import com.fr.general.privilege.PrivilegeConstants;
import com.fr.parser.FRLexer;
import com.fr.parser.FRParser;
import com.fr.script.Variable;
import com.fr.stable.ColumnRow;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.plugin.PluginReadListener;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.CalculatorProviderContext;
import com.fr.stable.script.ColumnRowHunter;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.script.Expression;
import com.fr.stable.script.Function;
import com.fr.stable.script.NameSpace;
import com.fr.stable.script.Node;
import com.fr.stable.script.PropertiesMap;
import com.fr.stable.script.Tiny;
import com.fr.stable.script.TinyHunter;
import com.fr.third.antlr.ANTLRException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Calculator
implements CalculatorProvider,
Serializable,
Cloneable {
    public static final CalculatorKey SHEET_NUMBER_KEY = CalculatorKey.createKey("SHEET_NUM");
    private static ThreadLocal<Map<String, Object>> savedVariables = new ThreadLocal();
    private static ThreadLocal<NameSpace> savedSessionNameSpace = new ThreadLocal();
    private NameSpaceChain globalNameSpace = new NameSpaceChain();
    private Map<String, Expression> parsedExpression = new HashMap<String, Expression>();
    private PropertiesMap attributes = new PropertiesMap();
    private static NameSpace functionNameSpace = StableFactory.getMarkedObject("com.fr.stable.script.NameSpace", NameSpace.class);
    public static final CalculatorKey CONNECTIONS_KEY;
    private static CalculatorKey CURRENT_CR_INNER_KEY;

    private Calculator() {
    }

    public static Calculator createCalculator() {
        Calculator calculator = new Calculator();
        if (functionNameSpace == null) {
            functionNameSpace = StableFactory.getMarkedObject("com.fr.stable.script.NameSpace", NameSpace.class);
        }
        calculator.pushNameSpace(functionNameSpace);
        return calculator;
    }

    public static void putThreadSavedNameSpace(NameSpace nameSpace) {
        savedSessionNameSpace.set(nameSpace);
    }

    public static void setThreadSavedParameter(String string, Object object) {
        Map<String, Object> map = savedVariables.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            savedVariables.set(map);
        }
        map.put(string, object);
    }

    public static void clearThreadSavedParameter() {
        savedVariables.set(null);
    }

    public static Map<String, Object> getSavedVariables() {
        return savedVariables.get();
    }

    public static Object getSavedSessionNameSpace() {
        return savedSessionNameSpace.get();
    }

    public static ParameterProvider[] processParameters(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray) {
        if (parameterProviderArray == null) {
            return new ParameterProvider[0];
        }
        ParameterProvider[] parameterProviderArray2 = new ParameterProvider[parameterProviderArray.length];
        for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
            parameterProviderArray2[i2] = parameterProviderArray[i2];
            if (parameterProviderArray2[i2] == null || calculatorProvider == null) continue;
            Object object = Calculator.evalParaValue(calculatorProvider, parameterProviderArray2, i2);
            try {
                parameterProviderArray2[i2] = (ParameterProvider)parameterProviderArray2[i2].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            }
            if (object == null) continue;
            parameterProviderArray2[i2].setValue(object);
        }
        return parameterProviderArray2;
    }

    private static Object evalParaValue(CalculatorProvider calculatorProvider, ParameterProvider[] parameterProviderArray, int n2) {
        Object object = calculatorProvider.resolveVariable(parameterProviderArray[n2].getName());
        if (object == null || object == Primitive.NULL) {
            Object object2 = parameterProviderArray[n2].getValue();
            if (object2 instanceof FormulaProvider) {
                try {
                    object = calculatorProvider.eval((FormulaProvider)object2);
                }
                catch (UtilEvalError utilEvalError) {
                    FRLogger.getLogger().error(utilEvalError.getMessage());
                }
            } else {
                object = calculatorProvider.resolveVariable(object2);
            }
        }
        return object;
    }

    @Override
    public void setAttribute(CalculatorKey calculatorKey, Object object) {
        if (object == null) {
            this.attributes.remove(calculatorKey);
        } else {
            this.attributes.put(calculatorKey, object);
        }
    }

    @Override
    public void setAttribute(Class clazz, Object object) {
        CalculatorKey calculatorKey = Calculator.getCalculatorKey(clazz);
        if (calculatorKey != null) {
            this.setAttribute(calculatorKey, object);
        }
    }

    private static CalculatorKey getCalculatorKey(Class clazz) {
        CalculatorKey calculatorKey = null;
        if (clazz != null) {
            if (clazz == ColumnRow.class) {
                calculatorKey = ColumnRow.CURRENT_CR_KEY;
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.report.report.Report")) {
                calculatorKey = Calculator.getInnerKey("com.fr.report.report.Report", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.data.TableDataSource")) {
                calculatorKey = Calculator.getInnerKey("com.fr.data.TableDataSource", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.js.SessionIDInfor")) {
                calculatorKey = Calculator.getInnerKey("com.fr.web.core.SessionIDInfor", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.parser.BlockIntervalLiteral")) {
                calculatorKey = Calculator.getInnerKey("com.fr.parser.BlockIntervalLiteral", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.data.Verifier")) {
                calculatorKey = Calculator.getInnerKey("com.fr.data.Verifier", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.data.impl.RowsDataModel")) {
                calculatorKey = Calculator.getInnerKey("com.fr.data.impl.RowsDataModel", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.write.DMLReport")) {
                calculatorKey = Calculator.getInnerKey("com.fr.write.DMLReport", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.write.config.DMLConfig")) {
                calculatorKey = Calculator.getInnerKey("com.fr.write.config.DMLConfig", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.stable.fun.DataSourcePoolProcessor")) {
                calculatorKey = Calculator.getInnerKey("com.fr.stable.fun.DataSourcePoolProcessor", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.report.core.cal.layer.LayerSheetExecutor.LayerFamilyMember")) {
                calculatorKey = Calculator.getInnerKey("com.fr.report.core.cal.layer.LayerSheetExecutor.LayerFamilyMember", "KEY");
            } else if (ComparatorUtils.equals(clazz.getName(), "com.fr.report.elementcase.ElementCase")) {
                calculatorKey = Calculator.getInnerKey("com.fr.report.elementcase.ElementCase", "KEY");
            }
        }
        if (calculatorKey == null) {
            throw new UnsupportedOperationException("Unsupported Compatible Class:" + clazz == null ? "" : clazz.getName() + " Please Use com.fr.stable.script.CalculatorKey Instead");
        }
        return calculatorKey;
    }

    private static CalculatorKey getInnerKey(String string, String string2) {
        CalculatorKey calculatorKey = null;
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            field.setAccessible(true);
            calculatorKey = (CalculatorKey)field.get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRLogger.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            FRLogger.getLogger().error(noSuchFieldException.getMessage(), noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            FRLogger.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
        }
        return calculatorKey;
    }

    @Override
    public Object getAttribute(Class clazz) {
        CalculatorKey calculatorKey = Calculator.getCalculatorKey(clazz);
        if (calculatorKey != null) {
            return this.getAttribute(calculatorKey);
        }
        return null;
    }

    @Override
    public Object getAttribute(CalculatorKey calculatorKey) {
        return this.attributes.get(calculatorKey);
    }

    @Override
    public void removeAttribute(CalculatorKey calculatorKey) {
        this.attributes.remove(calculatorKey);
    }

    @Override
    public void set(String string, Object object) {
        this.globalNameSpace.set(string, object);
    }

    @Override
    public void remove(String string) {
        this.globalNameSpace.remove(string);
    }

    @Override
    public void pushNameSpace(NameSpace nameSpace) {
        this.globalNameSpace.namespaceList.addFirst(nameSpace);
    }

    @Override
    public boolean removeNameSpace(NameSpace nameSpace) {
        return this.globalNameSpace.namespaceList.remove(nameSpace);
    }

    @Override
    public Object resolveVariable(Object object) {
        Object object2 = this.resolveVariableInCE(object);
        if (object2 == null) {
            return null;
        }
        return CalculatorProviderContext.getValueConverter().result2Value(object2);
    }

    @Override
    public Object resolveVariableInCE(Object object) {
        return this.globalNameSpace.getVariable(object, this);
    }

    @Override
    public Function resolveMethod(Object object) {
        return this.globalNameSpace.getMethod(object, this);
    }

    @Override
    public void setCurrentFromColumnRow(ColumnRow columnRow) {
        this.setAttribute(ColumnRow.CURRENT_CR_KEY, (Object)columnRow);
    }

    @Override
    public ColumnRow getCurrentFromColumnRow() {
        return (ColumnRow)this.getAttribute(ColumnRow.CURRENT_CR_KEY);
    }

    @Override
    public Object resolveRelateCellElements(ColumnRow columnRow) {
        return this.globalNameSpace.getRelateCellElements(columnRow, this);
    }

    @Override
    public Expression parse(Object object) throws ANTLRException {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        return this.parse(GeneralUtils.objectToString(object));
    }

    @Override
    public Expression parse(String string) throws ANTLRException {
        Expression expression;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).startsWith("=")) {
            string = string.substring(1);
        }
        if ((expression = this.parsedExpression.get(string)) == null) {
            StringReader stringReader = new StringReader(string);
            FRLexer fRLexer = new FRLexer(stringReader);
            FRParser fRParser = new FRParser(fRLexer);
            if (StringUtils.isNotEmpty(string)) {
                expression = fRParser.parse();
            }
            if (expression != null) {
                this.parsedExpression.put(string, expression);
            }
        }
        return expression;
    }

    @Override
    public Object evalValue(String string) throws UtilEvalError {
        Object object = this.eval(string);
        if (object == null) {
            return null;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        return object;
    }

    @Override
    public Object evalValue(FormulaProvider formulaProvider) throws UtilEvalError {
        Object object = this.eval(formulaProvider);
        if (object == null) {
            return null;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        return object;
    }

    @Override
    public Object evalValue(Node node) throws UtilEvalError {
        Object object = this.eval(node);
        if (object == null) {
            return null;
        }
        object = CalculatorProviderContext.getValueConverter().result2Value(object);
        return object;
    }

    @Override
    public Object eval(String string) throws UtilEvalError {
        Object object;
        try {
            object = this.evalString(string);
        }
        catch (UtilEvalError utilEvalError) {
            utilEvalError.addFormulaContent(string.toString());
            throw utilEvalError;
        }
        return object;
    }

    public Object evalAuth() {
        NameSpace nameSpace = (NameSpace)Calculator.getSavedSessionNameSpace();
        if (nameSpace != null) {
            return nameSpace.getVariable((Object)PrivilegeConstants.ROLE.CUR_ROLE, this);
        }
        return null;
    }

    @Override
    public Object eval(FormulaProvider formulaProvider) throws UtilEvalError {
        Object object;
        try {
            object = this.evalString(formulaProvider.getContent());
        }
        catch (UtilEvalError utilEvalError) {
            utilEvalError.addFormulaContent(formulaProvider.toString());
            throw utilEvalError;
        }
        return object;
    }

    @Override
    public Object eval(Node node) throws UtilEvalError {
        Object object;
        try {
            object = node.eval(this);
        }
        catch (UtilEvalError utilEvalError) {
            utilEvalError.addFormulaContent(node.toString());
            throw utilEvalError;
        }
        return object;
    }

    private Object evalString(String string) throws UtilEvalError {
        Expression expression = null;
        if (string != null) {
            try {
                expression = this.parse(string);
            }
            catch (ANTLRException aNTLRException) {
                if (string.indexOf(" ") != -1) {
                    string = string.replaceAll(" ", "");
                    try {
                        expression = this.parse(string);
                    }
                    catch (ANTLRException aNTLRException2) {
                        // empty catch block
                    }
                    return expression == null ? Primitive.NULL : expression.eval(this);
                }
                if (this.getCurrentFromColumnRow() != null) {
                    StringBuffer stringBuffer = new StringBuffer().append(Inter.getLocText("FR-Base-Error_Cell")).append(":").append(this.getCurrentFromColumnRow()).append(Inter.getLocText("FR-Base-Error_Statement_Is")).append("\"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                    FRLogger.getLogger().error(stringBuffer.toString(), aNTLRException);
                }
                FRLogger.getLogger().error(Inter.getLocText("FR-Base-Error_Statement_Is") + "\"" + string + "\"", aNTLRException);
            }
        }
        if (expression == null) {
            return null;
        }
        if (expression.delay4PageCal()) {
            return PageCalObj.MARK;
        }
        return expression.eval(this);
    }

    public static ColumnRowRange[] relatedColumnRowRangeArray(String string) throws ANTLRException {
        Expression expression = new Calculator().parse(string);
        if (expression == null) {
            return new ColumnRowRange[0];
        }
        ColumnRowHunter columnRowHunter = new ColumnRowHunter();
        expression.traversal4Tiny(columnRowHunter);
        return columnRowHunter.getColumnRowRangeBooty();
    }

    public static String[] relatedParameters(String string) throws ANTLRException {
        Expression expression = new Calculator().parse(string);
        if (expression == null) {
            return new String[0];
        }
        ParameterHunter parameterHunter = new ParameterHunter();
        expression.traversal4Tiny(parameterHunter);
        return parameterHunter.getParameterBooty();
    }

    public void putConnection(String string, Connection connection) {
        HashMap<String, Connection> hashMap = (HashMap<String, Connection>)this.getAttribute(CONNECTIONS_KEY);
        if (hashMap == null) {
            hashMap = new HashMap<String, Connection>();
            this.setAttribute(CONNECTIONS_KEY, hashMap);
        }
        hashMap.put(string, connection);
    }

    public Connection getConnection(String string) {
        Map map = (Map)this.getAttribute(CONNECTIONS_KEY);
        if (map == null) {
            return null;
        }
        return (Connection)map.get(string);
    }

    public void removeConnection(String string) {
        Map map = (Map)this.getAttribute(CONNECTIONS_KEY);
        if (map == null) {
            return;
        }
        map.remove(string);
    }

    @Override
    public String exStatement(ColumnRow columnRow, String string) {
        this.setCurrentFromColumnRow(columnRow);
        Expression expression = null;
        try {
            expression = this.parse(string);
        }
        catch (ANTLRException aNTLRException) {
            if (this.getCurrentFromColumnRow() != null) {
                StringBuffer stringBuffer = new StringBuffer().append("Error Cell: ").append(this.getCurrentFromColumnRow()).append(" and statement is \"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                FRLogger.getLogger().error(stringBuffer.toString(), aNTLRException);
            }
            FRLogger.getLogger().error("error statement is \"" + string + "\"", aNTLRException);
        }
        return expression == null ? string : expression.exString(this);
    }

    @Override
    public ColumnRow getCurrentColumnRow() {
        return (ColumnRow)this.getAttribute(CURRENT_CR_INNER_KEY);
    }

    @Override
    public void setCurrentColumnRow(ColumnRow columnRow) {
        this.setAttribute(CURRENT_CR_INNER_KEY, (Object)columnRow);
    }

    public String onAddDeleteColumnOrRow(String string, int n2, int n3, int n4, int n5) {
        Expression expression = null;
        try {
            expression = this.parse(string);
        }
        catch (ANTLRException aNTLRException) {
            if (this.getCurrentFromColumnRow() != null) {
                StringBuffer stringBuffer = new StringBuffer().append("Error Cell: ").append(this.getCurrentFromColumnRow()).append(" and statement is \"").append(string).append('\"').append('\n').append(aNTLRException.getMessage());
                FRLogger.getLogger().error(stringBuffer.toString(), aNTLRException);
            }
            FRLogger.getLogger().error("error statement is \"" + string + "\"", aNTLRException);
        }
        return expression == null ? string : expression.getExpression(n2, n3, n4, n5, true);
    }

    public LinkedList getNameSpaceList() {
        return this.globalNameSpace.namespaceList;
    }

    static {
        GeneralContext.addPluginReadListener(new PluginReadListener(){

            public void success(PluginReadListener.Status status) {
                functionNameSpace = StableFactory.getMarkedObject("com.fr.stable.script.NameSpace", NameSpace.class);
            }
        });
        CONNECTIONS_KEY = CalculatorKey.createKey("CONNECTIONS_KEY");
        CURRENT_CR_INNER_KEY = CalculatorKey.createKey("CURRENT_CR_INNER_KEY");
    }

    protected static class NameSpaceChain
    implements NameSpace {
        private Map variables = new HashMap();
        private LinkedList namespaceList = new LinkedList();

        protected NameSpaceChain() {
        }

        public Function getMethod(Object object, CalculatorProvider calculatorProvider) {
            Function function = null;
            int n2 = this.namespaceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                function = ((NameSpace)this.namespaceList.get(i2)).getMethod(object, calculatorProvider);
                if (function == null) continue;
                return function;
            }
            return null;
        }

        public void remove(String string) {
            this.variables.remove(string);
        }

        public Object getRelateCellElements(ColumnRow columnRow, CalculatorProvider calculatorProvider) {
            Object object = null;
            int n2 = this.namespaceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = ((NameSpace)this.namespaceList.get(i2)).getRelateCellElements(columnRow, calculatorProvider);
                if (object == null) continue;
                return object;
            }
            return object;
        }

        public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
            if (object == null) {
                return null;
            }
            Object object2 = null;
            if (!this.variables.isEmpty() && (object2 = this.unwrapVariable((Variable)this.variables.get(object.toString().toUpperCase()))) != null) {
                return object2;
            }
            int n2 = this.namespaceList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                NameSpace nameSpace = (NameSpace)this.namespaceList.get(i2);
                if (nameSpace == null || (object2 = nameSpace.getVariable(object, calculatorProvider)) == null) continue;
                return object2;
            }
            return null;
        }

        private Object unwrapVariable(Variable variable) {
            return variable == null ? null : variable.getValue();
        }

        private void set(Object object, Object object2) {
            Variable variable;
            if (object == null) {
                return;
            }
            object = object.toString().toUpperCase();
            if (object2 == null) {
                object2 = Primitive.NULL;
            }
            if ((variable = (Variable)this.variables.get(object)) != null) {
                variable.setValue(object2);
            } else {
                this.variables.put(object, new Variable(object2));
            }
        }
    }

    private static class ParameterHunter
    extends TinyHunter {
        private List parameterList = new ArrayList();

        private ParameterHunter() {
        }

        public String[] getParameterBooty() {
            return this.parameterList.toArray(new String[this.parameterList.size()]);
        }

        public void hunter4Tiny(Tiny tiny) {
            String string = tiny.getStatement();
            if (StringUtils.isNotBlank(string) && string.startsWith("$") && !this.parameterList.contains(string)) {
                this.parameterList.add(string);
            }
        }
    }
}

