/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.poly;

import com.fr.general.ComparatorUtils;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.core.block.BlockSequenceExecutor;
import com.fr.report.core.sheet.SheetExecutor;
import com.fr.report.elementcase.AbstractElementCase;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.report.poly.BlockShiftAction;
import com.fr.report.poly.PolyWorkSheet;
import com.fr.report.poly.ResultECBlock;
import com.fr.report.poly.TemplateBlock;
import com.fr.report.report.TemplateReport;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.stable.StringUtils;
import com.fr.stable.core.PropertyChangeAdapter;
import com.fr.stable.core.PropertyChangeListener;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UNITConstants;
import com.fr.stable.unit.UnitRectangle;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractPolyECBlock
extends AbstractElementCase
implements TemplateBlock,
TemplateElementCase {
    private String blockName;
    private UnitRectangle bounds;
    private PolyBlockAttr blockAttr;
    private List createListeners = new ArrayList();
    private PolyWorkSheet worksheet;

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String string) {
        this.blockName = string;
    }

    public boolean isCells() {
        return true;
    }

    public PolyBlockAttr getBlockAttr() {
        if (this.blockAttr == null) {
            this.blockAttr = new PolyBlockAttr();
        }
        return this.blockAttr;
    }

    public void setBlockAttr(PolyBlockAttr polyBlockAttr) {
        this.blockAttr = polyBlockAttr;
    }

    public void setRowHeight(int n2, UNIT uNIT) {
        FU fU = this.getRowHeight(n2);
        super.setRowHeight(n2, uNIT);
        FU fU2 = uNIT.subtract(fU);
        UnitRectangle unitRectangle = this.getBounds();
        unitRectangle.height = unitRectangle.height.add(fU2);
        this.setBounds(unitRectangle);
        this.reCalculateBlockSize();
    }

    public void setColumnWidth(int n2, UNIT uNIT) {
        FU fU = this.getColumnWidth(n2);
        super.setColumnWidth(n2, uNIT);
        FU fU2 = uNIT.subtract(fU);
        UnitRectangle unitRectangle = this.getBounds();
        unitRectangle.width = unitRectangle.width.add(fU2);
        this.setBounds(unitRectangle);
        this.reCalculateBlockSize();
    }

    public PolyWorkSheet getWorksheet() {
        return this.worksheet;
    }

    public void setWorksheet(PolyWorkSheet polyWorkSheet) {
        this.worksheet = polyWorkSheet;
    }

    public void insertRow(int n2) {
        super.insertRow(n2);
        UnitRectangle unitRectangle = this.getBounds();
        unitRectangle.height = unitRectangle.height.add(UNITConstants.DEFAULT_ROW_HEIGHT);
        this.setBounds(unitRectangle);
    }

    public void removeRow(int n2) {
        FU fU = this.getRowHeight(n2);
        super.removeRow(n2);
        UnitRectangle unitRectangle = this.getBounds();
        unitRectangle.height = unitRectangle.height.subtract(fU);
        this.setBounds(unitRectangle);
    }

    public void insertColumn(int n2) {
        super.insertColumn(n2);
        UnitRectangle unitRectangle = this.getBounds();
        unitRectangle.width = unitRectangle.width.add(UNITConstants.DEFAULT_COL_WIDTH);
        this.setBounds(unitRectangle);
    }

    public void removeColumn(int n2) {
        FU fU = this.getColumnWidth(n2);
        super.removeColumn(n2);
        UnitRectangle unitRectangle = this.getBounds();
        unitRectangle.width = unitRectangle.width.subtract(fU);
        this.setBounds(unitRectangle);
    }

    public UnitRectangle getBounds() {
        return this.bounds == null ? null : new UnitRectangle(this.bounds);
    }

    public void setBounds(UnitRectangle unitRectangle) {
        this.setBounds(unitRectangle, this.worksheet);
    }

    public void setBounds(UnitRectangle unitRectangle, PolyWorkSheet polyWorkSheet) {
        boolean bl = this.isHideBlock(unitRectangle);
        if (!bl) {
            this.makeSureMoreThanZero(unitRectangle);
            this.makeSureBiggerThanReport(unitRectangle);
        }
        new BlockShiftAction().shift(unitRectangle, polyWorkSheet, this.bounds);
        this.bounds = unitRectangle;
        this.firePropertyChange();
    }

    private void makeSureBiggerThanReport(UnitRectangle unitRectangle) {
        UNIT uNIT;
        UNIT uNIT2 = ReportHelper.getTotalColumnWidth(this);
        if (unitRectangle.width.subtract(uNIT2).less_than_zero()) {
            unitRectangle.width = uNIT2;
        }
        if (unitRectangle.height.subtract(uNIT = ReportHelper.getTotalRowHeight(this)).less_than_zero()) {
            unitRectangle.height = uNIT;
        }
    }

    private void makeSureMoreThanZero(UnitRectangle unitRectangle) {
        if (unitRectangle.x.less_than_zero()) {
            unitRectangle.x = UNIT.ZERO;
        }
        if (unitRectangle.y.less_than_zero()) {
            unitRectangle.y = UNIT.ZERO;
        }
    }

    private boolean isHideBlock(UnitRectangle unitRectangle) {
        return unitRectangle.width.equal_zero() && unitRectangle.height.equal_zero();
    }

    public void reCalculateBlockSize() {
        FU fU = UNIT.ZERO;
        int n2 = 0;
        while (true) {
            FU fU2 = this.getRowHeight(n2);
            if (this.bounds.height.toFU() - fU.toFU() < fU2.toFU() / 2L) break;
            fU = fU.add(fU2);
            ++n2;
        }
        FU fU3 = UNIT.ZERO;
        int n3 = 0;
        while (true) {
            FU fU4 = this.getColumnWidth(n3);
            if (this.bounds.width.toFU() - fU3.toFU() < fU4.toFU() / 2L) break;
            fU3 = fU3.add(fU4);
            ++n3;
        }
        this.setBounds(new UnitRectangle(this.bounds.x, this.bounds.y, fU3, fU));
    }

    private AbstractPolyECBlock getAbstractPolyECBlock2Show() throws CloneNotSupportedException {
        FU fU;
        AbstractPolyECBlock abstractPolyECBlock = (AbstractPolyECBlock)this.clone();
        FU fU2 = UNIT.ZERO;
        int n2 = 0;
        if (abstractPolyECBlock.bounds != null) {
            fU = this.getColumnWidth(n2);
            while (abstractPolyECBlock.bounds.width.toFU() - fU2.toFU() >= fU.toFU() / 2L) {
                fU2 = fU2.add(fU);
                fU = this.getColumnWidth(++n2);
            }
        }
        while (n2 < abstractPolyECBlock.getColumnCount()) {
            abstractPolyECBlock.setColumnWidth(n2, UNIT.ZERO);
            ++n2;
        }
        fU = UNIT.ZERO;
        int n3 = 0;
        if (this.bounds != null) {
            FU fU3 = this.getRowHeight(n2);
            while (this.bounds.height.toFU() - fU.toFU() >= fU3.toFU() / 2L) {
                fU = fU.add(fU3);
                fU3 = this.getRowHeight(++n3);
            }
        }
        while (n3 < abstractPolyECBlock.getColumnCount()) {
            abstractPolyECBlock.setRowHeight(n2, UNIT.ZERO);
            ++n3;
        }
        return abstractPolyECBlock;
    }

    public SheetExecutor createExecutor(TemplateReport templateReport, Map map, BlockSequenceExecutor blockSequenceExecutor) {
        AbstractPolyECBlock abstractPolyECBlock;
        try {
            abstractPolyECBlock = this.getAbstractPolyECBlock2Show();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        return this.createSheetExecutor(templateReport, abstractPolyECBlock, map, blockSequenceExecutor);
    }

    protected abstract SheetExecutor createSheetExecutor(TemplateReport var1, AbstractPolyECBlock var2, Map var3, BlockSequenceExecutor var4);

    public void addCellElement(TemplateCellElement templateCellElement) {
        super.addCellElement(templateCellElement);
    }

    public void addCellElement(TemplateCellElement templateCellElement, boolean bl) {
        super.addCellElement(templateCellElement, bl);
    }

    public boolean removeCellElement(TemplateCellElement templateCellElement) {
        return super.removeCellElement(templateCellElement);
    }

    public TemplateCellElement getTemplateCellElement(int n2, int n3) {
        return (TemplateCellElement)super.getCellElement(n2, n3);
    }

    public TemplateCellElement removeTemplateCellElement(int n2, int n3) {
        return (TemplateCellElement)super.removeCellElement(n2, n3);
    }

    protected CellElement createDefaultCellElementCase() {
        return new DefaultTemplateCellElement();
    }

    public void firePropertyChange() {
        for (int i2 = this.createListeners.size() - 1; i2 >= 0; --i2) {
            ((PropertyChangeAdapter)this.createListeners.get(i2)).propertyChange();
        }
    }

    public void addPropertyListener(PropertyChangeListener propertyChangeListener) {
        int n2 = this.createListeners.indexOf(propertyChangeListener);
        if (n2 == -1) {
            this.createListeners.add(propertyChangeListener);
        } else {
            this.createListeners.set(n2, propertyChangeListener);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("PECBAttr".equals(string)) {
                this.setBlockName(xMLableReader.getAttrAsString("blockName", ""));
                this.setBounds(new UnitRectangle(FU.getInstance(xMLableReader.getAttrAsLong("x", 0L)), FU.getInstance(xMLableReader.getAttrAsLong("y", 0L)), FU.getInstance(xMLableReader.getAttrAsLong("width", 0L)), FU.getInstance(xMLableReader.getAttrAsLong("height", 0L))));
            } else if ("PolyBlockAttr".equals(string)) {
                this.setBlockAttr(ReportXMLUtils.readXMLPolyBlockAttr(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("PECBAttr");
        if (StringUtils.isNotEmpty(this.blockName)) {
            xMLPrintWriter.attr("blockName", this.blockName);
        }
        if (this.bounds != null) {
            xMLPrintWriter.attr("x", this.bounds.x.toFU()).attr("y", this.bounds.y.toFU()).attr("width", this.bounds.width.toFU()).attr("height", this.bounds.height.toFU());
        }
        xMLPrintWriter.end();
        ReportXMLUtils.writeXMLPloyBlockAttr(xMLPrintWriter, this.blockAttr);
    }

    public void cloneWithoutCellCase(ResultECBlock resultECBlock) throws CloneNotSupportedException {
        if (resultECBlock == null) {
            return;
        }
        super.cloneWithoutCellCase(resultECBlock);
        resultECBlock.blockName = this.blockName;
        resultECBlock.bounds = (UnitRectangle)this.bounds.clone();
        if (this.blockAttr != null) {
            resultECBlock.blockAttr = (PolyBlockAttr)this.blockAttr.clone();
        }
    }

    public void copyTo(AbstractPolyECBlock abstractPolyECBlock) {
        if (abstractPolyECBlock == null) {
            return;
        }
        abstractPolyECBlock.blockName = this.blockName;
        abstractPolyECBlock.blockAttr = this.blockAttr;
        abstractPolyECBlock.bounds = this.bounds;
        abstractPolyECBlock.cellcase = this.cellcase;
        abstractPolyECBlock.setRowHeightList_DEC(this.getRowHeightList_DEC());
        abstractPolyECBlock.setColumnWidthList_DEC(this.getColumnWidthList_DEC());
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractPolyECBlock abstractPolyECBlock = (AbstractPolyECBlock)super.clone();
        abstractPolyECBlock.createListeners = new ArrayList();
        if (this.bounds != null) {
            abstractPolyECBlock.bounds = (UnitRectangle)this.bounds.clone();
        }
        if (StringUtils.isNotEmpty(this.blockName)) {
            abstractPolyECBlock.blockName = this.blockName;
        }
        if (this.blockAttr != null) {
            abstractPolyECBlock.blockAttr = (PolyBlockAttr)this.blockAttr.clone();
        }
        return abstractPolyECBlock;
    }

    public boolean equals(Object object) {
        return super.equals(object) && object instanceof AbstractPolyECBlock && ComparatorUtils.equals(this.blockAttr, ((AbstractPolyECBlock)object).blockAttr) && ComparatorUtils.equals(this.blockName, ((AbstractPolyECBlock)object).blockName) && ComparatorUtils.equals(this.bounds, ((AbstractPolyECBlock)object).bounds) && ComparatorUtils.equals(this.createListeners.iterator(), ((AbstractPolyECBlock)object).createListeners.iterator());
    }
}

