/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.line.code39;

import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.CompositeModule;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.SeparatorModule;
import com.fr.report.cell.painter.barcode.line.code39.ModuleFactory;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.output.GraphicsOutput;
import java.awt.Dimension;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class Code39Barcode
extends BarcodeImpl {
    public static final String[] TYPES = new String[]{"Code39", "USD3", "3of9"};
    private boolean requiresChecksum = false;
    private String label;
    private int width = 0;

    public Code39Barcode(String string, boolean bl) throws BarcodeException {
        this(string, bl, false);
    }

    public Code39Barcode(String string, boolean bl, boolean bl2) throws BarcodeException {
        super(bl2 ? Code39Barcode.encodeExtendedChars(string) : Code39Barcode.validateBasicChars(string));
        this.requiresChecksum = bl;
        this.label = string;
    }

    protected String getLabel() {
        return "*" + this.label + "*";
    }

    protected double getBarcodeWidth(int n2) {
        this.encodeData();
        if (this.requiresChecksum) {
            this.width += 1 + this.calculateChecksum().widthInBars();
        }
        return this.barWidth * (double)this.width;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int i2 = 0; i2 < this.data.length(); ++i2) {
            char c2 = this.data.charAt(i2);
            arrayList.add(new SeparatorModule(1));
            ++this.width;
            Module module = ModuleFactory.getModule(String.valueOf(c2));
            arrayList.add(module);
            this.width += module.widthInBars();
        }
        arrayList.add(new SeparatorModule(1));
        ++this.width;
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        if (this.requiresChecksum) {
            int n2 = Code39Barcode.calculateMod43(this.data);
            CompositeModule compositeModule = new CompositeModule();
            compositeModule.add(ModuleFactory.getModuleForIndex(n2));
            compositeModule.add(new SeparatorModule(1));
            return compositeModule;
        }
        return null;
    }

    public static int calculateMod43(String string) {
        int n2 = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        int n3 = stringCharacterIterator.first();
        while (n3 != 65535) {
            n2 += ModuleFactory.getIndex(String.valueOf((char)n3));
            n3 = stringCharacterIterator.next();
        }
        n3 = n2 % 43;
        return n3;
    }

    protected Module getPreAmble() {
        return ModuleFactory.START_STOP;
    }

    protected Module getPostAmble() {
        return ModuleFactory.START_STOP;
    }

    private static String validateBasicChars(String string) throws BarcodeException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (!ModuleFactory.hasModule(String.valueOf(c2), false)) {
                throw new BarcodeException("Illegal character - try using extended mode if you need to encode the full ASCII character set");
            }
            c2 = stringCharacterIterator.next();
        }
        return string;
    }

    private static String encodeExtendedChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (!ModuleFactory.hasModule(String.valueOf(c2), true)) {
                stringBuffer.append(ModuleFactory.getExtendedCharacter(c2));
            } else {
                stringBuffer.append(c2);
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    protected Dimension draw(GraphicsOutput graphicsOutput, int n2, int n3, double d2, double d3) {
        return null;
    }

    protected Dimension draw(AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        return null;
    }
}

