/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.core.group;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.cache.list.IntList;
import com.fr.data.SingleRowNameSpace;
import com.fr.data.impl.GroupList;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.report.cell.cellattr.core.group.Group;
import com.fr.report.cell.cellattr.core.group.MonoGrouper;
import com.fr.report.cell.cellattr.core.group.RecordGrouper;
import com.fr.report.core.utils.ScriptUtils;
import com.fr.script.Calculator;
import com.fr.stable.Primitive;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FunctionGrouper
extends RecordGrouper {
    public static final int GROUPING_MODE = 0;
    public static final int LIST_MODE = 1;
    public static final int CONTINUUM_MODE = 2;
    private int divideMode = 0;
    private boolean isCustom = false;
    private String formulaContent = null;

    public boolean isCustom() {
        return this.isCustom;
    }

    public void setCustom(boolean bl) {
        this.isCustom = bl;
    }

    public int getDivideMode() {
        return this.divideMode;
    }

    public void setDivideMode(int n2) {
        this.divideMode = n2;
    }

    public String getFormulaContent() {
        return this.formulaContent;
    }

    public void setFormulaContent(String string) {
        this.formulaContent = string;
    }

    public Group[] group(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        if (n2 == -1) {
            return super.group(dataModel, n2, nArray, calculator);
        }
        if (nArray == null) {
            try {
                nArray = IntList.range(dataModel.getRowCount());
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
        SingleRowNameSpace singleRowNameSpace = new SingleRowNameSpace(dataModel, -1, null);
        calculator.pushNameSpace(singleRowNameSpace);
        Group[] groupArray = null;
        groupArray = this.divideMode == 0 ? this.dealGroupMode(nArray, dataModel, n2, calculator, groupArray, singleRowNameSpace) : (this.divideMode == 2 ? this.dealContinuumMode(nArray, dataModel, n2, calculator, groupArray, singleRowNameSpace) : this.dealListMode(nArray, dataModel, n2, calculator, groupArray, singleRowNameSpace));
        calculator.removeNameSpace(singleRowNameSpace);
        return groupArray;
    }

    private Group[] dealGroupMode(int[] nArray, DataModel dataModel, int n2, Calculator calculator, Group[] groupArray, SingleRowNameSpace singleRowNameSpace) {
        Map.Entry entry;
        int n32;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int n32 : nArray) {
            entry = this.current_value(dataModel, n32, n2, singleRowNameSpace, calculator);
            IntList intList = (IntList)linkedHashMap.get(entry);
            if (intList == null) {
                intList = new IntList();
                intList.add(n32);
                linkedHashMap.put(entry, intList);
                continue;
            }
            intList.add(n32);
        }
        int n4 = linkedHashMap.size();
        groupArray = new Group[n4];
        Iterator iterator = linkedHashMap.entrySet().iterator();
        n32 = 0;
        while (iterator.hasNext()) {
            entry = iterator.next();
            groupArray[n32++] = new Group(entry.getKey(), ((IntList)entry.getValue()).toArray());
        }
        return groupArray;
    }

    private Group[] dealContinuumMode(int[] nArray, DataModel dataModel, int n2, Calculator calculator, Group[] groupArray, SingleRowNameSpace singleRowNameSpace) {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        if (nArray.length > 0) {
            int n3 = nArray[0];
            Object object = this.current_value(dataModel, n3, n2, singleRowNameSpace, calculator);
            IntList intList = new IntList();
            intList.add(n3);
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                n3 = nArray[i2];
                Object object2 = this.current_value(dataModel, n3, n2, singleRowNameSpace, calculator);
                if (ComparatorUtils.equals(object, object2)) {
                    intList.add(n3);
                    continue;
                }
                arrayList.add(new Group(object, intList.toArray()));
                object = object2;
                intList = new IntList();
                intList.add(n3);
            }
            arrayList.add(new Group(object, intList.toArray()));
        }
        groupArray = arrayList.toArray(new Group[arrayList.size()]);
        return groupArray;
    }

    private Group[] dealListMode(int[] nArray, DataModel dataModel, int n2, Calculator calculator, Group[] groupArray, SingleRowNameSpace singleRowNameSpace) {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        int n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(new Group(this.current_value(dataModel, nArray[i2], n2, singleRowNameSpace, calculator), new int[]{nArray[i2]}));
        }
        groupArray = arrayList.toArray(new Group[n3]);
        return groupArray;
    }

    public Iterator groupIterator(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
        if (this.divideMode == 1) {
            return new MonoGrouper().groupIterator(dataModel, n2, nArray, calculator);
        }
        return new ContinuumIterator(dataModel, n2, nArray, calculator);
    }

    private Object current_value(DataModel dataModel, int n2, int n3, SingleRowNameSpace singleRowNameSpace, Calculator calculator) {
        Object object = null;
        try {
            object = dataModel.getValueAt(n2, n3);
        }
        catch (TableDataException tableDataException) {
            FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
        }
        if (this.isCustom && this.formulaContent != null) {
            singleRowNameSpace.setRowIndex(n2);
            singleRowNameSpace.setCurrentValue(object);
            object = ScriptUtils.executeNormalFormula(calculator, new Formula(this.formulaContent));
        }
        return object;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attr".equals(string)) {
                this.setDivideMode(xMLableReader.getAttrAsInt("divideMode", 0));
            } else if ("Custom".equals(string)) {
                this.setCustom(xMLableReader.getAttrAsBoolean("isCustom", false));
            } else if ("FC".equals(string)) {
                this.formulaContent = xMLableReader.getElementValue();
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.divideMode != 0) {
            xMLPrintWriter.startTAG("Attr").attr("divideMode", this.divideMode).end();
        }
        if (this.isCustom) {
            xMLPrintWriter.startTAG("Custom").attr("isCustom", this.isCustom).end();
        }
        if (this.formulaContent != null) {
            xMLPrintWriter.startTAG("FC").textNode(this.formulaContent).end();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof FunctionGrouper && this.isCustom == ((FunctionGrouper)object).isCustom && this.divideMode == ((FunctionGrouper)object).divideMode && ComparatorUtils.equals(this.formulaContent, ((FunctionGrouper)object).formulaContent);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void cal_when_traverse_result(GroupList groupList, Object object, int n2) {
        ArrayList arrayList = groupList.getG();
        Map map = groupList.getV_i_map();
        List list = groupList.getV_list();
        List list2 = groupList.getIlist_list();
        IntList intList = (IntList)map.get(object);
        if (intList == null) {
            intList = new IntList();
            intList.add(n2 - 1);
            list.add(object);
            list2.add(intList);
            map.put(object, intList);
            int n3 = list.size() - 1;
            arrayList.add(new com.fr.data.impl.Group(list.get(n3), (IntList)list2.get(n3)));
        } else {
            intList.add(n2 - 1);
        }
    }

    private static class ContinuumIterator
    implements Iterator {
        private DataModel data;
        private int columnIndex;
        private int[] rows;
        private int nextArrayIndex = -1;
        private int nextTableDataIndex = -1;
        private Group nextGroup;
        private int current_group_index = -1;
        private int need_group_index = 0;

        ContinuumIterator(DataModel dataModel, int n2, int[] nArray, Calculator calculator) {
            this.data = dataModel;
            this.columnIndex = n2;
            this.rows = nArray;
        }

        private void nextRowIndex() {
            if (this.rows == null) {
                ++this.nextTableDataIndex;
            } else {
                ++this.nextArrayIndex;
                this.nextTableDataIndex = this.nextArrayIndex >= this.rows.length ? -1 : this.rows[this.nextArrayIndex];
            }
        }

        private Object getObject(int n2) {
            try {
                if (n2 < 0 || !this.data.hasRow(n2)) {
                    return Primitive.NULL;
                }
                if (this.columnIndex == -1) {
                    return new Integer(n2 + 1);
                }
                return this.data.getValueAt(n2, this.columnIndex);
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
                return Primitive.NULL;
            }
        }

        private void findNext() {
            this.nextRowIndex();
            Object object = this.getObject(this.nextTableDataIndex);
            if (ComparatorUtils.equals(object, Primitive.NULL)) {
                this.nextGroup = null;
                return;
            }
            IntList intList = new IntList();
            intList.add(this.nextTableDataIndex);
            int n2 = this.nextTableDataIndex;
            int n3 = this.nextArrayIndex;
            this.nextRowIndex();
            while (this.nextTableDataIndex > n2 && ComparatorUtils.equals(this.getObject(this.nextTableDataIndex), object)) {
                intList.add(this.nextTableDataIndex);
                n2 = this.nextTableDataIndex;
                n3 = this.nextArrayIndex;
                this.nextRowIndex();
            }
            this.nextTableDataIndex = n2;
            this.nextArrayIndex = n3;
            this.nextGroup = new Group(object, intList.toArray());
        }

        public boolean hasNext() {
            while (this.current_group_index < this.need_group_index) {
                this.findNext();
                ++this.current_group_index;
            }
            return this.nextGroup != null;
        }

        public Object next() {
            while (this.current_group_index < this.need_group_index) {
                this.findNext();
                ++this.current_group_index;
            }
            ++this.need_group_index;
            return this.nextGroup;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

