/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page.pageset;

import com.fr.cache.list.IntList;
import com.fr.page.PageSetChainProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.pageset.PageSet;

public class PageSetChain
extends PageSet
implements PageSetChainProvider {
    private ChainInfo[] chainInfos;
    private int pageCount = -1;
    private boolean cumulatePageNumber = true;
    private PageSetChain case4traversing = null;
    private Object traversing_lock = new Object();
    private boolean released = false;

    public PageSetChain(PageSetProvider[] pageSetProviderArray, boolean bl) {
        ChainInfo[] chainInfoArray = new ChainInfo[pageSetProviderArray.length];
        for (int i2 = 0; i2 < pageSetProviderArray.length; ++i2) {
            chainInfoArray[i2] = new ChainInfo(pageSetProviderArray[i2]);
        }
        this.init(chainInfoArray, bl);
    }

    private PageSetChain(ChainInfo[] chainInfoArray, boolean bl) {
        this.init(chainInfoArray, bl);
    }

    private void init(ChainInfo[] chainInfoArray, boolean bl) {
        this.chainInfos = chainInfoArray;
        this.cumulatePageNumber = bl;
        this.initPageCount();
        this.released = false;
    }

    private void initPageCount() {
        this.pageCount = 0;
        for (int i2 = 0; i2 < this.chainInfos.length; ++i2) {
            this.chainInfos[i2].startIndex = this.pageCount;
            if (this.chainInfos[i2].pageSet.isSizePredictable()) {
                this.pageCount += this.chainInfos[i2].pageSet.size();
            } else {
                this.chainInfos[i2].endIndex = Integer.MAX_VALUE;
                this.pageCount = Integer.MAX_VALUE;
                break;
            }
            this.chainInfos[i2].endIndex = this.pageCount - 1;
        }
    }

    public int size() {
        return this.pageCount;
    }

    public boolean isSizePredictable() {
        for (int i2 = 0; i2 < this.chainInfos.length; ++i2) {
            if (this.chainInfos[i2].pageSet.isSizePredictable()) continue;
            return false;
        }
        return true;
    }

    public boolean isPageCached() {
        for (int i2 = 0; i2 < this.chainInfos.length; ++i2) {
            if (this.chainInfos[i2].pageSet.isPageCached()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageSetProvider traverse4Export() {
        Object object = this.traversing_lock;
        synchronized (object) {
            if (this.case4traversing == null) {
                ChainInfo[] chainInfoArray = new ChainInfo[this.chainInfos.length];
                for (int i2 = 0; i2 < chainInfoArray.length; ++i2) {
                    chainInfoArray[i2] = new ChainInfo(this.chainInfos[i2].pageSet.traverse4Export());
                    chainInfoArray[i2].startIndex = this.chainInfos[i2].startIndex;
                    chainInfoArray[i2].endIndex = this.chainInfos[i2].endIndex;
                }
                this.case4traversing = new PageSetChain(chainInfoArray, this.cumulatePageNumber);
            }
        }
        return this.case4traversing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportPageProvider getPage(int n2) {
        if (n2 < 0) {
            return null;
        }
        for (int i2 = 0; i2 < this.chainInfos.length; ++i2) {
            if (this.chainInfos[i2].startIndex > n2 || n2 > this.chainInfos[i2].endIndex || this.chainInfos[i2] == null) continue;
            ReportPageProvider reportPageProvider = this.chainInfos[i2].getReportPage(n2 - this.chainInfos[i2].startIndex);
            if (reportPageProvider == null && this.chainInfos[i2].endIndex == Integer.MAX_VALUE) {
                PageSetChain pageSetChain = this;
                synchronized (pageSetChain) {
                    if (this.chainInfos[i2].endIndex == Integer.MAX_VALUE && this.isSizePredictable()) {
                        this.initPageCount();
                        if (n2 > this.pageCount - 1) {
                            return null;
                        }
                        return this.getPage(n2);
                    }
                }
            }
            if (reportPageProvider != null) {
                if (this.cumulatePageNumber) {
                    reportPageProvider.setCurrentPageNumber(n2 + 1);
                    reportPageProvider.setTotalPages(this.pageCount == Integer.MAX_VALUE ? -1 : this.pageCount);
                } else {
                    reportPageProvider.setCurrentPageNumber(n2 - this.chainInfos[i2].startIndex + 1);
                    if (i2 > 0) {
                        reportPageProvider.setTotalPages(this.chainInfos[i2].endIndex - this.chainInfos[i2 - 1].endIndex);
                    } else {
                        reportPageProvider.setTotalPages(this.chainInfos[i2].endIndex + 1);
                    }
                    reportPageProvider.setBsCurrentPageNumber(n2 + 1);
                    reportPageProvider.setBsTotalPageNumber(this.pageCount == Integer.MAX_VALUE ? -1 : this.pageCount);
                }
            }
            return reportPageProvider;
        }
        return null;
    }

    public int getPageInWhichChain(int n2) {
        int n3 = this.chainInfos.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 < this.chainInfos[i2].startIndex || n2 > this.chainInfos[i2].endIndex) continue;
            return i2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntList getChainPageInfo() {
        if (!this.isPageCached() || !this.isSizePredictable()) {
            return null;
        }
        for (int i2 = 0; i2 < this.chainInfos.length; ++i2) {
            if (this.chainInfos[i2].endIndex != Integer.MAX_VALUE) continue;
            PageSetChain pageSetChain = this;
            synchronized (pageSetChain) {
                if (this.chainInfos[i2].endIndex == Integer.MAX_VALUE) {
                    this.initPageCount();
                    break;
                }
                continue;
            }
        }
        IntList intList = new IntList(this.chainInfos.length);
        for (int i3 = 0; i3 < this.chainInfos.length; ++i3) {
            intList.add(this.chainInfos[i3].startIndex);
        }
        return intList;
    }

    public PageSetProvider getReportPageSet(int n2) {
        if (this.chainInfos == null || this.chainInfos.length <= n2) {
            return null;
        }
        return this.chainInfos[n2].pageSet;
    }

    public void release() {
        for (int i2 = 0; i2 < this.chainInfos.length; ++i2) {
            this.chainInfos[i2].pageSet.release();
        }
        if (this.case4traversing != null) {
            this.case4traversing.release();
        }
        this.released = true;
    }

    public boolean isReleased() {
        return this.released;
    }

    private class ChainInfo {
        private int startIndex;
        private int endIndex;
        private PageSetProvider pageSet;

        private ChainInfo(PageSetProvider pageSetProvider) {
            this.pageSet = pageSetProvider;
        }

        private ReportPageProvider getReportPage(int n2) {
            return this.pageSet.getPage(n2);
        }
    }
}

