/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page;

import com.fr.base.DynamicNumberList;
import com.fr.base.DynamicPixList;
import com.fr.base.Style;
import com.fr.base.chart.BaseChartPainter;
import com.fr.page.ClippedPage;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PagePainterProvider;
import com.fr.report.poly.ResultChartBlock;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UnitRectangle;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.web.output.Outlet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClippedChartPage
extends ClippedPage {
    private ResultChartBlock source_block;
    private UnitRectangle intersect;
    private UNIT effectiveWidth;
    private UNIT effectiveHeight;

    public ClippedChartPage(ResultChartBlock resultChartBlock, UnitRectangle unitRectangle, UNIT uNIT, UNIT uNIT2, int n2, int n3) {
        super(uNIT, uNIT2, n2, n3);
        this.source_block = resultChartBlock;
        this.intersect = unitRectangle;
        this.cal();
    }

    private void cal() {
        UNIT uNIT = this.source_block.getEffectiveWidth();
        this.effectiveWidth = UNIT.min(uNIT, this.intersect.width);
        UNIT uNIT2 = this.source_block.getEffectiveHeight();
        this.effectiveHeight = UNIT.min(uNIT2, this.intersect.height);
    }

    @Override
    public void paintPage(PagePainterProvider pagePainterProvider, Graphics2D graphics2D, int n2) {
        BaseChartPainter baseChartPainter = this.source_block.getChartPainter();
        Graphics graphics = graphics2D.create();
        graphics.translate(this.offsetX.toPixI(n2), this.offsetY.toPixI(n2));
        baseChartPainter.paint(graphics, this.effectiveWidth.toPixI(n2), this.effectiveHeight.toPixI(n2), n2, Style.BORDER_STYLE);
        graphics.dispose();
    }

    @Override
    public <T> T output(Outlet<T> outlet, T t2, Repository repository, String string, NodeVisitor nodeVisitor) throws Exception {
        int n2 = repository.getResolution();
        Dimension dimension = new Dimension(this.effectiveWidth.toPixI(n2), this.effectiveHeight.toPixI(n2));
        return (T)outlet.chartOutput((ClippedPageProvider)this, t2, this.source_block.getChartPainter(), dimension, nodeVisitor);
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UNIT getActualWidth() {
        return this.effectiveWidth;
    }

    @Override
    public UNIT getActualHeight() {
        return this.effectiveHeight;
    }

    @Override
    public int getContentWidth() {
        return this.effectiveWidth.toPixI(this.resolution);
    }

    @Override
    public int getContentHeight() {
        return this.effectiveHeight.toPixI(this.resolution);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public Iterator floatIterator() {
        return null;
    }

    @Override
    public Iterator cellIterator() {
        return null;
    }

    @Override
    public int getColumnCount() {
        return 0;
    }

    @Override
    public int getRowCount() {
        return 0;
    }

    @Override
    public Iterator getRow(int n2) {
        return null;
    }

    @Override
    public FU getColumnWidth(int n2) {
        return null;
    }

    @Override
    public FU getRowHeight(int n2) {
        return null;
    }

    @Override
    public DynamicNumberList getColumnWidthDynamicPixList() {
        return null;
    }

    @Override
    public DynamicNumberList getRowHeightDynamicPixList() {
        return null;
    }

    @Override
    public void setColumnWidthDynamicPixList(DynamicPixList dynamicPixList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowHeightDynamicPixList(DynamicPixList dynamicPixList) {
        throw new UnsupportedOperationException();
    }
}

