/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.cache.list.IntList;
import com.fr.general.Inter;
import com.fr.io.core.ExporterUtils;
import com.fr.io.core.PageExcelExporterReport;
import com.fr.io.exporter.LargeDataPageExcelExporter;
import com.fr.io.exporter.excel.stream.StreamExcel2007Exporter;
import com.fr.io.exporter.poi.wrapper.POIWorkbookAction;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.core.A.A.A;
import com.fr.report.core.A.A.C;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ECReport;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.stable.ExportConstants;
import com.fr.stable.FT;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageExcel2007Exporter<T>
extends StreamExcel2007Exporter<T> {
    public PageExcel2007Exporter(List list) {
        super(list);
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook) throws Exception {
        this.export(outputStream, resultWorkBook, false);
    }

    @Override
    public void export(OutputStream outputStream, ResultWorkBook resultWorkBook, boolean bl) throws Exception {
        if (resultWorkBook == null) {
            throw new Exception("Report can not be null!");
        }
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (!(resultWorkBook.getReport(i2) instanceof A) && !(resultWorkBook.getReport(i2) instanceof C)) continue;
            new LargeDataPageExcelExporter(this.paperSettingList, true).export(outputStream, resultWorkBook, bl);
            return;
        }
        super.export(outputStream, resultWorkBook, bl);
    }

    @Override
    protected void exportBook(ResultWorkBook resultWorkBook, POIWorkbookAction pOIWorkbookAction, List list, List<String> list2, List<Report> list3, boolean bl) throws Exception {
        Object object;
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            object = resultWorkBook.getReport(i2);
            list3.add((Report)object);
        }
        PageSetProvider[] pageSetProviderArray = new PageSetProvider[resultWorkBook.getReportCount()];
        object = new int[resultWorkBook.getReportCount()];
        int n2 = this.wbInnerPageCount(resultWorkBook, pageSetProviderArray, (int[])object, list3);
        for (int i3 = 0; i3 < resultWorkBook.getReportCount(); ++i3) {
            ECReport eCReport;
            try {
                eCReport = (ECReport)list3.get(i3);
            }
            catch (ClassCastException classCastException) {
                throw new Exception(Inter.getLocText("FR-Engine_Excel_Export_Error_For_Overlap"));
            }
            PageSetProvider pageSetProvider = pageSetProviderArray[i3];
            IntList intList = new IntList();
            IntList intList2 = new IntList();
            intList.add(1);
            intList2.add(1);
            int[] nArray = this.calculateXYArea(pageSetProvider, eCReport, intList, intList2);
            int n3 = nArray[0];
            int n4 = nArray[1];
            int n5 = nArray[2];
            int[] nArray2 = new int[]{n3, n4};
            FT fT = new FT((int)object[i3], n2);
            for (int i4 = 0; i4 < intList.size(); ++i4) {
                FT fT2 = new FT(intList.get(i4), i4 != intList.size() - 1 ? intList.get(i4 + 1) : n3 + 1);
                for (int i5 = 0; i5 < intList2.size(); ++i5) {
                    FT fT3 = new FT(intList2.get(i5), i5 != intList2.size() - 1 ? intList2.get(i5 + 1) : n4 + 1);
                    this.innerExportReport(new PageExcelExporterReport(eCReport, pageSetProvider, fT2, fT3, fT, nArray2, n5), resultWorkBook.getReportExportAttr(), resultWorkBook.getReportName(i3) + (i4 == 0 ? "" : "_" + (i4 + 1)) + (i5 == 0 ? "" : "_" + (i5 + 1)), (SXSSFWorkbook)pOIWorkbookAction.getWorkbook(), list, list2, i3);
                }
            }
            if (bl) continue;
            pageSetProvider.release();
        }
    }

    private int wbInnerPageCount(ResultWorkBook resultWorkBook, PageSetProvider[] pageSetProviderArray, int[] nArray, List<Report> list) {
        int n2 = 0;
        for (int i2 = 0; i2 < resultWorkBook.getReportCount(); ++i2) {
            if (resultWorkBook.getReport(i2) == null) continue;
            pageSetProviderArray[i2] = ((ResultReport)list.get(i2)).generateReportPageSet(this.paperSettingList == null || this.paperSettingList.isEmpty() ? null : (PaperSettingProvider)this.paperSettingList.get(i2)).traverse4Export();
            nArray[i2] = n2;
            n2 += pageSetProviderArray[i2].size();
        }
        return n2;
    }

    private int[] calculateXYArea(PageSetProvider pageSetProvider, ECReport eCReport, IntList intList, IntList intList2) {
        ReportSettingsProvider reportSettingsProvider = ReportUtils.getReportSettings(eCReport);
        int n2 = 0;
        int n3 = 0;
        int n4 = reportSettingsProvider.getPageOrder();
        if (n4 == 0) {
            int[] nArray = this.calculateY(pageSetProvider, intList, intList2);
            n2 = nArray[0];
            n3 = nArray[1];
        } else {
            int[] nArray = this.calculateX(pageSetProvider, intList, intList2);
            n2 = nArray[0];
            n3 = nArray[1];
        }
        return new int[]{n2, n3, n4};
    }

    private int[] calculateY(PageSetProvider pageSetProvider, IntList intList, IntList intList2) {
        ClippedPageProvider clippedPageProvider;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < pageSetProvider.size() && n4 < (clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2))).getXY()[1] + 1; ++n2) {
            n4 = clippedPageProvider.getXY()[1] + 1;
            if ((n6 += clippedPageProvider.getRowCount()) <= ExportConstants.MAX_ROWS_2007) continue;
            intList2.add(n4);
            n6 = clippedPageProvider.getRowCount();
        }
        n3 = pageSetProvider.size() / n4;
        for (n2 = 0; n2 < pageSetProvider.size(); n2 += n4) {
            clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2));
            if ((n5 += clippedPageProvider.getColumnCount()) <= ExportConstants.MAX_COLS_2007) continue;
            intList.add(clippedPageProvider.getXY()[0] + 1);
            n5 = clippedPageProvider.getColumnCount();
        }
        return new int[]{n3, n4};
    }

    private int[] calculateX(PageSetProvider pageSetProvider, IntList intList, IntList intList2) {
        ClippedPageProvider clippedPageProvider;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < pageSetProvider.size() && n3 < (clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2))).getXY()[0] + 1; ++n2) {
            n3 = clippedPageProvider.getXY()[0] + 1;
            if ((n5 += clippedPageProvider.getColumnCount()) <= ExportConstants.MAX_COLS_2007) continue;
            intList.add(n3);
            n5 = clippedPageProvider.getColumnCount();
        }
        n4 = pageSetProvider.size() / n3;
        for (n2 = 0; n2 < pageSetProvider.size(); n2 += n3) {
            clippedPageProvider = ExporterUtils.support(pageSetProvider.getPage(n2));
            if ((n6 += clippedPageProvider.getRowCount()) <= ExportConstants.MAX_ROWS_2007) continue;
            intList2.add(clippedPageProvider.getXY()[1] + 1);
            n6 = clippedPageProvider.getRowCount();
        }
        return new int[]{n3, n4};
    }
}

