/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.sql.converter;

import com.fr.general.jsqlparser.JSQLParserException;
import com.fr.general.jsqlparser.expression.Expression;
import com.fr.general.jsqlparser.parser.CCJSqlParserManager;
import com.fr.general.jsqlparser.statement.select.PlainSelect;
import com.fr.general.jsqlparser.statement.select.Select;
import com.fr.general.jsqlparser.statement.select.SelectBody;
import com.fr.general.jsqlparser.statement.select.Union;
import com.fr.general.sql.converter.NotEqual;
import com.fr.general.sql.converter.NullNoRecordConverter;
import com.fr.general.sql.converter.PlainSelectNoRecordConverter;
import com.fr.general.sql.converter.UnionNoRecordConverter;
import java.io.StringReader;

public abstract class NoRecordConverter {
    private static CCJSqlParserManager parserManager = new CCJSqlParserManager();
    protected static final Expression NOT_EQUAL = NotEqual.getInstance();
    private boolean isConverted = false;

    public static String convert(String string) throws JSQLParserException {
        NoRecordConverter noRecordConverter = NoRecordConverter.create(string);
        return noRecordConverter.getConvertedSql();
    }

    protected static NoRecordConverter create(String string) throws JSQLParserException {
        SelectBody selectBody = ((Select)parserManager.parse(new StringReader(string))).getSelectBody();
        return NoRecordConverter.wrapWithConverter(selectBody);
    }

    protected static NoRecordConverter wrapWithConverter(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            return new PlainSelectNoRecordConverter((PlainSelect)selectBody);
        }
        if (selectBody instanceof Union) {
            return new UnionNoRecordConverter((Union)selectBody);
        }
        return new NullNoRecordConverter(selectBody);
    }

    protected String getConvertedSql() {
        if (!this.isConverted) {
            this.convert();
            this.isConverted = true;
        }
        return this.getSql();
    }

    protected abstract String getSql();

    public abstract void convert();
}

