/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.stable.StringUtils;
import com.fr.stable.date.YearDate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class DateUtils {
    public static final DateFormat DATEFORMAT1 = new SimpleDateFormat("yyyy/MM/dd");
    public static final DateFormat DATEFORMAT2 = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DATEFORMAT3 = new SimpleDateFormat("dd/MM/yyyy");
    public static final DateFormat DATEFORMAT4 = new SimpleDateFormat("MM/dd/yyyy");
    public static final DateFormat DATEFORMAT5 = new SimpleDateFormat("yyyyMMdd");
    public static final DateFormat DATETIMEFORMAT1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static final DateFormat DATETIMEFORMAT2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat DATETIMEFORMAT3 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final DateFormat DATETIMEFORMAT4 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    public static final DateFormat DATETIMEFORMAT5 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
    public static final DateFormat DATETIMEFORMAT6 = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
    public static final DateFormat TIMEFORMAT = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat TIMEFORMAT2 = new SimpleDateFormat("HHmm");
    public static final String[] dateRegex = new String[]{" *\\d{4}/ *\\d{1,2}/ *\\d{1,2} +\\d{1,2}: *\\d{1,2}: *\\d{1,2} *", " *\\d{4}- *\\d{1,2}- *\\d{1,2} +\\d{1,2}: *\\d{1,2}: *\\d{1,2} *", " *\\d{4}- *\\d{1,2}- *\\d{1,2} +\\d{1,2}: *\\d{1,2} *", " *\\d{4}/ *\\d{1,2}/ *\\d{1,2} +\\d{1,2}: *\\d{1,2} *", "... ... .. ..:..:.. ... ....", " *\\d{4}\\. *\\d{1,2}\\. *\\d{1,2}\\. *\\d{1,2}\\. *\\d{1,2}\\. *\\d{1,2}\\. *\\d{1,3} *", " *\\d{4}/ *\\d{1,2}/ *\\d{1,2} *", " *\\d{4}- *\\d{1,2}- *\\d{1,2} *", " *\\d{1,2}/ *\\d{1,2}/ *\\d{4} *", "..:..:.."};
    public static final DateFormat[] dataFormatArray = new DateFormat[]{DATETIMEFORMAT1, DATETIMEFORMAT2, DATETIMEFORMAT3, DATETIMEFORMAT4, DATETIMEFORMAT5, DATETIMEFORMAT6, DATEFORMAT1, DATEFORMAT2, DATEFORMAT3, TIMEFORMAT};
    private static final int VALUE1000000 = 1000000;
    private static final int VALUE25569 = 25569;
    private static final int VALUE1000 = 1000;
    private static final int VALUE24 = 24;
    private static final int VALUE60 = 60;
    private static final int VALUE3600 = 3600;
    private static final int VALUE30 = 30;
    private static final int VALUE31 = 31;
    private static final int VALUE28 = 28;
    private static final int VALUE29 = 29;
    private static final int VALUE365 = 365;
    private static final int VALUE7 = 7;
    private static final int VALUE4 = 4;
    private static final int VALUE100 = 100;
    private static int recentRegexIndex = 0;
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
    public static final String SECOND = "s";
    public static final String MINUTE = "m";
    public static final String HOUR = "h";
    public static final String DAY = "d";
    public static final String WEEK = "w";
    private static final long ZERO = 0L;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_YEAR = 31536000000L;

    private DateUtils() {
    }

    public static synchronized String getDate2Str(String string, Date date) {
        simpleDateFormat.applyPattern(string);
        return simpleDateFormat.format(date);
    }

    public static String getDate2LStr(Date date) {
        return DateUtils.getDate2Str("yyyy-MM-dd HH:mm:ss", date);
    }

    public static String getDate2AllIncludeSSS(Date date) {
        return DateUtils.getDate2Str("yyyyMMddHmmssSSS", date);
    }

    public static Date createDate(int n2, int n3, int n4) {
        return DateUtils.createDate(n2, n3, n4, 0, 0, 0);
    }

    public static Date createDate(int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.set(1, n2);
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        calendar.set(11, n5);
        calendar.set(12, n6);
        calendar.set(13, n7);
        return calendar.getTime();
    }

    public static Date object2Date(Object object, boolean bl) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Calendar) {
            date = ((Calendar)object).getTime();
        } else if (object instanceof Number) {
            long l2 = ((Number)object).longValue();
            date = l2 > 1000000L ? new Date(l2) : new Date((l2 - 25569L) * 1000L * 24L * 60L * 60L);
        } else if (object != null) {
            String string = GeneralUtils.objectToString(object);
            date = string.startsWith("-") ? new Date(Long.parseLong(string)) : DateUtils.string2Date(string, bl);
        }
        if (!bl && date == null) {
            date = new Date();
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date IntegerForm2Date(String string) throws ParseException {
        String string2;
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String string3 = string2 = "";
        synchronized (string3) {
            return DATEFORMAT5.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date string2Date(String string, boolean bl) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        if (string.matches("^\\d+$")) {
            Long l2;
            try {
                l2 = Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (string.length() > 3) {
                    try {
                        l2 = Long.valueOf(string.substring(0, string.length() - 3));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new RuntimeException("can't cast String to Long! might too long or contain error String value", numberFormatException2);
                    }
                }
                throw new RuntimeException("can't cast String to Long! might too long or contain error String value", numberFormatException);
            }
            return DateUtils.object2Date(l2, true);
        }
        if (string.matches("\\d{1,2}/\\d{1,2}/\\d{4}")) {
            try {
                String string2;
                String string3 = string2 = "";
                synchronized (string3) {
                    return DATEFORMAT4.parse(string);
                }
            }
            catch (ParseException parseException) {
                FRLogger.getLogger().error(string + " can't be parsed to Date");
            }
        }
        return DateUtils.transDate(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date transDate(String string, boolean bl) {
        int n2;
        if (ComparatorUtils.equals(string, "#VALUE?") || ComparatorUtils.equals(string, "#NAME?")) {
            return bl ? null : new Date();
        }
        int n3 = recentRegexIndex;
        int n4 = -1;
        if (string.matches(dateRegex[n3])) {
            n4 = n3;
        } else {
            for (n2 = 0; n2 < dateRegex.length; ++n2) {
                if (n2 == n3 || !string.matches(dateRegex[n2])) continue;
                n4 = n2;
                recentRegexIndex = n2;
                break;
            }
        }
        if (n4 == -1) {
            int n5 = dataFormatArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                try {
                    DateFormat dateFormat = dataFormatArray[n2];
                    synchronized (dateFormat) {
                        return dataFormatArray[n2].parse(string);
                    }
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            if (bl) {
                return null;
            }
            FRLogger.getLogger().error(string + " can't be parsed to Date");
        } else {
            try {
                DateFormat dateFormat = dataFormatArray[n4];
                synchronized (dateFormat) {
                    return dataFormatArray[n4].parse(string);
                }
            }
            catch (ParseException parseException) {
                FRLogger.getLogger().error(string + " can't be parsed to Date" + parseException);
            }
        }
        return new Date();
    }

    public static long subtractDate(Date date, Date date2, String string) {
        long l2 = date.getTime();
        long l3 = date2.getTime();
        long l4 = l2 - l3;
        if (ComparatorUtils.equals(SECOND, string)) {
            return l4 / 1000L;
        }
        if (ComparatorUtils.equals(MINUTE, string)) {
            return l4 / 60000L;
        }
        if (ComparatorUtils.equals(HOUR, string)) {
            return l4 / 3600000L;
        }
        if (ComparatorUtils.equals(DAY, string)) {
            return l4 / 86400000L;
        }
        if (ComparatorUtils.equals(WEEK, string)) {
            return l4 / 604800000L;
        }
        return l4 / 86400000L;
    }

    public static Date datePlusInteger(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        long l2 = date.getTime();
        return new Date(l2 += (long)n2 * 24L * 3600L * 1000L);
    }

    public static YearDate date2Year(Object object) {
        Comparable<Date> comparable;
        YearDate yearDate = null;
        if (object instanceof String) {
            comparable = DateUtils.string2Date(object.toString(), true);
            if (comparable != null) {
                object = comparable;
            } else if (Pattern.compile("^\\d{4}").matcher((String)object).find()) {
                yearDate = new YearDate(((String)object).substring(0, 4));
            }
        }
        if (object instanceof Date) {
            comparable = Calendar.getInstance();
            ((Calendar)comparable).setTime((Date)object);
            yearDate = new YearDate(String.valueOf(((Calendar)comparable).get(1)));
        }
        return yearDate;
    }

    public static int getMonthMaxDays(int n2, int n3) {
        switch (n3) {
            case 0: {
                return 31;
            }
            case 1: {
                return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0 ? 29 : 28;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 31;
            }
            case 5: {
                return 30;
            }
            case 6: {
                return 31;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 30;
            }
            case 9: {
                return 31;
            }
            case 10: {
                return 30;
            }
            case 11: {
                return 31;
            }
        }
        return 0;
    }

    public static String timeCostFrom(long l2) {
        return DateUtils.miliisecondCostAsString(System.currentTimeMillis() - l2);
    }

    public static String miliisecondCostAsString(long l2) {
        if (l2 < 0L) {
            return Inter.getLocText("FR-Base-Time_Back_In_Time");
        }
        if (l2 < 1000L) {
            return l2 + Inter.getLocText("FR-Base-Time_Milliseconds");
        }
        if (l2 < 60000L) {
            return l2 / 1000L + Inter.getLocText("FR-Base-Time_Second");
        }
        if (l2 < 3600000L) {
            return l2 / 60000L + Inter.getLocText("FR-Base-Time_Minute") + DateUtils.miliisecondCostAsString(l2 % 60000L);
        }
        if (l2 < 86400000L) {
            return l2 / 3600000L + Inter.getLocText("FR-Base-Time_Hour") + DateUtils.miliisecondCostAsString(l2 % 3600000L);
        }
        if (l2 < 31536000000L) {
            return l2 / 86400000L + Inter.getLocText("FR-Base-Time_Day") + DateUtils.miliisecondCostAsString(l2 % 86400000L);
        }
        return l2 / 31536000000L + Inter.getLocText("FR-Base-Time_Year") + DateUtils.miliisecondCostAsString(l2 % 31536000000L);
    }
}

