/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.data.Dictionary;
import com.fr.form.ui.WriteUnableRepeatEditor;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class ButtonGroup
extends WriteUnableRepeatEditor {
    private int columnsInRow;
    private boolean isAdaptive = true;

    public boolean isEditor() {
        return false;
    }

    public int getColumnsInRow() {
        return this.columnsInRow;
    }

    public void setColumnsInRow(int n2) {
        this.columnsInRow = n2;
    }

    public void setAdaptive(boolean bl) {
        this.isAdaptive = bl;
    }

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    public int[] getValueType() {
        return new int[]{1, 2, 3};
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "statechange"};
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (this.columnsInRow > 0) {
            jSONObject.put("columnsInRow", this.columnsInRow);
        }
        if (this.isAdaptive()) {
            jSONObject.put("adaptive", true);
        }
        if (nodeVisitor != null) {
            nodeVisitor.visit("needcache", jSONObject);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("BGAttr")) {
                this.columnsInRow = xMLableReader.getAttrAsInt("columnsInRow", 0);
            } else if (string.equals("NotAdaptive")) {
                this.setAdaptive(false);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.columnsInRow > 0) {
            xMLPrintWriter.startTAG("BGAttr").attr("columnsInRow", this.columnsInRow).end();
        }
        if (!this.isAdaptive()) {
            xMLPrintWriter.startTAG("NotAdaptive").end();
        }
    }

    public boolean equals(Object object) {
        return object instanceof ButtonGroup && super.equals(object) && this.columnsInRow == ((ButtonGroup)object).columnsInRow && this.isAdaptive == ((ButtonGroup)object).isAdaptive;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 17 * n2 + this.columnsInRow;
        n2 = 17 * n2 + (this.model != null ? this.model.hashCode() : 0);
        return n2 += super.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        ButtonGroup buttonGroup = (ButtonGroup)super.clone();
        if (this.model != null) {
            buttonGroup.model = (Dictionary)this.model.clone();
        }
        return buttonGroup;
    }
}

