/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ExcelUtils;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.AbstractDataModel;
import com.fr.general.FRLogger;
import com.fr.general.data.TableDataException;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Sheet;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Workbook;
import com.fr.third.v2.org.apache.poi.ss.usermodel.WorkbookFactory;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class ExcelDataModel
extends AbstractDataModel {
    private int columnCount = 0;
    private List<Object> columnNameList = new ArrayList<Object>();
    private List<Object[]> rowDataList = new ArrayList<Object[]>();
    private boolean needColumnName;
    private String filePath;
    private Parameter[] params;

    public ExcelDataModel(String string, boolean bl, Parameter[] parameterArray) {
        this.filePath = string;
        this.needColumnName = bl;
        this.params = parameterArray;
    }

    public int getColumnCount() throws TableDataException {
        this.initData();
        return this.columnCount;
    }

    public String getColumnName(int n2) throws TableDataException {
        this.initData();
        String string = "#" + (n2 + 1);
        if (this.needColumnName) {
            return n2 < this.columnNameList.size() ? this.columnNameList.get(n2).toString() : string;
        }
        return string;
    }

    public int getRowCount() throws TableDataException {
        this.initData();
        return this.rowDataList.size();
    }

    public Object getValueAt(int n2, int n3) throws TableDataException {
        this.initData();
        if (n3 >= this.rowDataList.get(n2).length) {
            return null;
        }
        return this.rowDataList.get(n2)[n3];
    }

    private void initData() {
        if (!this.rowDataList.isEmpty()) {
            return;
        }
        try {
            ExcelUtils.checkThirdJarPOI();
            this.initExcel7Data();
        }
        catch (Exception exception) {
            this.initExcel3Data();
        }
        if (this.needColumnName && this.rowDataList.size() > 0) {
            this.columnNameList = Arrays.asList((Object[])this.rowDataList.get(0));
            this.rowDataList.remove(0);
        }
    }

    private void initExcel3Data() {
        try {
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(this.getfileInputStream());
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
            int n2 = hSSFWorkbook.getNumberOfSheets();
            for (int i2 = 0; i2 < n2; ++i2) {
                HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i2);
                int n3 = hSSFSheet.getFirstRowNum();
                int n4 = hSSFSheet.getLastRowNum();
                if (n4 == 0 && hSSFSheet.getRow(0) == null) continue;
                for (int i3 = n3; i3 <= n4; ++i3) {
                    HSSFRow hSSFRow = hSSFSheet.getRow(i3);
                    if (hSSFRow == null) continue;
                    short s2 = hSSFRow.getLastCellNum();
                    if (s2 > this.columnCount) {
                        this.columnCount = s2;
                    }
                    Object[] objectArray = new Object[this.columnCount];
                    for (int i4 = 0; i4 < this.columnCount; ++i4) {
                        HSSFCell hSSFCell = hSSFRow.getCell(i4);
                        objectArray[i4] = ExcelUtils.getHSSFCellValueNoFormula(hSSFCell);
                    }
                    this.rowDataList.add(objectArray);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRLogger.getLogger().error(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    private void initExcel7Data() {
        try {
            InputStream inputStream = this.getfileInputStream();
            if (inputStream == null) {
                return;
            }
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            int n2 = workbook.getNumberOfSheets();
            for (int i2 = 0; i2 < n2; ++i2) {
                Sheet sheet = workbook.getSheetAt(i2);
                int n3 = sheet.getFirstRowNum();
                int n4 = sheet.getLastRowNum();
                if (n4 == 0 && sheet.getRow(0) == null) continue;
                for (int i3 = n3; i3 <= n4; ++i3) {
                    Row row = sheet.getRow(i3);
                    short s2 = row.getLastCellNum();
                    if (s2 > this.columnCount) {
                        this.columnCount = s2;
                    }
                    Object[] objectArray = new Object[this.columnCount];
                    for (int i4 = 0; i4 < this.columnCount; ++i4) {
                        Cell cell = row.getCell(i4, Row.CREATE_NULL_AS_BLANK);
                        objectArray[i4] = ExcelUtils.getCellValueNoFormula(cell);
                    }
                    this.rowDataList.add(objectArray);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public void release() throws Exception {
    }

    private InputStream getfileInputStream() {
        try {
            this.filePath = ParameterHelper.analyze4Templatee(this.filePath, this.params);
            if (this.filePath.indexOf("http") != -1) {
                URL uRL = new URL(this.filePath);
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getInputStream();
            }
            return new FileInputStream(this.filePath);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }
}

