/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.tableObject.AbstractTableObject;
import com.fr.data.core.db.tableObject.Column;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.DataInitJob;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.ForeignKey;
import com.fr.data.dao.ForeignKeyInfo;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.UniqueKey;
import com.fr.general.FRLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ObjectMappingTable
extends AbstractTableObject {
    private ObjectTableMapper mapper;
    protected List<ForeignKey> foreignKeyList = new ArrayList<ForeignKey>();
    protected List<DataInitJob> initJobList = null;

    private ObjectMappingTable(ObjectTableMapper objectTableMapper) {
        this.mapper = objectTableMapper;
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        if (fieldColumnMapperArray != null) {
            for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                Column column = fieldColumnMapperArray[i2].createTableColumn();
                this.addColumn(column);
            }
        }
        this.checkTableExistLevel = objectTableMapper.checkTableExistLevel;
    }

    public Table getTable() {
        return this.mapper.getTable();
    }

    public static ObjectMappingTable createObjectMappingTable(ObjectTableMapper objectTableMapper, Map map) {
        ObjectMappingTable objectMappingTable = new ObjectMappingTable(objectTableMapper);
        FieldColumnMapper[] fieldColumnMapperArray = objectTableMapper.getFieldColumnMappers();
        if (fieldColumnMapperArray != null) {
            for (int i2 = 0; i2 < fieldColumnMapperArray.length; ++i2) {
                ObjectTableMapper objectTableMapper2;
                ForeignKeyInfo foreignKeyInfo;
                Class clazz;
                if (!fieldColumnMapperArray[i2].isForeignKey() || (clazz = (foreignKeyInfo = fieldColumnMapperArray[i2].getForeignKeyInfo()).getRelatedClass()) == null || (objectTableMapper2 = (ObjectTableMapper)map.get(clazz.getName())) == null) continue;
                String string = foreignKeyInfo.isReferencesPrimaryKey() ? objectTableMapper2.getPrimaryKey().getColumnName() : foreignKeyInfo.getRelatedColumnName();
                String string2 = foreignKeyInfo.getForeignKeyName();
                if (string2 == null) {
                    StringBuffer stringBuffer = new StringBuffer("fr_fk_");
                    if (objectTableMapper.getTable().getName().startsWith("FR_T_")) {
                        stringBuffer.append(objectTableMapper.getTable().getName().substring("FR_T_".length()));
                    } else {
                        stringBuffer.append(objectTableMapper.getTable().getName());
                    }
                    stringBuffer.append("__").append(foreignKeyInfo.getColumnName().substring(0, 1));
                    string2 = stringBuffer.toString();
                }
                ForeignKey foreignKey = new ForeignKey(string2, new String[]{foreignKeyInfo.getColumnName()}, objectTableMapper2.getTable().getName(), new String[]{string}, foreignKeyInfo.isReferencesPrimaryKey(), foreignKeyInfo.isDelCascade());
                objectMappingTable.addForeignKey(foreignKey);
            }
            UniqueKey[] uniqueKeyArray = objectTableMapper.getUniqueKeys();
            if (uniqueKeyArray != null) {
                for (int i3 = 0; i3 < uniqueKeyArray.length; ++i3) {
                    objectMappingTable.addUniqueKey(uniqueKeyArray[i3]);
                }
            }
            objectMappingTable.addDataInitJob(objectTableMapper.getDataInitJob());
        }
        return objectMappingTable;
    }

    protected void initColumns() {
    }

    public void createTable(Connection connection) {
        super.createTable(connection);
    }

    public void addForeignKey(ForeignKey foreignKey) {
        if (foreignKey != null) {
            this.foreignKeyList.add(foreignKey);
        }
    }

    public void removeAllForeignKey() {
        this.foreignKeyList.clear();
    }

    public void addDataInitJob(DataInitJob dataInitJob) {
        if (dataInitJob == null) {
            return;
        }
        if (this.initJobList == null) {
            this.initJobList = new ArrayList<DataInitJob>();
        }
        this.initJobList.add(dataInitJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createForeignKey(Connection connection) {
        if (!this.newTable) {
            return;
        }
        Statement statement = null;
        try {
            String string = null;
            Dialect dialect = null;
            int n2 = this.foreignKeyList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ForeignKey foreignKey = this.foreignKeyList.get(i2);
                if (i2 == 0) {
                    try {
                        dialect = DialectFactory.generateDialect(connection);
                        statement = connection.createStatement();
                    }
                    catch (SQLException sQLException) {
                        FRLogger.getLogger().error("Create Dialect/Statement Error : " + sQLException.getMessage(), sQLException);
                        break;
                    }
                }
                try {
                    string = foreignKey.createAddForeignKeySql(this.getTable(), dialect);
                    FRLogger.getLogger().info("Create ForeignKey SQL :" + string);
                    statement.executeUpdate(string);
                    continue;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().error("Create ForeignKey Error: " + sQLException.getMessage() + "\n + SQL: " + string, sQLException);
                }
            }
        }
        finally {
            if (statement != null) {
                DBUtils.closeStatement(statement);
                statement = null;
            }
        }
    }

    public void initData(DataAccessObjectSession dataAccessObjectSession) {
        if (this.initJobList != null) {
            int n2 = this.initJobList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                DataInitJob dataInitJob = this.initJobList.get(i2);
                try {
                    dataInitJob.initData(dataAccessObjectSession, this.newTable);
                    continue;
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(dataInitJob.errorMessage() + " : " + exception.getMessage(), exception);
                }
            }
        }
    }
}

