/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core.db.dialect;

import com.fr.base.StoreProcedureParameter;
import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.AbstractDialect;
import com.fr.data.core.db.dialect.TriggerAction;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.field.FieldMessage;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDialect
extends AbstractDialect {
    private static int QUERY_STRING_LENGTH = 16;
    private String defaultAutoIncrease = "identity(1,1)";

    public MSSQLDialect() {
        this.left_quote = "[";
        this.right_quote = "]";
    }

    @Override
    public String createSequence(Connection connection, String string, String string2, String string3) {
        return new StringBuffer().append(string3).append(' ').append(this.defaultAutoIncrease).toString();
    }

    @Override
    protected String getIdentitySelectString() throws Exception {
        return "select @@identity";
    }

    @Override
    public boolean supportsLimitOffset(String string) {
        return false;
    }

    @Override
    public String getLimitString(String string, int n2, int n3) {
        if (n2 > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuffer(string.length() + QUERY_STRING_LENGTH).append(string).insert(MSSQLDialect.getAfterSelectInsertPoint(string), " top " + n3).toString();
    }

    static int getAfterSelectInsertPoint(String string) {
        String string2 = "select";
        String string3 = "select distinct";
        int n2 = string.toLowerCase().indexOf(string2);
        int n3 = string.toLowerCase().indexOf(string3);
        return n2 + (n3 == n2 ? string3.length() : string2.length());
    }

    @Override
    public String defaultValidationQuery(Connection connection) {
        return "select 1";
    }

    @Override
    public String getCountSql(String string) {
        return string == null ? null : "SELECT COUNT(*) AS totalRowCount FROM (" + string + ") t";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreProcedureParameter[] getStoreProcedureDeclarationParameters(Connection connection, String string, String string2) {
        StoreProcedureParameter[] storeProcedureParameterArray;
        ArrayList<StoreProcedureParameter> arrayList = new ArrayList<StoreProcedureParameter>();
        String[] stringArray = string.split("\\.");
        String string3 = stringArray[stringArray.length - 1];
        String string4 = this.getProcedureParametersSql(string3);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string4);
            int n2 = 1;
            while (resultSet.next()) {
                storeProcedureParameterArray = resultSet.getString("parameter");
                String string5 = resultSet.getString("type");
                boolean bl = resultSet.getBoolean("inOut");
                string5 = string5 == null ? "" : string5;
                int n3 = string5.toUpperCase().indexOf("CURSOR") > -1 ? -10 : this.sql2ColumnTypeForProcedure(string5);
                int n4 = bl ? 0x7FFFFFFC : 0x7FFFFFFE;
                StoreProcedureParameter storeProcedureParameter = string5.toUpperCase().indexOf("VARCHAR") != -1 && StringUtils.isNotEmpty(string2) ? new StoreProcedureParameter(storeProcedureParameterArray == null ? "storeParameter" + n2 : (storeProcedureParameterArray.length() > 1 ? storeProcedureParameterArray.substring(1) : "storeParameter" + n2), string2, n4, n3) : new StoreProcedureParameter(storeProcedureParameterArray == null ? "storeParameter" + n2 : (storeProcedureParameterArray.length() > 1 ? storeProcedureParameterArray.substring(1) : "storeParameter" + n2), n4, n3);
                arrayList.add(storeProcedureParameter);
                ++n2;
            }
            storeProcedureParameterArray = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
            Object var18_19 = null;
        }
        catch (SQLException sQLException) {
            StoreProcedureParameter[] storeProcedureParameterArray2;
            try {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
                storeProcedureParameterArray2 = arrayList.toArray(new StoreProcedureParameter[arrayList.size()]);
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return storeProcedureParameterArray2;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return storeProcedureParameterArray;
    }

    @Override
    public String getProcedureParametersSql(String string) {
        return "select a.name AS parameter, c.name AS type ,a.isoutparam AS inOut  from   syscolumns  a,sysobjects  b,systypes  c  where  a.id=b.id  and  LOWER(b.xtype)= 'p' and b.name='" + string + "' and  a.xusertype=c.xusertype ORDER BY  a.colorder";
    }

    @Override
    protected String getProcedureSql(String string) {
        return "sp_helptext '" + string + "'";
    }

    @Override
    protected String getValueName() {
        return "Text";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTableCommentName(Connection connection, String string, String string2, String string3) {
        ResultSet resultSet;
        Statement statement;
        block6: {
            String string4;
            statement = null;
            resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(this.getTableCommentExpression(connection, string, string2));
                    if (!resultSet.next()) break block6;
                    string4 = resultSet.getString("table_comment");
                    Object var9_9 = null;
                }
                catch (SQLException sQLException) {
                    FRLogger.getLogger().log(Level.WARNING, sQLException.getMessage());
                    Object var9_11 = null;
                    DBUtils.closeResultSet(resultSet);
                    DBUtils.closeStatement(statement);
                    return "";
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                throw throwable;
            }
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            return string4;
        }
        Object var9_10 = null;
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FieldMessage> getTableFieldsMessage(Connection connection, String string, String string2, String string3) {
        List<FieldMessage> list = super.getTableFieldsMessage(connection, string, string2, string3);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(this.getFieldsInforExpression(connection.getCatalog(), string, string2));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (resultSet.next()) {
                    hashMap.put(resultSet.getString("COLUMN_NAME"), resultSet.getString("COLUMN_COMMENT"));
                }
                for (FieldMessage fieldMessage : list) {
                    String string4 = fieldMessage.getColumnName();
                    if (!hashMap.containsKey(string4)) continue;
                    fieldMessage.setColumnComment((String)hashMap.get(string4));
                }
                Object var13_13 = null;
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().log(Level.WARNING, sQLException.getMessage());
                Object var13_14 = null;
                DBUtils.closeResultSet(resultSet);
                DBUtils.closeStatement(statement);
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            DBUtils.closeResultSet(resultSet);
            DBUtils.closeStatement(statement);
            throw throwable;
        }
        DBUtils.closeResultSet(resultSet);
        DBUtils.closeStatement(statement);
        return list;
    }

    protected String getTableCommentExpression(Connection connection, String string, String string2) {
        return "select CAST(F.value AS nvarchar) table_comment from (select name,id from " + string2 + ".sysobjects s where s.xtype='U' and s.name='" + string + "') O Left join sys.extended_properties F on O.id=F.major_id and F.minor_id= 0";
    }

    protected String getFieldsInforExpression(String string, String string2, String string3) {
        return "select sys.columns.name as column_name, CAST((select value from sys.extended_properties where sys.extended_properties.major_id = sys.columns.object_id and sys.extended_properties.minor_id = sys.columns.column_id) AS nvarchar) as column_comment from sys.columns where sys.columns.object_id = object_id('" + (string3 == null ? "" : string3 + ".") + string2 + " ')";
    }

    @Override
    public String getSpecificRowSql(String string, int n2) {
        return "select * from (select t.*, row_number() rk from(" + string + ") t) where rk = " + n2;
    }

    @Override
    public String getRowRangeSql(String string, int n2, int n3, String[] stringArray) {
        String string2 = "select ";
        string2 = stringArray == null || stringArray.length == 0 ? string2 + "*" : string2 + StableUtils.join(stringArray, ",");
        string2 = string2 + " from (select t.*, row_number() raak from(" + string + ") t) where raak > " + n2 + " and raak < " + (n3 + 1);
        return string2;
    }

    @Override
    public Statement createStatement(Connection connection, String string) throws SQLException {
        return connection.prepareCall(string);
    }

    @Override
    public ResultSet executeQuery(Statement statement, String string, Connection connection) throws SQLException {
        try {
            return ((CallableStatement)statement).executeQuery();
        }
        catch (SQLException sQLException) {
            statement = connection.createStatement();
            return statement.executeQuery(string);
        }
    }

    @Override
    public void notifyTriggerChange(Connection connection, Table table, TriggerAction triggerAction) {
        StringBuffer stringBuffer = new StringBuffer();
        if (triggerAction == TriggerAction.DISABLE) {
            stringBuffer.append("set identity_insert ").append(table.toString()).append(" on");
        } else {
            stringBuffer.append("set identity_insert ").append(table.toString()).append(" off");
        }
        this.executeIdInsert(connection, stringBuffer);
    }

    private void executeIdInsert(Connection connection, StringBuffer stringBuffer) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute(stringBuffer.toString());
            statement.close();
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            try {
                statement.close();
            }
            catch (SQLException sQLException2) {
                FRLogger.getLogger().error(sQLException2.getMessage(), sQLException2);
            }
        }
    }
}

