/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.charttypes;

import com.fr.base.CoreDecimalFormat;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.chartattr.Area3DPlot;
import com.fr.chart.chartattr.AreaPlot;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.fun.impl.AbstractIndependentDefaultChartProviderWithAPILevel;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.text.DecimalFormat;

public class AreaIndependentChart
extends AbstractIndependentDefaultChartProviderWithAPILevel {
    public static Chart[] areaChartTypes = AreaIndependentChart.initAreaCharts();

    private static Chart[] initAreaCharts() {
        return new Chart[]{AreaIndependentChart.createAreaChart(true, false), AreaIndependentChart.createAreaChart(true, true), AreaIndependentChart.createArea3DChart(true, false), AreaIndependentChart.createArea3DChart(true, true)};
    }

    public String getChartName() {
        return "ChartF-Area";
    }

    public Chart[] getChartTypes() {
        return areaChartTypes;
    }

    private static Chart createAreaChart(boolean bl, boolean bl2) {
        AreaPlot areaPlot = new AreaPlot();
        ConditionCollection conditionCollection = areaPlot.getConditionCollection();
        AttrAlpha attrAlpha = conditionCollection.getDefaultAttr().getExisted(AttrAlpha.class);
        if (attrAlpha == null) {
            attrAlpha = new AttrAlpha();
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrAlpha);
        }
        attrAlpha.setAlpha(0.7f);
        areaPlot.setStacked(bl);
        AttrMarkerType attrMarkerType = conditionCollection.getDefaultAttr().getExisted(AttrMarkerType.class);
        if (attrMarkerType == null) {
            attrMarkerType = new AttrMarkerType("NullMarker");
            conditionCollection.getDefaultAttr().addDataSeriesCondition(attrMarkerType);
        }
        if (bl2) {
            areaPlot.getyAxis().setPercentage(true);
            areaPlot.getyAxis().setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        }
        ChartFactory.setChartFontAttr(areaPlot);
        return new Chart(areaPlot);
    }

    private static Chart createArea3DChart(boolean bl, boolean bl2) {
        Area3DPlot area3DPlot = new Area3DPlot();
        ChartFactory.setChartFontAttr(area3DPlot);
        area3DPlot.setStacked(bl);
        if (bl2) {
            area3DPlot.getyAxis().setPercentage(true);
            area3DPlot.getyAxis().setFormat(new CoreDecimalFormat(new DecimalFormat("#0%"), "#0%"));
        }
        return new Chart(area3DPlot);
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStart() {
                if (areaChartTypes == null) {
                    areaChartTypes = AreaIndependentChart.initAreaCharts();
                }
            }

            public void onServletStop() {
                areaChartTypes = null;
            }
        });
    }
}

