/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.TopDownShadeChart;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class StackedBarTopDownShadeStyle
extends TopDownShadeChart {
    Rectangle2D rect = null;
    Rectangle2D totalRect = null;
    boolean isHorizontal = false;
    boolean axisReversed;

    public StackedBarTopDownShadeStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2, boolean bl3) {
        this.baseColor = color;
        this.rect = rectangle2D;
        this.totalRect = rectangle2D;
        this.isHorizontal = bl;
        this.avoidOriginDraw = bl2;
        this.axisReversed = bl3;
    }

    public void setTotalRect(Rectangle2D rectangle2D) {
        this.totalRect = rectangle2D;
    }

    public void paintStyle(Graphics graphics) {
        if (this.baseColor == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        if (this.totalRect != null) {
            Color color = new Color(1.0f, 1.0f, 1.0f, 0.0f);
            Color color2 = new Color(1.0f, 1.0f, 1.0f, 0.73f);
            GradientPaint gradientPaint = this.axisReversed ? (this.isHorizontal ? new GradientPaint((float)this.totalRect.getX(), (float)this.totalRect.getY(), color, (float)(this.totalRect.getX() + this.totalRect.getWidth()), (float)this.totalRect.getY(), color2) : new GradientPaint((float)this.totalRect.getX(), (float)(this.totalRect.getY() + this.totalRect.getHeight()), color, (float)this.totalRect.getX(), (float)this.totalRect.getY(), color2)) : (this.isHorizontal ? new GradientPaint((float)(this.totalRect.getX() + this.totalRect.getWidth()), (float)this.totalRect.getY(), color, (float)this.totalRect.getX(), (float)this.totalRect.getY(), color2) : new GradientPaint((float)this.totalRect.getX(), (float)this.totalRect.getY(), color, (float)this.totalRect.getX(), (float)(this.totalRect.getY() + this.totalRect.getHeight()), color2));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(this.totalRect);
        }
        this.drawBorder(graphics2D);
        graphics2D.setPaint(paint);
    }

    private void drawBorder(Graphics2D graphics2D) {
        Color color = this.getLineColor();
        GeneralPath generalPath = this.totalRect != null ? (this.isHorizontal ? (this.axisReversed ? ChartUtils.getBoundsWithoutRight(this.rect) : ChartUtils.getBoundsWithoutLeft(this.rect)) : (this.axisReversed ? ChartUtils.getBoundsWithoutTop(this.rect) : ChartUtils.getBoundsWithoutBottom(this.rect))) : (this.isHorizontal ? ChartUtils.getBoundsTopAndBottom(this.rect) : ChartUtils.getBoundsLeftAndRight(this.rect));
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
    }
}

