/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartComparatorUtils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.chartglyph.MeterInterval;
import com.fr.chart.chartglyph.MeterStyle;
import com.fr.chart.chartglyph.SpecialGlyph;
import com.fr.chart.chartglyph.TextGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.stable.CoreConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class Meter
extends SpecialGlyph {
    private static final long serialVersionUID = 3950923513149375891L;
    private static final double TITLE_GAP = 7.0;
    private static final double BASIC_ANGLE = 90.0;
    protected static final int CIR = 360;
    protected static final int PIE = 180;
    protected static final int CHORD = 270;
    private static final int INTERVAL = 9;
    protected static final double METER_WIDTH_OFF = 8.0;
    private static final int TEN = 10;
    private static final double BASE = 0.09;
    private static final double CURRENT_GAP = 0.18;
    private static final double UNIT_GAP = 0.22;
    private static final double ARC_WIDTH = 0.24;
    private static final double POINTER_INNER = 0.04;
    private static final double POINTER_OUTER = 0.06;
    private static final double POINTER_END = 0.74;
    protected static final double METER_ANOTHER_ANGLE = 190.0;
    protected static final double OFFANGLE = 5.0;
    protected double value;
    protected TextGlyph titleGlyph;
    protected MeterStyle meterStyle;
    protected Rectangle2D bounds;
    protected transient double meterMiddleX;
    protected transient double meterMiddleY;
    protected transient double radius;
    protected transient double startAngle;
    protected transient double extentAngle;
    protected transient int joinType;
    protected transient double maxOuterSize = 0.0;
    protected transient double arcWidth = 0.0;
    protected transient Dimension2D titleDim = new DoubleDimension2D(0.0, 0.0);
    protected Arc2D meterShape;

    public Meter() {
    }

    public Meter(TextGlyph textGlyph, double d2, MeterStyle meterStyle) {
        this.setTitle(textGlyph);
        this.setValue(d2);
        this.meterStyle = meterStyle;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void draw(Graphics graphics, int n2) {
        this.resetBeforeDraw();
        this.initTransientValue(n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.bounds.getX(), this.bounds.getY());
        if (this.radius > 0.0) {
            int n3 = this.meterStyle.getIntervalCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.drawArcForInterval(graphics2D, this.meterStyle.getInterval(i2), i2);
            }
            this.drawTicks(graphics2D, n2);
            this.drawDisplay(graphics2D, n2);
            this.drawArrow(graphics2D);
        }
        this.drawTitle(graphics2D, n2);
        graphics2D.translate(-this.bounds.getX(), -this.bounds.getY());
    }

    protected void drawTitle(Graphics2D graphics2D, int n2) {
        if (this.titleGlyph != null && this.meterStyle.isShowCateName()) {
            this.titleGlyph.setBounds(new Rectangle2D.Double(this.meterMiddleX - this.titleDim.getWidth() / 2.0, this.meterMiddleY - this.titleDim.getHeight() - this.radius, this.titleDim.getWidth(), this.titleDim.getHeight()));
            this.getTitle().draw(graphics2D, n2);
        }
    }

    public void resetBeforeDraw() {
        this.meterStyle.clearAllInterval();
        this.meterStyle.convertAreaColor2List(this.value);
        double d2 = this.getTickSize();
        this.meterStyle.setTickSize(new Formula(Double.toString(d2)));
        this.resetAutoMax();
    }

    private void dealWhenPlus() {
        this.meterStyle.clearAllInterval();
        double d2 = 0.0;
        double d3 = d2 + this.meterStyle.getTickSizeFormula() * 9.0 * this.getOrder();
        this.meterStyle.setStartValue(new Formula(Double.toString(d2)));
        this.meterStyle.setEndValue(new Formula(Double.toString(d3)));
        MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart-Meter_Field"), new Formula("" + d2), new Formula("" + d3 / 3.0));
        meterInterval.setBackgroundColor(new Color(231, 71, 62));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart-Meter_Field"), new Formula("" + d3 / 3.0), new Formula("" + 2.0 * d3 / 3.0));
        meterInterval.setBackgroundColor(new Color(252, 210, 9));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart-Meter_Field"), new Formula("" + 2.0 * d3 / 3.0), new Formula("" + d3));
        meterInterval.setBackgroundColor(new Color(77, 184, 73));
        this.meterStyle.addInterval(meterInterval);
    }

    private void dealWhenMinus() {
        this.meterStyle.clearAllInterval();
        double d2 = this.meterStyle.getTickSizeFormula();
        double d3 = -d2 * 9.0 * this.getOrder();
        double d4 = 0.0;
        this.meterStyle.setStartValue(new Formula(Double.toString(d3)));
        this.meterStyle.setEndValue(new Formula(Double.toString(d4)));
        MeterInterval meterInterval = new MeterInterval(Inter.getLocText("Chart-Meter_Field"), new Formula("" + d3), new Formula("" + d3 * 2.0 / 3.0));
        meterInterval.setBackgroundColor(new Color(231, 71, 62));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart-Meter_Field"), new Formula("" + d3 * 2.0 / 3.0), new Formula("" + d3 / 3.0));
        meterInterval.setBackgroundColor(new Color(252, 210, 9));
        this.meterStyle.addInterval(meterInterval);
        meterInterval = new MeterInterval(Inter.getLocText("Chart-Meter_Field"), new Formula("" + d3 / 3.0), new Formula("" + d4));
        meterInterval.setBackgroundColor(new Color(77, 184, 73));
        this.meterStyle.addInterval(meterInterval);
    }

    private void resetAutoMax() {
        if (this.meterStyle.getDesignType() == 0) {
            if (this.value < 0.0) {
                this.dealWhenMinus();
            } else {
                this.dealWhenPlus();
            }
        }
    }

    private Dimension2D getCurrentValueDim(int n2) {
        double d2 = this.dealWithDoubleValue(this.value / this.getOrder());
        String string = new Double(d2).toString();
        return GlyphUtils.calculateTextDimensionWithNoRotation(string, this.meterStyle.getValueTextAttr(), n2);
    }

    protected double dealWithDoubleValue(double d2) {
        DecimalFormat decimalFormat = new DecimalFormat("##.##");
        return Double.parseDouble(decimalFormat.format(d2));
    }

    protected double getOrder() {
        int n2 = this.meterStyle.getOrder();
        return Math.pow(10.0, n2);
    }

    private double getTickSize() {
        double d2 = this.getOrder();
        double d3 = (this.meterStyle.getEndValueFormula() - this.meterStyle.getStartValueResult()) / d2;
        if (d3 < 10.0) {
            BigDecimal bigDecimal = new BigDecimal(Double.toString(0.09));
            BigDecimal bigDecimal2 = new BigDecimal(Double.toString(this.meterStyle.getEndValueFormula() / d2));
            BigDecimal bigDecimal3 = new BigDecimal(Double.toString(this.meterStyle.getStartValueResult() / d2));
            BigDecimal bigDecimal4 = bigDecimal2.subtract(bigDecimal3);
            while (bigDecimal4.doubleValue() > 1.0) {
                bigDecimal4 = bigDecimal4.divide(bigDecimal4, 10, 6);
                bigDecimal = bigDecimal.multiply(new BigDecimal(Double.toString(10.0)));
            }
            bigDecimal4 = bigDecimal;
            while (bigDecimal4.doubleValue() < bigDecimal2.subtract(bigDecimal3).doubleValue()) {
                bigDecimal4 = bigDecimal4.add(bigDecimal);
            }
            return bigDecimal4.doubleValue() / 9.0;
        }
        double d4 = 0.09;
        double d5 = this.meterStyle.getEndValueFormula() / d2;
        double d6 = this.meterStyle.getStartValueResult() / d2;
        double d7 = d5 - d6;
        while (d7 > 1.0) {
            d7 /= 10.0;
            d4 *= 10.0;
        }
        for (d7 = d4; d7 < d5 - d6; d7 += d4) {
        }
        return d7 / 9.0;
    }

    protected void initTransientValue(int n2) {
        if (this.titleGlyph != null) {
            String string = this.titleGlyph.getText();
            this.titleDim = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.getMeterStyle().getTitleTextAttr(), n2);
        }
        if (this.meterStyle.getMaxArrowAngle() <= 180) {
            this.meterStyle.setMeterAngle(180);
        } else if (this.meterStyle.getMaxArrowAngle() <= 270) {
            this.meterStyle.setMeterAngle(270);
        } else {
            this.meterStyle.setMeterAngle(360);
        }
        double d2 = 6.0;
        double d3 = 6.0;
        double d4 = this.bounds.getWidth() - 8.0 - d2;
        double d5 = this.bounds.getHeight() - 8.0 - d3 - this.titleDim.getHeight();
        this.meterMiddleX = this.bounds.getWidth() / 2.0;
        this.calculateMiddleYAndRadius(d4, d5, n2);
        this.arcWidth = 0.24 * this.radius;
        this.calculateMeterShape();
    }

    protected void calculateMiddleYAndRadius(double d2, double d3, int n2) {
        int n3;
        this.radius = this.meterStyle.getMeterAngle() == 360 ? Math.min(d2, d3) / 2.0 : ((n3 = this.getMeterStyle().getMeterAngle()) > 180 ? Math.min(d3 / (1.0 + Math.sin((double)((n3 - 180) / 2) * Math.PI / 180.0)), d2 / 2.0) : Math.min(d3, d2 / 2.0));
        this.meterMiddleY = this.radius + this.titleDim.getHeight();
        this.adjuetRadius(d2, d3, n2);
    }

    protected void adjuetRadius(double d2, double d3, int n2) {
        int n3 = this.getMeterStyle().getMeterAngle();
        double d4 = this.getCurrentValueDim(n2).getHeight() + this.radius * 0.18;
        if (this.meterMiddleY + d4 > this.bounds.getHeight()) {
            d3 -= this.meterMiddleY + d4 - this.bounds.getHeight();
        }
        d2 = Math.max(0.0, d2);
        d3 = Math.max(0.0, d3);
        this.radius = n3 == 360 ? Math.min(d2, d3) / 2.0 : (n3 > 180 ? Math.min(d3 / (1.0 + Math.sin((double)((n3 - 180) / 2) * Math.PI / 180.0)), d2 / 2.0) : Math.min(d3, d2 / 2.0));
        this.meterMiddleY = this.radius + this.titleDim.getHeight();
        this.meterMiddleY = Math.max(this.meterMiddleY, this.bounds.getHeight() / 2.0);
    }

    protected void calculateMeterShape() {
        this.startAngle = this.valueToAngle(this.meterStyle.getStartValueResult(), this.getMeterStyle().getMeterAngle());
        this.extentAngle = this.valueToAngle(this.meterStyle.getEndValueFormula(), this.getMeterStyle().getMeterAngle()) - this.startAngle;
        this.joinType = 0;
        if (this.meterStyle.getMeterAngle() >= 180) {
            this.joinType = 1;
            if (this.meterStyle.getMeterAngle() == 360) {
                this.joinType = 0;
                this.extentAngle = 360.0;
            }
        } else {
            this.joinType = 2;
        }
        this.meterShape = (double)this.meterStyle.getMeterAngle() < 190.0 ? new Arc2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius, 2.0 * this.radius, 2.0 * this.radius, this.startAngle + 5.0, this.extentAngle - 10.0, this.joinType) : new Arc2D.Double(this.meterMiddleX - this.radius, this.meterMiddleY - this.radius, 2.0 * this.radius, 2.0 * this.radius, this.startAngle, this.extentAngle, this.joinType);
    }

    private void drawArrow(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.getColor4CurrentValue());
        if (this.getValue() >= this.meterStyle.getStartValueResult() && this.getValue() < this.meterStyle.getEndValueFormula()) {
            double d2 = this.valueToAngle(this.value, this.meterStyle.getMaxArrowAngle());
            double d3 = this.meterMiddleX + 0.74 * this.radius * Math.cos(Math.PI * d2 / 180.0);
            double d4 = this.meterMiddleY - 0.74 * this.radius * Math.sin(Math.PI * d2 / 180.0);
            double d5 = this.meterMiddleX + this.radius * 0.06 * Math.cos(Math.PI * (d2 - 90.0) / 180.0);
            double d6 = this.meterMiddleY - this.radius * 0.06 * Math.sin(Math.PI * (d2 - 90.0) / 180.0);
            double d7 = this.meterMiddleX + this.radius * 0.06 * Math.cos(Math.PI * (d2 + 90.0) / 180.0);
            double d8 = this.meterMiddleY - this.radius * 0.06 * Math.sin(Math.PI * (d2 + 90.0) / 180.0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)d3, (float)d4);
            generalPath.lineTo((float)d5, (float)d6);
            generalPath.lineTo((float)d7, (float)d8);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            double d9 = this.radius * 0.06;
            Arc2D.Double double_ = new Arc2D.Double(this.meterMiddleX - d9, this.meterMiddleY - d9, 2.0 * d9, 2.0 * d9, 0.0, 360.0, 2);
            graphics2D.fill(double_);
            graphics2D.setPaint(Color.white);
            double d10 = this.radius * 0.04;
            Arc2D.Double double_2 = new Arc2D.Double(this.meterMiddleX - d10, this.meterMiddleY - d10, 2.0 * d10, 2.0 * d10, 0.0, 360.0, 2);
            graphics2D.fill(double_2);
        }
        graphics2D.setPaint(paint);
    }

    protected Color getColor4CurrentValue() {
        int n2 = this.meterStyle.getIntervalCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MeterInterval meterInterval = this.meterStyle.getInterval(i2);
            if (!(meterInterval.getStartValueResult() <= this.value) || !(meterInterval.getEndValueResult() > this.value)) continue;
            return meterInterval.getBackgroundColor();
        }
        return Color.black;
    }

    public Shape getShape() {
        if (this.meterShape == null) {
            return this.bounds;
        }
        return new Arc2D.Double(this.meterShape.getX() + this.bounds.getX(), this.meterShape.getY() + this.bounds.getY(), this.meterShape.getWidth(), this.meterShape.getHeight(), this.meterShape.getAngleStart(), this.meterShape.getAngleExtent(), this.meterShape.getArcType());
    }

    protected double valueToAngle(double d2, int n2) {
        double d3 = (double)(n2 / 2) + 90.0;
        return d3 - (d2 -= this.getMeterStyle().getStartValueResult()) / (this.getMeterStyle().getEndValueFormula() - this.getMeterStyle().getStartValueResult()) * (double)n2;
    }

    private void drawArcForInterval(Graphics2D graphics2D, MeterInterval meterInterval, int n2) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(meterInterval.getBackgroundColor());
        graphics2D.setStroke(new BasicStroke(3.0f));
        double d2 = this.deal4Begin(n2, meterInterval);
        double d3 = this.deal4End(n2, meterInterval);
        if (d2 > d3) {
            return;
        }
        double d4 = this.valueToAngle(d2, this.getMeterStyle().getMaxArrowAngle());
        double d5 = this.valueToAngle(d3, this.getMeterStyle().getMaxArrowAngle());
        double d6 = this.radius - this.arcWidth;
        float f2 = (float)d6;
        while ((double)f2 < this.radius) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.meterMiddleX - (double)f2, this.meterMiddleY - (double)f2, 2.0f * f2, 2.0f * f2);
            graphics2D.draw(new Arc2D.Double(double_, d4, d5 - d4, 0));
            f2 += 1.0f;
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    protected double deal4Begin(int n2, MeterInterval meterInterval) {
        double d2 = this.meterStyle.getIntervalCount();
        double d3 = this.meterStyle.getStartValueResult() + this.extentAngle * (double)n2 / d2;
        Number number = ChartBaseUtils.formula2Number(meterInterval.getBeginValue());
        if (number != null) {
            d3 = number.doubleValue();
        }
        if (d3 < this.meterStyle.getStartValueResult()) {
            d3 = this.meterStyle.getStartValueResult();
        }
        return d3;
    }

    protected double deal4End(int n2, MeterInterval meterInterval) {
        double d2 = this.meterStyle.getIntervalCount();
        double d3 = this.meterStyle.getStartValueResult() + this.extentAngle * (double)(n2 + 1) / d2;
        Number number = ChartBaseUtils.formula2Number(meterInterval.getEndValue());
        if (number != null) {
            d3 = number.doubleValue();
        }
        if (d3 > this.meterStyle.getEndValueFormula()) {
            d3 = this.meterStyle.getEndValueFormula();
        }
        return d3;
    }

    private void drawTicks(Graphics2D graphics2D, int n2) {
        double d2 = this.meterStyle.getTickSizeFormula();
        double d3 = this.getOrder();
        if (d2 > 0.0) {
            double d4;
            double d5;
            double d6 = this.meterStyle.getStartValueResult() / d3;
            if (d6 > (d5 = this.meterStyle.getEndValueFormula() / d3)) {
                return;
            }
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(Color.BLACK);
            GeneralPath generalPath = new GeneralPath();
            BigDecimal bigDecimal = new BigDecimal(Double.toString(d6)).subtract(new BigDecimal(Double.toString(d2)));
            for (d4 = d6; d4 <= d5; d4 += d2) {
                bigDecimal = bigDecimal.add(new BigDecimal(Double.toString(d2)));
                if (d4 != d6 && d4 != d5) {
                    this.drawTickLine(graphics2D, d4 * d3, false, true);
                }
                if (this.meterStyle.getMaxArrowAngle() == 360 && d4 == d5) continue;
                this.drawTickLabel(graphics2D, bigDecimal.doubleValue(), generalPath);
            }
            for (d4 = d6; d4 <= d5; d4 += d2 / 5.0) {
                if ((d4 - d6) % d2 == 0.0) continue;
                this.drawTickLine(graphics2D, d4 * d3, false, false);
            }
            graphics2D.setPaint(paint);
        }
    }

    private void drawTickLine(Graphics2D graphics2D, double d2, boolean bl, boolean bl2) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        double d3 = this.valueToAngle(d2, this.getMeterStyle().getMaxArrowAngle());
        double d4 = this.radius * 0.96;
        double d5 = this.radius * 0.18;
        if (!bl2 && !bl) {
            d5 = this.radius * 0.1;
        }
        double d6 = this.meterMiddleX + d4 * Math.cos(Math.PI * (d3 / 180.0));
        double d7 = this.meterMiddleY - d4 * Math.sin(Math.PI * (d3 / 180.0));
        double d8 = this.meterMiddleX + (d4 - d5) * Math.cos(Math.PI * (d3 / 180.0));
        double d9 = this.meterMiddleY - (d4 - d5) * Math.sin(Math.PI * (d3 / 180.0));
        graphics2D.setStroke(new BasicStroke(this.radius > 100.0 ? 1.2f : 0.8f, 1, 1));
        graphics2D.setColor(Color.white);
        graphics2D.draw(new Line2D.Double(d8, d9, d6, d7));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private void drawTickLabel(Graphics2D graphics2D, double d2, GeneralPath generalPath) {
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        if (this.meterStyle.isTickLabelsVisible()) {
            double d3 = this.getOrder();
            double d4 = this.valueToAngle(d2 * d3, this.getMeterStyle().getMaxArrowAngle());
            String string = this.meterStyle.getUnitFormat() != null ? this.meterStyle.getUnitFormat().format(Double.valueOf(Utils.doubleToString(d2))).toString() : Utils.doubleToString(this.dealWithDoubleValue(d2));
            graphics2D.setPaint(new Color(51, 51, 51));
            float f2 = 9.0f;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setFont(FRFont.getInstance("Verdana", 0, f2));
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = this.getTextBounds(string, graphics2D, fontMetrics);
            double d5 = this.radius * 0.76 - this.getMaxTickLableDim().getWidth();
            double d6 = this.meterMiddleX + d5 * Math.cos(Math.PI * (d4 / 180.0)) - rectangle2D.getWidth() / 2.0;
            double d7 = this.meterMiddleY - d5 * Math.sin(Math.PI * (d4 / 180.0));
            Rectangle2D.Double double_ = new Rectangle2D.Double(d6, d7, rectangle2D.getWidth(), rectangle2D.getHeight());
            if (!generalPath.intersects(double_)) {
                generalPath.append(double_, false);
                graphics2D.drawString(string, (float)d6, (float)d7);
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    public Dimension2D getMaxTickLableDim() {
        double d2 = this.getOrder();
        double d3 = this.meterStyle.getStartValueResult() / d2;
        double d4 = this.meterStyle.getEndValueFormula() / d2;
        double d5 = this.meterStyle.getTickSizeFormula();
        Font font = new Font("Verdana", 0, 9);
        Rectangle2D rectangle2D = font.getStringBounds("", CoreConstants.DEFAULT_FRC);
        for (double d6 = d3; d6 <= d4; d6 += d5) {
            double d7 = this.dealWithDoubleValue(d6);
            String string = Utils.doubleToString(d7).trim();
            Rectangle2D rectangle2D2 = font.getStringBounds(string, CoreConstants.DEFAULT_FRC);
            if (!(rectangle2D2.getWidth() > rectangle2D.getWidth())) continue;
            rectangle2D = rectangle2D2;
        }
        return new DoubleDimension2D(rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    private void drawDisplay(Graphics2D graphics2D, int n2) {
        Font font = graphics2D.getFont();
        String string = "No value";
        string = Utils.doubleToString(this.dealWithDoubleValue(this.getValue() / this.getOrder()));
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string, this.meterStyle.getValueTextAttr(), n2);
        double d2 = dimension2D.getHeight();
        double d3 = dimension2D.getWidth();
        double d4 = this.meterMiddleX - dimension2D.getWidth() / 2.0;
        double d5 = this.meterMiddleY + this.radius * 0.06;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d3, d2);
        this.drawContentInDisPlayer(graphics2D, string, double_, n2);
        graphics2D.setFont(font);
    }

    private void drawContentInDisPlayer(Graphics2D graphics2D, String string, Rectangle2D rectangle2D, int n2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.meterStyle.getValueTextAttr().setFRFontColor(this.getColor4CurrentValue());
        GlyphUtils.drawStrings(graphics2D, string, this.meterStyle.getValueTextAttr(), rectangle2D, n2);
        String string2 = this.meterStyle.getUnits();
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(string2, this.meterStyle.getUnitTextAttr(), n2);
        double d2 = this.meterMiddleX - dimension2D.getWidth() / 2.0;
        double d3 = this.meterMiddleY - this.radius * 0.22 - dimension2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
        GlyphUtils.drawStrings(graphics2D, string2, this.meterStyle.getUnitTextAttr(), double_, n2);
    }

    private Rectangle2D getTextBounds(String string, Graphics2D graphics2D, FontMetrics fontMetrics) {
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = fontMetrics.getFont().getLineMetrics(string, graphics2D.getFontRenderContext());
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), lineMetrics.getHeight());
        return rectangle2D;
    }

    public void setMeterStyle(MeterStyle meterStyle) {
        this.meterStyle = meterStyle;
    }

    public MeterStyle getMeterStyle() {
        return this.meterStyle;
    }

    public void setValue(double d2) {
        this.value = d2;
    }

    public double getValue() {
        return this.value;
    }

    public void setTitle(TextGlyph textGlyph) {
        this.titleGlyph = textGlyph;
    }

    public TextGlyph getTitle() {
        return this.titleGlyph;
    }

    public boolean equals(Object object) {
        return object instanceof Meter && ChartComparatorUtils.equals(((Meter)object).getBounds(), this.getBounds()) && ((Meter)object).getValue() == this.getValue() && ComparatorUtils.equals(((Meter)object).getMeterStyle(), this.getMeterStyle()) && ComparatorUtils.equals(((Meter)object).getTitle(), this.getTitle());
    }

    public Object clone() throws CloneNotSupportedException {
        Meter meter = (Meter)super.clone();
        if (this.meterStyle != null) {
            meter.setMeterStyle((MeterStyle)this.meterStyle.clone());
        }
        if (this.bounds != null) {
            meter.setBounds((Rectangle2D)this.bounds.clone());
        }
        if (this.titleGlyph != null) {
            meter.setTitle((TextGlyph)this.titleGlyph.clone());
        }
        return meter;
    }
}

