/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.background.ColorBackground;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Iterator;
import org.apache.batik.ext.awt.LinearGradientPaint;

public class Cubic
extends GeneralGlyph
implements Object3D {
    private static final long serialVersionUID = 7339367968061606971L;
    public static final byte TOP = 0;
    public static final byte BOTTOM = 1;
    public static final byte LEFT = 2;
    public static final byte RIGHT = 3;
    public static final byte FRONT = 4;
    public static final byte BACK = 5;
    private float x = 0.0f;
    private float y = 0.0f;
    private float z = 0.0f;
    private float width;
    private float height;
    private boolean isHorizontal = false;
    private float deep = 60.0f;
    private byte[] covers = new byte[]{0, 3, 4};
    private Projection projection = new Projection();
    private Point2D[] points = new Point2D[8];
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final int SEVEN = 7;

    public Cubic() {
    }

    public Cubic(double d2, double d3, double d4, double d5) {
        this.x = (float)d2;
        this.y = (float)d3;
        this.width = (float)d4;
        this.height = (float)d5;
    }

    public void setCovers(byte[] byArray) {
        this.covers = byArray;
    }

    public void setCubicWidthHeight(double d2, double d3) {
        this.width = (float)d2;
        this.height = (float)d3;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setIsHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    public void setCubicPosition(double d2, double d3) {
        this.x = (float)d2;
        this.y = (float)d3;
    }

    public double getGapWidth() {
        Point2D[] point2DArray = this.getPoints();
        return Math.abs(point2DArray[4].getX() - point2DArray[0].getX());
    }

    public double getGapHeight() {
        Point2D[] point2DArray = this.getPoints();
        return Math.abs(point2DArray[0].getY() - point2DArray[4].getY());
    }

    public Point2D[] getPoints() {
        this.init();
        return this.points;
    }

    public Point2D getBasePoint() {
        return this.getPoints()[4];
    }

    public void setCubic(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.x = (float)d2;
        this.y = (float)d3;
        this.z = (float)d4;
        this.width = (float)d5;
        this.height = (float)d6;
        this.deep = (float)d7;
    }

    public double getDeep() {
        return this.deep;
    }

    public void setDeep(double d2) {
        this.deep = (float)d2;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public double getZ() {
        return this.z;
    }

    public void setProjection(Projection projection) {
        this.projection = this.projection;
    }

    public void draw(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        this.init();
        Background background = this.getBackground();
        Color color = null;
        if (background instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
            color = ((ColorBackground)background).getColor();
        }
        if (color != null) {
            this.paintSides(graphics2D, color);
        }
        graphics2D.setPaint(paint);
    }

    private void paintSides(Graphics2D graphics2D, Color color) {
        LinearGradientPaint linearGradientPaint;
        Point2D point2D;
        Point2D point2D2;
        Color color2 = color;
        Color color3 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.3, 0.35);
        Color color4 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.1, 0.1);
        float[] fArray = new float[]{0.0f, 0.2f, 1.0f};
        Color[] colorArray = new Color[]{color2, color4, color3};
        if (this.isHorizontal) {
            point2D2 = this.points[2];
            point2D = this.points[3];
        } else {
            point2D2 = this.points[2];
            point2D = new Point2D.Double(this.points[0].getX(), this.points[0].getY());
        }
        if (point2D2.getX() != point2D.getX() || point2D2.getY() != point2D.getY()) {
            linearGradientPaint = new LinearGradientPaint(point2D2, point2D, fArray, colorArray);
            graphics2D.setPaint((Paint)linearGradientPaint);
        } else {
            graphics2D.setPaint(color4);
        }
        graphics2D.fill(this.front());
        Color color5 = ChartUtils.getColorFromBaseColor(color, 0.0, 0.1, -0.1);
        Color color6 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.05, 0.2);
        Color color7 = ChartUtils.getColorFromBaseColor(color, 0.0, 0.05, 0.1);
        fArray = new float[]{0.0f, 0.7f, 1.0f};
        colorArray = new Color[]{color5, color6, color7};
        point2D2 = this.points[3];
        point2D = this.points[5];
        if (point2D2.getX() != point2D.getX() || point2D2.getY() != point2D.getY()) {
            linearGradientPaint = new LinearGradientPaint(point2D2, point2D, fArray, colorArray);
            graphics2D.setPaint((Paint)linearGradientPaint);
        } else {
            graphics2D.setPaint(color6);
        }
        graphics2D.fill(this.right());
        Color color8 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.05, 0.05);
        Color color9 = ChartUtils.getColorFromBaseColor(color, 0.0, -0.2, 0.3);
        GradientPaint gradientPaint = new GradientPaint(this.points[0], color8, new Point2D.Double(this.points[0].getX(), this.points[5].getY()), color9);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.top());
    }

    public void draw3DBase(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        this.init();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.18f));
        Color color = new Color(145, 151, 156);
        Color color2 = new Color(198, 205, 210);
        if (this.covers[0] == 1) {
            Point2D.Double double_ = new Point2D.Double(this.points[2].getX(), this.points[6].getY());
            GradientPaint gradientPaint = new GradientPaint(this.points[2], color, double_, color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(this.bottom());
        } else if (this.covers[0] == 2) {
            Point2D.Double double_ = new Point2D.Double(this.points[0].getX(), this.points[4].getY());
            GradientPaint gradientPaint = new GradientPaint(double_, color, this.points[4], color2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(this.left());
        }
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    private void paintBackground(Graphics2D graphics2D) {
        if (this.getBackground() != null) {
            Background background = this.getBrighterBackground();
            Background background2 = this.getDarkerBackground();
            if (this.covers != null) {
                block8: for (int i2 = 0; i2 < this.covers.length; ++i2) {
                    switch (this.covers[i2]) {
                        case 0: {
                            background.paint(graphics2D, this.top());
                            continue block8;
                        }
                        case 1: {
                            background.paint(graphics2D, this.bottom());
                            continue block8;
                        }
                        case 2: {
                            background2.paint(graphics2D, this.left());
                            continue block8;
                        }
                        case 3: {
                            background2.paint(graphics2D, this.right());
                            continue block8;
                        }
                        case 4: {
                            this.getBackground().paint(graphics2D, this.front());
                            continue block8;
                        }
                        case 5: {
                            this.getBackground().paint(graphics2D, this.back());
                            continue block8;
                        }
                    }
                }
            }
        }
    }

    private void paintLine(Graphics2D graphics2D) {
        int n2 = this.getBorderStyle();
        if (n2 != 0 && this.getBorderColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(GraphHelper.getStroke(n2));
            graphics2D.setPaint(this.getBorderColor());
            if (this.covers != null) {
                block8: for (int i2 = 0; i2 < this.covers.length; ++i2) {
                    switch (this.covers[i2]) {
                        case 0: {
                            graphics2D.draw(this.top());
                            continue block8;
                        }
                        case 1: {
                            graphics2D.draw(this.bottom());
                            continue block8;
                        }
                        case 2: {
                            graphics2D.draw(this.left());
                            continue block8;
                        }
                        case 3: {
                            graphics2D.draw(this.right());
                            continue block8;
                        }
                        case 4: {
                            graphics2D.draw(this.front());
                            continue block8;
                        }
                        case 5: {
                            graphics2D.draw(this.back());
                            continue block8;
                        }
                    }
                }
            }
            graphics2D.setStroke(stroke);
        }
    }

    private Background getBrighterBackground() {
        Background background = this.getBackground();
        if (background instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
            background = ColorBackground.getInstance(((ColorBackground)background).getColor().brighter());
        }
        return background;
    }

    private Background getDarkerBackground() {
        Background background = this.getBackground();
        if (background instanceof ColorBackground && ((ColorBackground)background).getColor() != null) {
            background = ColorBackground.getInstance(((ColorBackground)background).getColor().darker());
        }
        return background;
    }

    private void init() {
        this.points[0] = this.projection.projectee(this.x, this.y, this.z);
        this.points[1] = this.projection.projectee(this.x + this.width, this.y, this.z);
        this.points[2] = this.projection.projectee(this.x, this.y + this.height, this.z);
        this.points[3] = this.projection.projectee(this.x + this.width, this.y + this.height, this.z);
        this.points[4] = this.projection.projectee(this.x, this.y, this.z - this.deep);
        this.points[5] = this.projection.projectee(this.x + this.width, this.y, this.z - this.deep);
        this.points[6] = this.projection.projectee(this.x, this.y + this.height, this.z - this.deep);
        this.points[7] = this.projection.projectee(this.x + this.width, this.y + this.height, this.z - this.deep);
    }

    private GeneralPath top() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[0].getX(), (float)this.points[0].getY());
        generalPath.lineTo((float)this.points[1].getX(), (float)this.points[1].getY());
        generalPath.lineTo((float)this.points[5].getX(), (float)this.points[5].getY());
        generalPath.lineTo((float)this.points[4].getX(), (float)this.points[4].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath bottom() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[2].getX(), (float)this.points[2].getY());
        generalPath.lineTo((float)this.points[3].getX(), (float)this.points[3].getY());
        generalPath.lineTo((float)this.points[7].getX(), (float)this.points[7].getY());
        generalPath.lineTo((float)this.points[6].getX(), (float)this.points[6].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath right() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[1].getX(), (float)this.points[1].getY());
        generalPath.lineTo((float)this.points[3].getX(), (float)this.points[3].getY());
        generalPath.lineTo((float)this.points[7].getX(), (float)this.points[7].getY());
        generalPath.lineTo((float)this.points[5].getX(), (float)this.points[5].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath left() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[0].getX(), (float)this.points[0].getY());
        generalPath.lineTo((float)this.points[2].getX(), (float)this.points[2].getY());
        generalPath.lineTo((float)this.points[6].getX(), (float)this.points[6].getY());
        generalPath.lineTo((float)this.points[4].getX(), (float)this.points[4].getY());
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath front() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[0].getX(), (float)this.points[0].getY());
        generalPath.lineTo((float)this.points[1].getX(), (float)this.points[1].getY());
        generalPath.lineTo((float)this.points[3].getX(), (float)this.points[3].getY());
        generalPath.lineTo((float)this.points[2].getX(), (float)this.points[2].getY());
        generalPath.closePath();
        return generalPath;
    }

    public GeneralPath back() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.points[4].getX(), (float)this.points[4].getY());
        generalPath.lineTo((float)this.points[5].getX(), (float)this.points[5].getY());
        generalPath.lineTo((float)this.points[7].getX(), (float)this.points[7].getY());
        generalPath.lineTo((float)this.points[6].getX(), (float)this.points[6].getY());
        generalPath.closePath();
        return generalPath;
    }

    public Shape getFrontShape() {
        this.init();
        return this.front();
    }

    public Shape getOutline4Fill() {
        this.init();
        GeneralPath generalPath = new GeneralPath();
        if (this.covers != null) {
            block8: for (int i2 = 0; i2 < this.covers.length; ++i2) {
                switch (this.covers[i2]) {
                    case 0: {
                        generalPath.append(this.top(), false);
                        continue block8;
                    }
                    case 1: {
                        generalPath.append(this.bottom(), false);
                        continue block8;
                    }
                    case 2: {
                        generalPath.append(this.left(), false);
                        continue block8;
                    }
                    case 3: {
                        generalPath.append(this.right(), false);
                        continue block8;
                    }
                    case 4: {
                        generalPath.append(this.front(), false);
                        continue block8;
                    }
                    case 5: {
                        generalPath.append(this.back(), false);
                        continue block8;
                    }
                }
            }
        }
        return generalPath;
    }

    public Shape getShape() {
        this.init();
        return this.front();
    }

    public Iterator selectableChildren() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean equals(Object object) {
        return object instanceof Cubic && super.equals(object) && ((Cubic)object).getDeep() == (double)this.deep && ComparatorUtils.equals(((Cubic)object).getProjection(), this.projection);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("x", this.x);
        jSONObject.put("y", this.y);
        jSONObject.put("z", this.z);
        jSONObject.put("width", this.width);
        jSONObject.put("height", this.height);
        jSONObject.put("deep", this.deep);
        jSONObject.put("points", this.points);
        jSONObject.put("projection", this.projection.toJSONObject());
        return jSONObject;
    }
}

