/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.base.Shadow;
import com.fr.chart.chartglyph.HighLightChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class BarHighLightStyle
extends HighLightChart {
    protected Rectangle2D rect;
    protected Shadow shadow;
    protected static final int SHADOW_WIDTH = 6;
    protected boolean axisReversed;
    private boolean isHorizontal = false;

    public BarHighLightStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        this(color, rectangle2D, bl, bl2, false);
    }

    public BarHighLightStyle(Color color, Rectangle2D rectangle2D, boolean bl, boolean bl2, boolean bl3) {
        this.baseColor = color;
        this.rect = rectangle2D;
        this.avoidOriginDraw = bl;
        Color color2 = this.baseColor == null ? null : this.baseColor.brighter();
        this.shadow = new Shadow(color2, 12, 0.75f);
        this.axisReversed = bl2;
        this.isHorizontal = bl3;
    }

    public void paintStyle(Graphics graphics) {
        if (this.baseColor == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        double d2 = this.rect.getX();
        double d3 = this.rect.getY();
        double d4 = this.rect.getWidth();
        double d5 = this.rect.getHeight();
        if (d4 <= 6.0 || d5 <= 6.0) {
            ((Graphics2D)graphics).setPaint(this.baseColor);
            ((Graphics2D)graphics).fill(this.rect);
            ((Graphics2D)graphics).setPaint(paint);
            return;
        }
        Rectangle2D.Double double_ = this.axisReversed ? (this.isHorizontal ? new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, d4, d5) : new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, d4, d5)) : (this.isHorizontal ? new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, d4, d5) : new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, d4, d5));
        this.shadow.paint(graphics, double_);
        graphics2D.setPaint(this.getPaint(graphics2D));
        graphics2D.fill(this.getHighLightShape(this.rect));
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setPaint(Color.WHITE);
        graphics2D.draw(this.rect);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    private Paint getPaint(Graphics2D graphics2D) {
        double d2 = this.rect.getX();
        double d3 = this.rect.getY();
        double d4 = this.rect.getWidth();
        double d5 = this.rect.getHeight();
        GradientPaint gradientPaint = this.axisReversed ? (this.isHorizontal ? new GradientPaint((float)d2, (float)d3, this.getPaintStartColor(), (float)(d2 + d4), (float)d3, this.getPaintEndColor()) : new GradientPaint((float)d2, (float)(d3 + d5), this.getPaintStartColor(), (float)d2, (float)d3, this.getPaintEndColor())) : (this.isHorizontal ? new GradientPaint((float)(d2 + d4), (float)d3, this.getPaintStartColor(), (float)d2, (float)d3, this.getPaintEndColor()) : new GradientPaint((float)d2, (float)d3, this.getPaintStartColor(), (float)d2, (float)(d3 + d5), this.getPaintEndColor()));
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.rect);
        gradientPaint = this.axisReversed ? (this.isHorizontal ? new GradientPaint((float)d2, (float)d3, this.getHighLightStartColor(), (float)(d2 + d4), (float)d3, this.getHighLightEndColor()) : new GradientPaint((float)d2, (float)(d3 + d5), this.getHighLightStartColor(), (float)d2, (float)d3, this.getHighLightEndColor())) : (this.isHorizontal ? new GradientPaint((float)(d2 + d4), (float)d3, this.getHighLightStartColor(), (float)d2, (float)d3, this.getHighLightEndColor()) : new GradientPaint((float)d2, (float)d3, this.getHighLightStartColor(), (float)d2, (float)(d3 + d5), this.getHighLightEndColor()));
        return gradientPaint;
    }

    protected Shape getHighLightShape(Rectangle2D rectangle2D) {
        GeneralPath generalPath = new GeneralPath();
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        if (this.axisReversed) {
            if (this.isHorizontal) {
                generalPath.moveTo(f2, f3 + f5 * 2.0f / 3.0f);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2 + f4, f3);
            } else {
                generalPath.moveTo(f2, f3);
                generalPath.lineTo(f2, f3 + f5);
                generalPath.lineTo(f2 + f4 * 2.0f / 3.0f, f3 + f5);
            }
        } else if (this.isHorizontal) {
            generalPath.moveTo(f2, f3);
            generalPath.lineTo(f2 + f4, f3);
            generalPath.lineTo(f2 + f4, f3 + f5 * 2.0f / 3.0f);
        } else {
            generalPath.moveTo(f2, f3 + f5);
            generalPath.lineTo(f2, f3);
            generalPath.lineTo(f2 + f4 * 2.0f / 3.0f, f3);
        }
        generalPath.closePath();
        return generalPath;
    }

    public Color getPaintStartColor() {
        return this.baseColor.brighter();
    }

    public Color getPaintEndColor() {
        return this.baseColor;
    }

    public Color getHighLightStartColor() {
        return new Color(1.0f, 1.0f, 1.0f, 0.6f);
    }

    public Color getHighLightEndColor() {
        return new Color(1.0f, 1.0f, 1.0f, 0.0f);
    }
}

